/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;

public class PopupMenuLauncher
extends MouseAdapter {
    private final JPopupMenu menu;
    private final boolean checkEnabled;

    public PopupMenuLauncher() {
        this(null);
    }

    public PopupMenuLauncher(JPopupMenu jPopupMenu) {
        this(jPopupMenu, false);
    }

    public PopupMenuLauncher(JPopupMenu jPopupMenu, boolean bl) {
        this.menu = jPopupMenu;
        this.checkEnabled = bl;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.processEvent(mouseEvent);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.processEvent(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.processEvent(mouseEvent);
    }

    private void processEvent(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger() && (!this.checkEnabled || mouseEvent.getComponent().isEnabled())) {
            this.launch(mouseEvent);
        }
    }

    public void launch(final MouseEvent mouseEvent) {
        if (this.menu != null) {
            final Component component = mouseEvent.getComponent();
            if (component != null && component.isFocusable() && !component.hasFocus() && component.requestFocusInWindow()) {
                component.addFocusListener(new FocusListener(){

                    public void focusLost(FocusEvent focusEvent) {
                    }

                    public void focusGained(FocusEvent focusEvent) {
                        PopupMenuLauncher.this.menu.show(component, mouseEvent.getX(), mouseEvent.getY());
                        component.removeFocusListener(this);
                    }
                });
            } else {
                this.menu.show(component, mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    public final JPopupMenu getMenu() {
        return this.menu;
    }
}

