/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.server;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;
import org.xml.sax.SAXException;

public class ApiUrlTestTask
extends PleaseWaitRunnable {
    private String url;
    private boolean canceled;
    private boolean success;
    private Component parent;
    private HttpURLConnection connection;

    public ApiUrlTestTask(Component component, String string) throws IllegalArgumentException {
        super(component, I18n.tr("Testing OSM API URL ''{0}''", string), false);
        CheckParameterUtil.ensureParameterNotNull(string, "url");
        this.parent = component;
        this.url = string;
    }

    protected void alertInvalidUrl(String string) {
        HelpAwareOptionPane.showOptionDialog(this.parent, I18n.tr("<html>''{0}'' is not a valid OSM API URL.<br>Please check the spelling and validate again.</html>", string), I18n.tr("Invalid API URL", new Object[0]), 0, HelpUtil.ht("/Preferences/Connection#InvalidAPIUrl"));
    }

    protected void alertInvalidChangesetUrl(String string) {
        HelpAwareOptionPane.showOptionDialog(this.parent, I18n.tr("<html>Failed to build URL ''{0}'' for validating the OSM API server.<br>Please check the spelling of ''{1}'' and validate again.</html>", string, this.getNormalizedApiUrl()), I18n.tr("Invalid API URL", new Object[0]), 0, HelpUtil.ht("/Preferences/Connection#InvalidAPIGetChangesetsUrl"));
    }

    protected void alertConnectionFailed() {
        HelpAwareOptionPane.showOptionDialog(this.parent, I18n.tr("<html>Failed to connect to the URL ''{0}''.<br>Please check the spelling of ''{1}'' and your Internet connection and validate again.</html>", this.url, this.getNormalizedApiUrl()), I18n.tr("Connection to API failed", new Object[0]), 0, HelpUtil.ht("/Preferences/Connection#ConnectionToAPIFailed"));
    }

    protected void alertInvalidServerResult(int n) {
        HelpAwareOptionPane.showOptionDialog(this.parent, I18n.tr("<html>Failed to retrieve a list of changesets from the OSM API server at<br>''{1}''. The server responded with the return code {0} instead of 200.<br>Please check the spelling of ''{1}'' and validate again.</html>", n, this.getNormalizedApiUrl()), I18n.tr("Connection to API failed", new Object[0]), 0, HelpUtil.ht("/Preferences/Connection#InvalidServerResult"));
    }

    protected void alertInvalidChangesetList() {
        HelpAwareOptionPane.showOptionDialog(this.parent, I18n.tr("<html>The OSM API server at ''{0}'' did not return a valid response.<br>It is likely that ''{0}'' is not an OSM API server.<br>Please check the spelling of ''{0}'' and validate again.</html>", this.getNormalizedApiUrl()), I18n.tr("Connection to API failed", new Object[0]), 0, HelpUtil.ht("/Preferences/Connection#InvalidSettings"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancel() {
        this.canceled = true;
        ApiUrlTestTask apiUrlTestTask = this;
        synchronized (apiUrlTestTask) {
            if (this.connection != null) {
                this.connection.disconnect();
            }
        }
    }

    protected void finish() {
    }

    protected String getNormalizedApiUrl() {
        String string = this.url.trim();
        while (string.endsWith("/")) {
            string = string.substring(0, string.lastIndexOf("/"));
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void realRun() throws SAXException, IOException, OsmTransferException {
        BufferedReader bufferedReader = null;
        try {
            String string;
            URL uRL;
            try {
                new URL(this.getNormalizedApiUrl());
            }
            catch (MalformedURLException malformedURLException) {
                this.alertInvalidUrl(this.getNormalizedApiUrl());
                Utils.close(bufferedReader);
                return;
            }
            String string2 = this.getNormalizedApiUrl() + "/0.6/changesets";
            try {
                uRL = new URL(string2);
            }
            catch (MalformedURLException malformedURLException) {
                this.alertInvalidChangesetUrl(string2);
                Utils.close(bufferedReader);
                return;
            }
            Object object = this;
            synchronized (object) {
                this.connection = Utils.openHttpConnection(uRL);
            }
            this.connection.setDoInput(true);
            this.connection.setDoOutput(false);
            this.connection.setRequestMethod("GET");
            this.connection.connect();
            if (this.connection.getResponseCode() != 200) {
                this.alertInvalidServerResult(this.connection.getResponseCode());
                return;
            }
            object = new StringBuilder();
            bufferedReader = new BufferedReader(new InputStreamReader(this.connection.getInputStream()));
            while ((string = bufferedReader.readLine()) != null) {
                ((StringBuilder)object).append(string).append("\n");
            }
            if (!((StringBuilder)object).toString().contains("<osm") || !((StringBuilder)object).toString().contains("</osm>")) {
                this.alertInvalidChangesetList();
                Utils.close(bufferedReader);
                return;
            }
            this.success = true;
            Utils.close(bufferedReader);
        }
        catch (IOException iOException) {
            if (this.canceled) {
                return;
            }
            iOException.printStackTrace();
            this.alertConnectionFailed();
            return;
        }
        finally {
            Utils.close(bufferedReader);
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public boolean isSuccess() {
        return this.success;
    }
}

