/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.awt.BasicStroke;
import java.awt.Color;
import java.io.Serializable;
import java.util.Arrays;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPaintSettings;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.data.osm.visitor.paint.StyledMapRenderer;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.ElemStyle;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.Keyword;
import org.openstreetmap.josm.gui.mappaint.MultiCascade;
import org.openstreetmap.josm.gui.mappaint.mapcss.Instruction;
import org.openstreetmap.josm.tools.Utils;

public class LineElemStyle
extends ElemStyle {
    public static final LineElemStyle UNTAGGED_WAY = LineElemStyle.createSimpleLineStyle(null, false);
    private BasicStroke line;
    public Color color;
    public Color dashesBackground;
    public float offset;
    public float realWidth;
    private BasicStroke dashesLine;

    public static LineElemStyle createSimpleLineStyle(Color color, boolean bl) {
        MultiCascade multiCascade = new MultiCascade();
        Cascade cascade = multiCascade.getOrCreateCascade("default");
        cascade.put("width", Keyword.DEFAULT);
        cascade.put("color", color != null ? color : PaintColors.UNTAGGED.get());
        if (bl) {
            cascade.put("z-index", Float.valueOf(-3.0f));
        }
        return LineElemStyle.createLine(new Environment(null, multiCascade, "default", null));
    }

    protected LineElemStyle(Cascade cascade, float f, BasicStroke basicStroke, Color color, BasicStroke basicStroke2, Color color2, float f2, float f3) {
        super(cascade, f);
        this.line = basicStroke;
        this.color = color;
        this.dashesLine = basicStroke2;
        this.dashesBackground = color2;
        this.offset = f2;
        this.realWidth = f3;
    }

    public static LineElemStyle createLine(Environment environment) {
        return LineElemStyle.createImpl(environment, LineType.NORMAL);
    }

    public static LineElemStyle createLeftCasing(Environment environment) {
        LineElemStyle lineElemStyle = LineElemStyle.createImpl(environment, LineType.LEFT_CASING);
        if (lineElemStyle != null) {
            lineElemStyle.isModifier = true;
        }
        return lineElemStyle;
    }

    public static LineElemStyle createRightCasing(Environment environment) {
        LineElemStyle lineElemStyle = LineElemStyle.createImpl(environment, LineType.RIGHT_CASING);
        if (lineElemStyle != null) {
            lineElemStyle.isModifier = true;
        }
        return lineElemStyle;
    }

    public static LineElemStyle createCasing(Environment environment) {
        LineElemStyle lineElemStyle = LineElemStyle.createImpl(environment, LineType.CASING);
        if (lineElemStyle != null) {
            lineElemStyle.isModifier = true;
        }
        return lineElemStyle;
    }

    private static LineElemStyle createImpl(Environment environment, LineType lineType) {
        float f;
        Serializable serializable;
        Object object;
        Float f2;
        Cascade cascade = environment.mc.getCascade(environment.layer);
        Cascade cascade2 = environment.mc.getCascade("default");
        switch (lineType) {
            case NORMAL: {
                Float f3 = LineElemStyle.getWidth(cascade2, "width", null);
                f2 = LineElemStyle.getWidth(cascade, "width", f3);
                break;
            }
            case CASING: {
                Float f3 = cascade.get(lineType.prefix + "width", null, Float.class, true);
                if (f3 == null && (object = cascade.get(lineType.prefix + "width", null, Instruction.RelativeFloat.class, true)) != null) {
                    f3 = Float.valueOf(((Instruction.RelativeFloat)object).val / 2.0f);
                }
                if (f3 == null) {
                    return null;
                }
                object = LineElemStyle.getWidth(cascade2, "width", null);
                f2 = LineElemStyle.getWidth(cascade, "width", (Float)object);
                if (f2 == null) {
                    f2 = Float.valueOf(0.0f);
                }
                f2 = Float.valueOf(f2.floatValue() + 2.0f * f3.floatValue());
                break;
            }
            case LEFT_CASING: 
            case RIGHT_CASING: {
                f2 = LineElemStyle.getWidth(cascade, lineType.prefix + "width", null);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        if (f2 == null) {
            return null;
        }
        float f4 = cascade.get(lineType.prefix + "real-width", Float.valueOf(0.0f), Float.class).floatValue();
        if (f4 > 0.0f && MapPaintSettings.INSTANCE.isUseRealWidth()) {
            object = environment.osm.get("width");
            if (object == null) {
                object = environment.osm.get("est_width");
            }
            if (object != null) {
                try {
                    f4 = Float.valueOf((String)object).floatValue();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        object = cascade.get("offset", Float.valueOf(0.0f), Float.class);
        switch (lineType) {
            case NORMAL: {
                break;
            }
            case CASING: {
                object = Float.valueOf(((Float)object).floatValue() + cascade.get(lineType.prefix + "offset", Float.valueOf(0.0f), Float.class).floatValue());
                break;
            }
            case LEFT_CASING: 
            case RIGHT_CASING: {
                serializable = LineElemStyle.getWidth(cascade2, "width", null);
                Float f5 = LineElemStyle.getWidth(cascade, "width", (Float)serializable);
                if (f5 == null || f5.floatValue() < 2.0f) {
                    f5 = Float.valueOf(2.0f);
                }
                float f6 = cascade.get(lineType.prefix + "offset", Float.valueOf(0.0f), Float.class).floatValue();
                f6 += f5.floatValue() / 2.0f + f2.floatValue() / 2.0f;
                if (lineType == LineType.RIGHT_CASING) {
                    f6 *= -1.0f;
                }
                object = Float.valueOf(((Float)object).floatValue() + f6);
                break;
            }
        }
        serializable = cascade.get(lineType.prefix + "color", null, Color.class);
        if (lineType == LineType.NORMAL && serializable == null) {
            serializable = cascade.get("fill-color", null, Color.class);
        }
        if (serializable == null) {
            serializable = PaintColors.UNTAGGED.get();
        }
        int n = 255;
        Integer n2 = Utils.color_float2int(cascade.get(lineType.prefix + "opacity", null, Float.class));
        if (n2 != null) {
            n = n2;
        }
        serializable = new Color(((Color)serializable).getRed(), ((Color)serializable).getGreen(), ((Color)serializable).getBlue(), n);
        float[] fArray = cascade.get(lineType.prefix + "dashes", null, float[].class);
        if (fArray != null) {
            boolean bl = false;
            for (float f7 : fArray) {
                if (f7 > 0.0f) {
                    bl = true;
                }
                if (!(f7 < 0.0f)) continue;
                fArray = null;
                break;
            }
            if (!bl || fArray != null && fArray.length == 0) {
                fArray = null;
            }
        }
        float f8 = cascade.get(lineType.prefix + "dashes-offset", Float.valueOf(0.0f), Float.class).floatValue();
        Object object2 = cascade.get(lineType.prefix + "dashes-background-color", null, Color.class);
        if (object2 != null) {
            n2 = Utils.color_float2int(cascade.get(lineType.prefix + "dashes-background-opacity", null, Float.class));
            if (n2 != null) {
                n = n2;
            }
            object2 = new Color(((Color)object2).getRed(), ((Color)object2).getGreen(), ((Color)object2).getBlue(), n);
        }
        Integer n3 = null;
        Keyword keyword = cascade.get(lineType.prefix + "linecap", null, Keyword.class);
        if (keyword != null) {
            if (Utils.equal(keyword.val, "none")) {
                n3 = 0;
            } else if (Utils.equal(keyword.val, "round")) {
                n3 = 1;
            } else if (Utils.equal(keyword.val, "square")) {
                n3 = 2;
            }
        }
        if (n3 == null) {
            n3 = fArray != null ? 0 : 1;
        }
        Integer n4 = null;
        Keyword keyword2 = cascade.get(lineType.prefix + "linejoin", null, Keyword.class);
        if (keyword2 != null) {
            if (Utils.equal(keyword2.val, "round")) {
                n4 = 1;
            } else if (Utils.equal(keyword2.val, "miter")) {
                n4 = 0;
            } else if (Utils.equal(keyword2.val, "bevel")) {
                n4 = 2;
            }
        }
        if (n4 == null) {
            n4 = 1;
        }
        if ((f = cascade.get(lineType.prefix + "miterlimit", Float.valueOf(10.0f), Float.class).floatValue()) < 1.0f) {
            f = 10.0f;
        }
        BasicStroke basicStroke = new BasicStroke(f2.floatValue(), n3, n4, f, fArray, f8);
        BasicStroke basicStroke2 = null;
        if (fArray != null && object2 != null) {
            float[] fArray2 = new float[fArray.length];
            System.arraycopy(fArray, 0, fArray2, 1, fArray.length - 1);
            fArray2[0] = fArray[fArray.length - 1];
            basicStroke2 = new BasicStroke(f2.floatValue(), n3, n4, f, fArray2, fArray2[0] + f8);
        }
        return new LineElemStyle(cascade, lineType.default_major_z_index, basicStroke, (Color)serializable, basicStroke2, (Color)object2, ((Float)object).floatValue(), f4);
    }

    public void paintPrimitive(OsmPrimitive osmPrimitive, MapPaintSettings mapPaintSettings, StyledMapRenderer styledMapRenderer, boolean bl, boolean bl2) {
        Way way = (Way)osmPrimitive;
        boolean bl3 = !this.isModifier && (bl || mapPaintSettings.isShowDirectionArrow()) && !mapPaintSettings.isUseRealWidth();
        boolean bl4 = !this.isModifier && !bl && !mapPaintSettings.isUseRealWidth() && mapPaintSettings.isShowOnewayArrow() && way.hasDirectionKeys();
        boolean bl5 = way.reversedDirection();
        boolean bl6 = bl3 && !bl && mapPaintSettings.isShowHeadArrowOnly();
        Color color = this.dashesBackground;
        BasicStroke basicStroke = this.line;
        BasicStroke basicStroke2 = this.dashesLine;
        if (this.realWidth > 0.0f && mapPaintSettings.isUseRealWidth() && !bl3) {
            float f = (int)(100.0f / (float)(styledMapRenderer.getCircum() / (double)this.realWidth));
            if (f < this.line.getLineWidth()) {
                f = this.line.getLineWidth();
            }
            basicStroke = new BasicStroke(f, this.line.getEndCap(), this.line.getLineJoin(), this.line.getMiterLimit(), this.line.getDashArray(), this.line.getDashPhase());
            if (this.dashesLine != null) {
                basicStroke2 = new BasicStroke(f, this.dashesLine.getEndCap(), this.dashesLine.getLineJoin(), this.dashesLine.getMiterLimit(), this.dashesLine.getDashArray(), this.dashesLine.getDashPhase());
            }
        }
        Color color2 = this.color;
        if (bl) {
            color2 = mapPaintSettings.getSelectedColor(this.color.getAlpha());
        } else if (bl2) {
            color2 = mapPaintSettings.getRelationSelectedColor(this.color.getAlpha());
        } else if (way.isDisabled()) {
            color2 = mapPaintSettings.getInactiveColor();
            color = mapPaintSettings.getInactiveColor();
        }
        styledMapRenderer.drawWay(way, color2, basicStroke, basicStroke2, color, this.offset, bl3, bl6, bl4, bl5);
        if (mapPaintSettings.isShowOrderNumber() && !styledMapRenderer.isInactiveMode()) {
            int n = 0;
            Node node = null;
            for (Node node2 : way.getNodes()) {
                if (node != null) {
                    styledMapRenderer.drawOrderNumber(node, node2, ++n, color2);
                }
                node = node2;
            }
        }
    }

    public boolean isProperLineStyle() {
        return !this.isModifier;
    }

    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        LineElemStyle lineElemStyle = (LineElemStyle)object;
        return Utils.equal(this.line, lineElemStyle.line) && Utils.equal(this.color, lineElemStyle.color) && Utils.equal(this.dashesLine, lineElemStyle.dashesLine) && Utils.equal(this.dashesBackground, lineElemStyle.dashesBackground) && this.offset == lineElemStyle.offset && this.realWidth == lineElemStyle.realWidth;
    }

    public int hashCode() {
        int n = super.hashCode();
        n = 29 * n + this.line.hashCode();
        n = 29 * n + this.color.hashCode();
        n = 29 * n + (this.dashesLine != null ? this.dashesLine.hashCode() : 0);
        n = 29 * n + (this.dashesBackground != null ? this.dashesBackground.hashCode() : 0);
        n = 29 * n + Float.floatToIntBits(this.offset);
        n = 29 * n + Float.floatToIntBits(this.realWidth);
        return n;
    }

    public String toString() {
        return "LineElemStyle{" + super.toString() + "width=" + this.line.getLineWidth() + " realWidth=" + this.realWidth + " color=" + Utils.toString(this.color) + " dashed=" + Arrays.toString(this.line.getDashArray()) + (this.line.getDashPhase() == 0.0f ? "" : " dashesOffses=" + this.line.getDashPhase()) + " dashedColor=" + Utils.toString(this.dashesBackground) + " linejoin=" + this.linejoinToString(this.line.getLineJoin()) + " linecap=" + this.linecapToString(this.line.getEndCap()) + (this.offset == 0.0f ? "" : " offset=" + this.offset) + '}';
    }

    public String linejoinToString(int n) {
        switch (n) {
            case 2: {
                return "bevel";
            }
            case 1: {
                return "round";
            }
            case 0: {
                return "miter";
            }
        }
        return null;
    }

    public String linecapToString(int n) {
        switch (n) {
            case 0: {
                return "none";
            }
            case 1: {
                return "round";
            }
            case 2: {
                return "square";
            }
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum LineType {
        NORMAL("", 3.0f),
        CASING("casing-", 2.0f),
        LEFT_CASING("left-casing-", 2.1f),
        RIGHT_CASING("right-casing-", 2.1f);

        public final String prefix;
        public final float default_major_z_index;

        private LineType(String string2, float f) {
            this.prefix = string2;
            this.default_major_z_index = f;
        }
    }
}

