/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.markerlayer;

import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.Collections;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxLink;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.gui.layer.markerlayer.ButtonMarker;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.OpenBrowser;

public class WebMarker
extends ButtonMarker {
    public final URL webUrl;

    public WebMarker(LatLon latLon, URL uRL, MarkerLayer markerLayer, double d, double d2) {
        super(latLon, "web.png", markerLayer, d, d2);
        this.webUrl = uRL;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = OpenBrowser.displayUrl(this.webUrl.toString());
        if (string != null) {
            JOptionPane.showMessageDialog(Main.parent, "<html><b>" + I18n.tr("There was an error while trying to display the URL for this marker", new Object[0]) + "</b><br>" + I18n.tr("(URL was: ", new Object[0]) + this.webUrl.toString() + ")" + "<br>" + string, I18n.tr("Error displaying URL", new Object[0]), 0);
        }
    }

    public WayPoint convertToWayPoint() {
        WayPoint wayPoint = super.convertToWayPoint();
        GpxLink gpxLink = new GpxLink(this.webUrl.toString());
        gpxLink.type = "web";
        wayPoint.attr.put("meta.links", Collections.singleton(gpxLink));
        return wayPoint;
    }
}

