/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.Color;
import java.util.ArrayList;
import org.openstreetmap.josm.tools.Diff;

class TwoColumnDiff {
    public ArrayList<Item> referenceDiff;
    public ArrayList<Item> currentDiff;
    Object[] reference;
    Object[] current;

    public TwoColumnDiff(Object[] objectArray, Object[] objectArray2) {
        this.reference = objectArray;
        this.current = objectArray2;
        this.referenceDiff = new ArrayList();
        this.currentDiff = new ArrayList();
        this.diff();
    }

    private void diff() {
        Diff diff = new Diff(this.reference, this.current);
        Diff.change change2 = diff.diff_2(false);
        this.twoColumnDiffFromScript(change2, this.reference, this.current);
    }

    private void twoColumnDiffFromScript(Diff.change change2, Object[] objectArray, Object[] objectArray2) {
        int n = 0;
        int n2 = 0;
        while (change2 != null) {
            int n3 = change2.deleted;
            int n4 = change2.inserted;
            while (n < change2.line0 && n2 < change2.line1) {
                Item item = new Item(Item.DiffItemType.SAME, objectArray[n]);
                this.referenceDiff.add(item);
                this.currentDiff.add(item);
                ++n;
                ++n2;
            }
            while (n4 > 0 || n3 > 0) {
                if (n4 > 0 && n3 > 0) {
                    this.referenceDiff.add(new Item(Item.DiffItemType.CHANGED, objectArray[n++]));
                    this.currentDiff.add(new Item(Item.DiffItemType.CHANGED, objectArray2[n2++]));
                } else if (n4 > 0) {
                    this.referenceDiff.add(new Item(Item.DiffItemType.EMPTY, null));
                    this.currentDiff.add(new Item(Item.DiffItemType.INSERTED, objectArray2[n2++]));
                } else if (n3 > 0) {
                    this.referenceDiff.add(new Item(Item.DiffItemType.DELETED, objectArray[n++]));
                    this.currentDiff.add(new Item(Item.DiffItemType.EMPTY, null));
                }
                --n4;
                --n3;
            }
            change2 = change2.link;
        }
        while (n < objectArray.length && n2 < objectArray2.length) {
            this.referenceDiff.add(new Item(Item.DiffItemType.SAME, objectArray[n++]));
            this.currentDiff.add(new Item(Item.DiffItemType.SAME, objectArray2[n2++]));
        }
    }

    public static class Item {
        public final Object value;
        public final DiffItemType state;

        public Item(DiffItemType diffItemType, Object object) {
            this.state = diffItemType;
            this.value = diffItemType == DiffItemType.EMPTY ? null : object;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum DiffItemType {
            INSERTED(new Color(221, 255, 221)),
            DELETED(new Color(255, 197, 197)),
            CHANGED(new Color(255, 234, 213)),
            SAME(new Color(234, 234, 234)),
            EMPTY(new Color(234, 234, 234));

            private final Color color;

            private DiffItemType(Color color) {
                this.color = color;
            }

            public Color getColor() {
                return this.color;
            }
        }
    }
}

