/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.validator;

import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.data.validation.util.MultipleNameVisitor;
import org.openstreetmap.josm.gui.dialogs.validator.ValidatorTreeRenderer;
import org.openstreetmap.josm.tools.Destroyable;
import org.openstreetmap.josm.tools.MultiMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatorTreePanel
extends JTree
implements Destroyable {
    private static final long serialVersionUID = 2952292777351992696L;
    protected DefaultTreeModel valTreeModel = new DefaultTreeModel(new DefaultMutableTreeNode());
    private List<TestError> errors = new ArrayList<TestError>();
    private Set<OsmPrimitive> filter = null;
    private int updateCount;

    public ValidatorTreePanel(List<TestError> list) {
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setModel(this.valTreeModel);
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.expandRow(0);
        this.setVisibleRowCount(8);
        this.setCellRenderer(new ValidatorTreeRenderer());
        this.getSelectionModel().setSelectionMode(4);
        this.setErrorList(list);
        for (KeyListener keyListener : this.getKeyListeners()) {
            if (!keyListener.getClass().getName().equals("javax.swing.plaf.basic.BasicTreeUI$Handler")) continue;
            this.removeKeyListener(keyListener);
        }
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        String string = null;
        TreePath treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath != null) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            Object object = defaultMutableTreeNode.getUserObject();
            if (object instanceof TestError) {
                TestError testError = (TestError)object;
                MultipleNameVisitor multipleNameVisitor = new MultipleNameVisitor();
                multipleNameVisitor.visit(testError.getPrimitives());
                string = "<html>" + multipleNameVisitor.getText() + "<br>" + testError.getMessage();
                String string2 = testError.getDescription();
                if (string2 != null) {
                    string = string + "<br>" + string2;
                }
                string = string + "</html>";
            } else {
                string = defaultMutableTreeNode.toString();
            }
        }
        return string;
    }

    public ValidatorTreePanel() {
        this((List<TestError>)null);
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            this.buildTree();
        } else {
            this.valTreeModel.setRoot(new DefaultMutableTreeNode());
        }
        super.setVisible(bl);
    }

    public void buildTree() {
        Cloneable cloneable;
        Serializable serializable;
        ++this.updateCount;
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        if (this.errors == null || this.errors.isEmpty()) {
            this.valTreeModel.setRoot(defaultMutableTreeNode);
            return;
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        Enumeration<TreePath> enumeration = this.getExpandedDescendants(new TreePath(this.getRoot()));
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                serializable = enumeration.nextElement();
                cloneable = (DefaultMutableTreeNode)((TreePath)serializable).getLastPathComponent();
                Object object = ((DefaultMutableTreeNode)cloneable).getUserObject();
                if (object instanceof Severity) {
                    hashSet.add(object);
                    continue;
                }
                if (!(object instanceof String)) continue;
                String string = (String)object;
                string = string.substring(0, string.lastIndexOf(" ("));
                hashSet.add(string);
            }
        }
        serializable = new HashMap();
        cloneable = new HashMap();
        for (Severity severity : Severity.values()) {
            serializable.put(severity, new MultiMap(20));
            cloneable.put(severity, new HashMap());
        }
        boolean bl = Main.pref.getBoolean("validator.other", false);
        for (TestError iterator : this.errors) {
            Severity severity;
            if (iterator.getIgnored().booleanValue()) continue;
            severity = iterator.getSeverity();
            if (!bl && severity == Severity.OTHER) continue;
            String string = iterator.getDescription();
            Object object = iterator.getMessage();
            if (this.filter != null) {
                boolean multiMap = false;
                for (OsmPrimitive osmPrimitive : iterator.getPrimitives()) {
                    if (!this.filter.contains(osmPrimitive)) continue;
                    multiMap = true;
                    break;
                }
                if (!multiMap) continue;
            }
            if (string != null) {
                MultiMap<String, TestError> multiMap = (MultiMap<String, TestError>)((HashMap)cloneable.get((Object)severity)).get(object);
                if (multiMap == null) {
                    multiMap = new MultiMap<String, TestError>(20);
                    ((HashMap)cloneable.get((Object)severity)).put(object, multiMap);
                }
                multiMap.put(string, iterator);
                continue;
            }
            ((MultiMap)serializable.get((Object)severity)).put(object, iterator);
        }
        ArrayList arrayList = new ArrayList();
        for (Object object : Severity.values()) {
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            MultiMap multiMap = (MultiMap)serializable.get(object);
            Map map = (Map)cloneable.get(object);
            if (multiMap.isEmpty() && map.isEmpty()) continue;
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(object);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            if (hashSet.contains(object)) {
                arrayList.add(new TreePath(new Object[]{defaultMutableTreeNode, defaultMutableTreeNode2}));
            }
            for (Map.Entry entry : multiMap.entrySet()) {
                object6 = entry.getValue();
                object5 = (String)entry.getKey() + " (" + object6.size() + ")";
                object4 = new DefaultMutableTreeNode(object5);
                defaultMutableTreeNode2.add((MutableTreeNode)object4);
                if (hashSet.contains(entry.getKey())) {
                    arrayList.add(new TreePath(new Object[]{defaultMutableTreeNode, defaultMutableTreeNode2, object4}));
                }
                Iterator iterator = object6.iterator();
                while (iterator.hasNext()) {
                    object3 = (TestError)iterator.next();
                    object2 = new DefaultMutableTreeNode(object3);
                    ((DefaultMutableTreeNode)object4).add((MutableTreeNode)object2);
                }
            }
            for (Map.Entry<Object, Set<Object>> entry : map.entrySet()) {
                object6 = (MultiMap)((Object)entry.getValue());
                object5 = null;
                if (((MultiMap)object6).size() > 1) {
                    object4 = (String)entry.getKey() + " (" + ((MultiMap)object6).size() + ")";
                    object5 = new DefaultMutableTreeNode(object4);
                    defaultMutableTreeNode2.add((MutableTreeNode)object5);
                    if (hashSet.contains(entry.getKey())) {
                        arrayList.add(new TreePath(new Object[]{defaultMutableTreeNode, defaultMutableTreeNode2, object5}));
                    }
                }
                for (Map.Entry entry2 : ((MultiMap)object6).entrySet()) {
                    object3 = (Set)entry2.getValue();
                    object2 = object5 != null ? (String)entry2.getKey() + " (" + object3.size() + ")" : (String)entry2.getKey() + " - " + (String)entry.getKey() + " (" + object3.size() + ")";
                    DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(object2);
                    if (object5 != null) {
                        ((DefaultMutableTreeNode)object5).add(defaultMutableTreeNode3);
                    } else {
                        defaultMutableTreeNode2.add(defaultMutableTreeNode3);
                    }
                    if (hashSet.contains(entry2.getKey())) {
                        if (object5 != null) {
                            arrayList.add(new TreePath(new Object[]{defaultMutableTreeNode, defaultMutableTreeNode2, object5, defaultMutableTreeNode3}));
                        } else {
                            arrayList.add(new TreePath(new Object[]{defaultMutableTreeNode, defaultMutableTreeNode2, defaultMutableTreeNode3}));
                        }
                    }
                    Iterator iterator = object3.iterator();
                    while (iterator.hasNext()) {
                        TestError testError = (TestError)iterator.next();
                        DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(testError);
                        defaultMutableTreeNode3.add(defaultMutableTreeNode4);
                    }
                }
            }
        }
        this.valTreeModel.setRoot(defaultMutableTreeNode);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            TreePath treePath = (TreePath)iterator.next();
            this.expandPath(treePath);
        }
    }

    public void setErrorList(List<TestError> list) {
        this.errors = list;
        if (this.isVisible()) {
            this.buildTree();
        }
    }

    public void setErrors(List<TestError> list) {
        if (this.errors == null) {
            return;
        }
        this.clearErrors();
        DataSet dataSet = Main.main.getCurrentDataSet();
        for (TestError testError : list) {
            if (testError.getIgnored().booleanValue()) continue;
            this.errors.add(testError);
            if (dataSet == null) continue;
            dataSet.addDataSetListener(testError);
        }
        if (this.isVisible()) {
            this.buildTree();
        }
    }

    public List<TestError> getErrors() {
        return this.errors != null ? this.errors : Collections.emptyList();
    }

    public Set<OsmPrimitive> getFilter() {
        return this.filter;
    }

    public void setFilter(Set<OsmPrimitive> set) {
        this.filter = set != null && set.isEmpty() ? null : set;
        if (this.isVisible()) {
            this.buildTree();
        }
    }

    public void resetErrors() {
        ArrayList<TestError> arrayList = new ArrayList<TestError>(this.errors);
        this.setErrors(arrayList);
    }

    public void expandAll() {
        DefaultMutableTreeNode defaultMutableTreeNode = this.getRoot();
        int n = 0;
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement();
            this.expandRow(n++);
        }
    }

    public DefaultMutableTreeNode getRoot() {
        return (DefaultMutableTreeNode)this.valTreeModel.getRoot();
    }

    public int getUpdateCount() {
        return this.updateCount;
    }

    private void clearErrors() {
        if (this.errors != null) {
            DataSet dataSet = Main.main.getCurrentDataSet();
            if (dataSet != null) {
                for (TestError testError : this.errors) {
                    dataSet.removeDataSetListener(testError);
                }
            }
            this.errors.clear();
        }
    }

    @Override
    public void destroy() {
        this.clearErrors();
    }
}

