/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection.datum;

import org.openstreetmap.josm.data.projection.datum.NTV2GridShiftFile;
import org.openstreetmap.josm.io.MirroredInputStream;
import org.openstreetmap.josm.tools.I18n;

public class NTV2GridShiftFileWrapper {
    public static final NTV2GridShiftFileWrapper BETA2007 = new NTV2GridShiftFileWrapper("resource://data/BETA2007.gsb");
    public static final NTV2GridShiftFileWrapper ntf_rgf93 = new NTV2GridShiftFileWrapper("resource://data/ntf_r93_b.gsb");
    private NTV2GridShiftFile instance = null;
    private String gridFileName;

    public NTV2GridShiftFileWrapper(String string) {
        this.gridFileName = string;
    }

    public NTV2GridShiftFile getShiftFile() {
        if (this.instance == null) {
            try {
                MirroredInputStream mirroredInputStream = new MirroredInputStream(this.gridFileName);
                if (mirroredInputStream == null) {
                    throw new RuntimeException(I18n.tr("Error: failed to open input stream for resource ''/data/{0}''.", this.gridFileName));
                }
                this.instance = new NTV2GridShiftFile();
                this.instance.loadGridShiftFile(mirroredInputStream, false);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return this.instance;
    }
}

