/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.search;

import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import org.openstreetmap.josm.actions.search.SearchCompiler;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class PushbackTokenizer {
    private final Reader search;
    private Token currentToken;
    private String currentText;
    private Long currentNumber;
    private Long currentRange;
    private int c;
    private boolean isRange;
    private static final List<Character> specialChars = Arrays.asList(Character.valueOf('\"'), Character.valueOf(':'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('|'), Character.valueOf('^'), Character.valueOf('='), Character.valueOf('?'));
    private static final List<Character> specialCharsQuoted = Arrays.asList(Character.valueOf('\"'));

    public PushbackTokenizer(Reader reader) {
        this.search = reader;
        this.getChar();
    }

    private void getChar() {
        try {
            this.c = this.search.read();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage(), iOException);
        }
    }

    private String getString(boolean bl) {
        List<Character> list = bl ? specialCharsQuoted : specialChars;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        while (this.c != -1 && (bl2 || !list.contains(Character.valueOf((char)this.c)) && (bl || !Character.isWhitespace(this.c)))) {
            if (this.c == 92 && !bl2) {
                bl2 = true;
            } else {
                stringBuilder.append((char)this.c);
                bl2 = false;
            }
            this.getChar();
        }
        return stringBuilder.toString();
    }

    private String getString() {
        return this.getString(false);
    }

    public Token nextToken() {
        if (this.currentToken != null) {
            Token token = this.currentToken;
            this.currentToken = null;
            return token;
        }
        while (Character.isWhitespace(this.c)) {
            this.getChar();
        }
        switch (this.c) {
            case -1: {
                this.getChar();
                return Token.EOF;
            }
            case 58: {
                this.getChar();
                return Token.COLON;
            }
            case 61: {
                this.getChar();
                return Token.EQUALS;
            }
            case 40: {
                this.getChar();
                return Token.LEFT_PARENT;
            }
            case 41: {
                this.getChar();
                return Token.RIGHT_PARENT;
            }
            case 124: {
                this.getChar();
                return Token.OR;
            }
            case 94: {
                this.getChar();
                return Token.XOR;
            }
            case 38: {
                this.getChar();
                return this.nextToken();
            }
            case 63: {
                this.getChar();
                return Token.QUESTION_MARK;
            }
            case 34: {
                this.getChar();
                this.currentText = this.getString(true);
                this.getChar();
                return Token.KEY;
            }
        }
        String string = "";
        if (this.c == 45) {
            this.getChar();
            if (!Character.isDigit(this.c)) {
                return Token.NOT;
            }
            string = "-";
        }
        this.currentText = string + this.getString();
        if ("or".equalsIgnoreCase(this.currentText)) {
            return Token.OR;
        }
        if ("xor".equalsIgnoreCase(this.currentText)) {
            return Token.XOR;
        }
        if ("and".equalsIgnoreCase(this.currentText)) {
            return this.nextToken();
        }
        try {
            this.currentNumber = Long.parseLong(this.currentText);
        }
        catch (NumberFormatException numberFormatException) {
            this.currentNumber = null;
        }
        int n = this.currentText.indexOf(45, 1);
        boolean bl = this.isRange = n > 0;
        if (this.isRange) {
            try {
                this.currentNumber = Long.parseLong(this.currentText.substring(0, n));
            }
            catch (NumberFormatException numberFormatException) {
                this.currentNumber = null;
            }
            try {
                this.currentRange = Long.parseLong(this.currentText.substring(n + 1));
            }
            catch (NumberFormatException numberFormatException) {
                this.currentRange = null;
            }
        } else {
            this.currentRange = null;
        }
        return Token.KEY;
    }

    public boolean readIfEqual(Token token) {
        Token token2 = this.nextToken();
        if (Utils.equal(token2, token)) {
            return true;
        }
        this.currentToken = token2;
        return false;
    }

    public String readTextOrNumber() {
        Token token = this.nextToken();
        if (token == Token.KEY) {
            return this.currentText;
        }
        this.currentToken = token;
        return null;
    }

    public long readNumber(String string) throws SearchCompiler.ParseError {
        if (this.nextToken() == Token.KEY && this.currentNumber != null) {
            return this.currentNumber;
        }
        throw new SearchCompiler.ParseError(string);
    }

    public long getReadNumber() {
        return this.currentNumber != null ? this.currentNumber : 0L;
    }

    public Range readRange(String string) throws SearchCompiler.ParseError {
        if (this.nextToken() != Token.KEY || this.currentNumber == null && this.currentRange == null) {
            throw new SearchCompiler.ParseError(string);
        }
        if (!this.isRange && this.currentNumber != null) {
            if (this.currentNumber >= 0L) {
                return new Range(this.currentNumber, this.currentNumber);
            }
            return new Range(0L, Math.abs(this.currentNumber));
        }
        if (this.isRange && this.currentRange == null) {
            return new Range(this.currentNumber, Integer.MAX_VALUE);
        }
        if (this.currentNumber != null && this.currentRange != null) {
            return new Range(this.currentNumber, this.currentRange);
        }
        throw new SearchCompiler.ParseError(string);
    }

    public String getText() {
        return this.currentText;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Token {
        NOT(I18n.marktr("<not>")),
        OR(I18n.marktr("<or>")),
        XOR(I18n.marktr("<xor>")),
        LEFT_PARENT(I18n.marktr("<left parent>")),
        RIGHT_PARENT(I18n.marktr("<right parent>")),
        COLON(I18n.marktr("<colon>")),
        EQUALS(I18n.marktr("<equals>")),
        KEY(I18n.marktr("<key>")),
        QUESTION_MARK(I18n.marktr("<question mark>")),
        EOF(I18n.marktr("<end-of-file>"));

        private final String name;

        private Token(String string2) {
            this.name = string2;
        }

        public String toString() {
            return I18n.tr(this.name, new Object[0]);
        }
    }

    public static class Range {
        private final long start;
        private final long end;

        public Range(long l, long l2) {
            this.start = l;
            this.end = l2;
        }

        public long getStart() {
            return this.start;
        }

        public long getEnd() {
            return this.end;
        }

        public String toString() {
            return "Range [start=" + this.start + ", end=" + this.end + "]";
        }
    }
}

