/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.relation;

import java.awt.event.ActionEvent;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.DeleteAction;
import org.openstreetmap.josm.actions.relation.AbstractRelationAction;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class DeleteRelationsAction
extends AbstractRelationAction {
    public DeleteRelationsAction() {
        this.putValue("ShortDescription", I18n.tr("Delete the selected relation", new Object[0]));
        this.putValue("Name", I18n.tr("Delete", new Object[0]));
        this.putValue("SmallIcon", ImageProvider.get("dialogs", "delete"));
    }

    protected void deleteRelation(Relation relation) {
        if (relation == null) {
            return;
        }
        DeleteAction.deleteRelation(Main.main.getEditLayer(), relation);
        if (Main.map.relationListDialog != null) {
            Main.map.relationListDialog.selectRelations(null);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.isEnabled() || Main.main.getEditLayer() == null) {
            return;
        }
        for (Relation relation : this.relations) {
            this.deleteRelation(relation);
        }
    }

    class AbortException
    extends Exception {
        AbortException() {
        }
    }
}

