/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.visitor.paint.MapRendererFactory;
import org.openstreetmap.josm.data.osm.visitor.paint.StyledMapRenderer;
import org.openstreetmap.josm.data.osm.visitor.paint.WireframeMapRenderer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class WireframeToggleAction
extends JosmAction {
    private final List<ButtonModel> buttonModels = new ArrayList<ButtonModel>();
    private boolean selected;

    public WireframeToggleAction() {
        super(I18n.tr("Wireframe View", new Object[0]), null, I18n.tr("Enable/disable rendering the map as wireframe only", new Object[0]), Shortcut.registerShortcut("menu:view:wireframe", I18n.tr("Toggle Wireframe view", new Object[0]), 87, 5006), false);
        this.putValue("toolbar", "wireframe");
        Main.toolbar.register(this);
        this.selected = MapRendererFactory.getInstance().isWireframeMapRendererActive();
        this.notifySelectedState();
    }

    public void addButtonModel(ButtonModel buttonModel) {
        if (buttonModel != null && !this.buttonModels.contains(buttonModel)) {
            this.buttonModels.add(buttonModel);
            buttonModel.setSelected(this.selected);
        }
    }

    public void removeButtonModel(ButtonModel buttonModel) {
        if (buttonModel != null && this.buttonModels.contains(buttonModel)) {
            this.buttonModels.remove(buttonModel);
        }
    }

    protected void notifySelectedState() {
        for (ButtonModel buttonModel : this.buttonModels) {
            if (buttonModel.isSelected() == this.selected) continue;
            buttonModel.setSelected(this.selected);
        }
    }

    protected void toggleSelectedState() {
        boolean bl = this.selected = !this.selected;
        if (this.selected) {
            MapRendererFactory.getInstance().activate(WireframeMapRenderer.class);
        } else {
            MapRendererFactory.getInstance().activate(StyledMapRenderer.class);
        }
        this.notifySelectedState();
        if (Main.isDisplayingMapView()) {
            Main.map.mapView.repaint();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.toggleSelectedState();
    }

    protected void updateEnabledState() {
        this.setEnabled(Main.isDisplayingMapView() && Main.main.getEditLayer() != null);
    }

    public boolean isSelected() {
        return this.selected;
    }
}

