/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.io.File;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.SaveActionBase;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class SaveAction
extends SaveActionBase {
    private static SaveAction instance = new SaveAction();

    private SaveAction() {
        super(I18n.tr("Save", new Object[0]), "save", I18n.tr("Save the current data.", new Object[0]), Shortcut.registerShortcut("system:save", I18n.tr("File: {0}", I18n.tr("Save", new Object[0])), 83, 5006));
        this.putValue("help", HelpUtil.ht("/Action/Save"));
    }

    public static SaveAction getInstance() {
        return instance;
    }

    public File getFile(Layer layer) {
        File file = layer.getAssociatedFile();
        if (file != null && !file.exists()) {
            file = null;
        }
        if (file != null && layer instanceof GpxLayer) {
            ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, I18n.tr("Overwrite", new Object[0]), new String[]{I18n.tr("Overwrite", new Object[0]), I18n.tr("Cancel", new Object[0])});
            extendedDialog.setButtonIcons(new String[]{"save_as.png", "cancel.png"});
            extendedDialog.setContent(I18n.tr("File {0} exists. Overwrite?", file.getName()));
            extendedDialog.showDialog();
            int n = extendedDialog.getValue();
            if (n != 1) {
                file = null;
            }
        }
        return file == null ? layer.createAndOpenSaveFileChooser() : file;
    }
}

