/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.ChangesetCache;
import org.openstreetmap.josm.data.osm.UserInfo;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.io.CloseChangesetDialog;
import org.openstreetmap.josm.gui.io.CloseChangesetTask;
import org.openstreetmap.josm.io.ChangesetQuery;
import org.openstreetmap.josm.io.OsmServerChangesetReader;
import org.openstreetmap.josm.io.OsmServerUserInfoReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import org.xml.sax.SAXException;

public class CloseChangesetAction
extends JosmAction {
    public CloseChangesetAction() {
        super(I18n.tr("Close open changesets", new Object[0]), "closechangeset", I18n.tr("Closes open changesets", new Object[0]), Shortcut.registerShortcut("system:closechangeset", I18n.tr("File: {0}", I18n.tr("Closes open changesets", new Object[0])), 81, 5008), true);
        this.putValue("help", HelpUtil.ht("/Action/CloseChangeset"));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Main.worker.submit(new DownloadOpenChangesetsTask());
    }

    protected void onPostDownloadOpenChangesets() {
        List<Changeset> list = ChangesetCache.getInstance().getOpenChangesets();
        if (list.isEmpty()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("There are no open changesets", new Object[0]), I18n.tr("No open changesets", new Object[0]), 1);
            return;
        }
        CloseChangesetDialog closeChangesetDialog = new CloseChangesetDialog();
        closeChangesetDialog.setChangesets(list);
        closeChangesetDialog.setVisible(true);
        if (closeChangesetDialog.isCanceled()) {
            return;
        }
        Collection<Changeset> collection = closeChangesetDialog.getSelectedChangesets();
        CloseChangesetTask closeChangesetTask = new CloseChangesetTask(collection);
        Main.worker.submit(closeChangesetTask);
    }

    private class DownloadOpenChangesetsTask
    extends PleaseWaitRunnable {
        private boolean canceled;
        private OsmServerChangesetReader reader;
        private List<Changeset> changesets;
        private Exception lastException;
        private UserInfo userInfo;

        public DownloadOpenChangesetsTask() {
            super(I18n.tr("Downloading open changesets ...", false));
        }

        protected void cancel() {
            this.canceled = true;
            this.reader.cancel();
        }

        protected void finish() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (DownloadOpenChangesetsTask.this.lastException != null) {
                        ExceptionDialogUtil.explainException(DownloadOpenChangesetsTask.this.lastException);
                    }
                    ChangesetCache.getInstance().update(DownloadOpenChangesetsTask.this.changesets);
                    if (!DownloadOpenChangesetsTask.this.canceled && DownloadOpenChangesetsTask.this.lastException == null) {
                        CloseChangesetAction.this.onPostDownloadOpenChangesets();
                    }
                }
            });
        }

        protected UserInfo fetchUserInfo() throws OsmTransferException {
            OsmServerUserInfoReader osmServerUserInfoReader = new OsmServerUserInfoReader();
            return osmServerUserInfoReader.fetchUserInfo(this.getProgressMonitor().createSubTaskMonitor(1, false));
        }

        protected void realRun() throws SAXException, IOException, OsmTransferException {
            try {
                this.userInfo = this.fetchUserInfo();
                if (this.canceled) {
                    return;
                }
                this.reader = new OsmServerChangesetReader();
                ChangesetQuery changesetQuery = new ChangesetQuery().forUser(this.userInfo.getId()).beingOpen(true);
                this.changesets = this.reader.queryChangesets(changesetQuery, this.getProgressMonitor().createSubTaskMonitor(1, false));
            }
            catch (Exception exception) {
                if (this.canceled) {
                    return;
                }
                this.lastException = exception;
            }
        }

        public boolean isCanceled() {
            return this.canceled;
        }

        public Exception getLastException() {
            return this.lastException;
        }
    }
}

