/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.OpenBrowser;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractInfoAction
extends JosmAction {
    public AbstractInfoAction(boolean bl) {
        super(bl);
    }

    public AbstractInfoAction(String string, String string2, String string3, Shortcut shortcut, boolean bl, String string4, boolean bl2) {
        super(string, string2, string3, shortcut, bl, string4, bl2);
    }

    public static String getBaseBrowseUrl() {
        String string = Main.pref.get("osm-server.url", "http://api.openstreetmap.org/api");
        Pattern pattern = Pattern.compile("/api/?$");
        String string2 = pattern.matcher(string).replaceAll("/browse");
        if (string2.equals(string)) {
            System.out.println(I18n.tr("WARNING: unexpected format of API base URL. Redirection to info or history page for OSM object will probably fail. API base URL is: ''{0}''", string));
        }
        if (string2.startsWith("http://api.openstreetmap.org/")) {
            string2 = string2.substring("http://api.openstreetmap.org/".length());
            string2 = "http://www.openstreetmap.org/" + string2;
        }
        return string2;
    }

    public static String getBaseUserUrl() {
        String string = Main.pref.get("osm-server.url", "http://api.openstreetmap.org/api");
        Pattern pattern = Pattern.compile("/api/?$");
        String string2 = pattern.matcher(string).replaceAll("/user");
        if (string2.equals(string)) {
            System.out.println(I18n.tr("WARNING: unexpected format of API base URL. Redirection to user page for OSM user will probably fail. API base URL is: ''{0}''", string));
        }
        if (string2.startsWith("http://api.openstreetmap.org/")) {
            string2 = string2.substring("http://api.openstreetmap.org/".length());
            string2 = "http://www.openstreetmap.org/" + string2;
        }
        return string2;
    }

    protected void launchBrowser(URL uRL) {
        OpenBrowser.displayUrl(uRL.toString());
    }

    protected void launchBrowser(String string) {
        OpenBrowser.displayUrl(string);
    }

    public static boolean confirmLaunchMultiple(int n) {
        String string = I18n.tr("You are about to launch {0} browser windows.<br>This may both clutter your screen with browser windows<br>and take some time to finish.", n);
        string = "<html>" + string + "</html>";
        HelpAwareOptionPane.ButtonSpec[] buttonSpecArray = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr("Continue", new Object[0]), ImageProvider.get("ok"), I18n.tr("Click to continue and to open {0} browsers", n), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("Cancel", new Object[0]), ImageProvider.get("cancel"), I18n.tr("Click to abort launching external browsers", new Object[0]), null)};
        int n2 = HelpAwareOptionPane.showOptionDialog(Main.parent, string, I18n.tr("Warning", new Object[0]), 2, null, buttonSpecArray, buttonSpecArray[0], HelpUtil.ht("/WarningMessages#ToManyBrowsersToOpen"));
        return n2 == 0;
    }

    protected void launchInfoBrowsersForSelectedPrimitives() {
        ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>(AbstractInfoAction.getCurrentDataSet().getAllSelected());
        Iterator<OsmPrimitive> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().isNew()) continue;
            iterator.remove();
        }
        if (arrayList.isEmpty()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Please select at least one already uploaded node, way, or relation.", new Object[0]), I18n.tr("Warning", new Object[0]), 2);
            return;
        }
        int n = Math.min(10, arrayList.size());
        if (arrayList.size() > n && !AbstractInfoAction.confirmLaunchMultiple(arrayList.size())) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            this.launchBrowser(this.createInfoUrl(arrayList.get(i)));
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.launchInfoBrowsersForSelectedPrimitives();
    }

    protected abstract String createInfoUrl(Object var1);

    @Override
    protected void updateEnabledState() {
        this.setEnabled(AbstractInfoAction.getCurrentDataSet() != null && !AbstractInfoAction.getCurrentDataSet().getSelected().isEmpty());
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> collection) {
        this.setEnabled(collection != null && !collection.isEmpty());
    }
}

