/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.image.FilteredImageSource;
import java.lang.reflect.InvocationTargetException;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class GuiHelper {
    public static void setEnabledRec(Container container, boolean bl) {
        Component[] componentArray;
        container.setEnabled(bl);
        for (Component component : componentArray = container.getComponents()) {
            if (component instanceof Container) {
                GuiHelper.setEnabledRec((Container)component, bl);
                continue;
            }
            component.setEnabled(bl);
        }
    }

    public static void runInEDT(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public static void runInEDTAndWait(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
        }
    }

    public static final boolean warnUser(String string, String string2, ImageIcon imageIcon, String string3) {
        ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, string, new String[]{I18n.tr("Cancel", new Object[0]), I18n.tr("Continue", new Object[0])});
        extendedDialog.setContent(string2);
        extendedDialog.setButtonIcons(new Icon[]{ImageProvider.get("cancel"), ImageProvider.overlay((Icon)ImageProvider.get("upload"), new ImageIcon(ImageProvider.get("warning-small").getImage().getScaledInstance(10, 10, 4)), ImageProvider.OverlayPosition.SOUTHEAST)});
        extendedDialog.setToolTipTexts(new String[]{I18n.tr("Cancel", new Object[0]), string3});
        extendedDialog.setIcon(2);
        extendedDialog.setCancelButton(1);
        return extendedDialog.showDialog().getValue() != 2;
    }

    public static final Image getDisabledImage(Image image) {
        return Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(image.getSource(), new GrayFilter(true, 20)));
    }

    public static final ImageIcon getDisabledIcon(ImageIcon imageIcon) {
        return new ImageIcon(GuiHelper.getDisabledImage(imageIcon.getImage()));
    }

    public static final Component prepareResizeableOptionPane(final Component component, final Dimension dimension) {
        if (component != null) {
            component.addHierarchyListener(new HierarchyListener(){

                public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                    Dialog dialog;
                    Window window = SwingUtilities.getWindowAncestor(component);
                    if (window instanceof Dialog && !(dialog = (Dialog)window).isResizable()) {
                        dialog.setResizable(true);
                        if (dimension != null) {
                            dialog.setMinimumSize(dimension);
                        }
                    }
                }
            });
        }
        return component;
    }
}

