/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.properties;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.mapmode.DrawAction;
import org.openstreetmap.josm.actions.search.SearchAction;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.IRelation;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListenerAdapter;
import org.openstreetmap.josm.data.osm.event.DatasetEventManager;
import org.openstreetmap.josm.data.osm.event.SelectionEventManager;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.dialogs.properties.PresetListPanel;
import org.openstreetmap.josm.gui.dialogs.relation.DownloadRelationMemberTask;
import org.openstreetmap.josm.gui.dialogs.relation.RelationEditor;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.tagging.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletingComboBox;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionListItem;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionManager;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.InputMapUtils;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.OpenBrowser;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesDialog
extends ToggleDialog
implements SelectionChangedListener,
MapView.EditLayerChangeListener,
DataSetListenerAdapter.Listener {
    public static final JPanel pluginHook = new JPanel();
    private JPopupMenu propertyMenu;
    private JPopupMenu membershipMenu;
    private final Map<String, Map<String, Integer>> valueCount = new TreeMap<String, Map<String, Integer>>();
    Comparator<AutoCompletionListItem> defaultACItemComparator = new Comparator<AutoCompletionListItem>(){

        @Override
        public int compare(AutoCompletionListItem autoCompletionListItem, AutoCompletionListItem autoCompletionListItem2) {
            return String.CASE_INSENSITIVE_ORDER.compare(autoCompletionListItem.getValue(), autoCompletionListItem2.getValue());
        }
    };
    private final DataSetListenerAdapter dataChangedAdapter = new DataSetListenerAdapter(this);
    private final HelpAction helpAction = new HelpAction();
    private final CopyValueAction copyValueAction = new CopyValueAction();
    private final CopyKeyValueAction copyKeyValueAction = new CopyKeyValueAction();
    private final CopyAllKeyValueAction copyAllKeyValueAction = new CopyAllKeyValueAction();
    private final SearchAction searchActionSame = new SearchAction(true);
    private final SearchAction searchActionAny = new SearchAction(false);
    private final AddAction addAction = new AddAction();
    private final EditAction editAction = new EditAction();
    private final DeleteAction deleteAction = new DeleteAction();
    private final JosmAction[] josmActions = new JosmAction[]{this.addAction, this.editAction, this.deleteAction};
    private static String lastAddKey = null;
    private static String lastAddValue = null;
    public static final int DEFAULT_LRU_TAGS_NUMBER = 5;
    public static final int MAX_LRU_TAGS_NUMBER = 9;
    private static final Map<Tag, Void> recentTags = new LinkedHashMap<Tag, Void>(10, 1.1f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Tag, Void> entry) {
            return this.size() > 9;
        }
    };
    private String objKey;
    private final DefaultTableModel propertyData = new DefaultTableModel(){

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return String.class;
        }
    };
    private final DefaultTableModel membershipData = new DefaultTableModel(){

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return String.class;
        }
    };
    private final JTable propertyTable = new JTable(this.propertyData);
    private final JTable membershipTable = new JTable(this.membershipData);
    private final SideButton btnAdd;
    private final SideButton btnEdit;
    private final SideButton btnDel;
    private final PresetListPanel presets = new PresetListPanel();
    private final JLabel selectSth = new JLabel("<html><p>" + I18n.tr("Select objects for which to change properties.", new Object[0]) + "</p></html>");
    private PresetListPanel.PresetHandler presetHandler = new PresetListPanel.PresetHandler(){

        @Override
        public void updateTags(List<Tag> list) {
            Command command = TaggingPreset.createCommand(this.getSelection(), list);
            if (command != null) {
                Main.main.undoRedo.add(command);
            }
        }

        @Override
        public Collection<OsmPrimitive> getSelection() {
            if (Main.main == null) {
                return null;
            }
            if (Main.main.getCurrentDataSet() == null) {
                return null;
            }
            return Main.main.getCurrentDataSet().getSelected();
        }
    };

    @Override
    public void showNotify() {
        DatasetEventManager.getInstance().addDatasetListener(this.dataChangedAdapter, DatasetEventManager.FireMode.IN_EDT_CONSOLIDATED);
        SelectionEventManager.getInstance().addSelectionListener(this, DatasetEventManager.FireMode.IN_EDT_CONSOLIDATED);
        MapView.addEditLayerChangeListener(this);
        for (JosmAction josmAction : this.josmActions) {
            Main.registerActionShortcut(josmAction);
        }
        this.updateSelection();
    }

    @Override
    public void hideNotify() {
        DatasetEventManager.getInstance().removeDatasetListener(this.dataChangedAdapter);
        SelectionEventManager.getInstance().removeSelectionListener(this);
        MapView.removeEditLayerChangeListener(this);
        for (JosmAction josmAction : this.josmActions) {
            Main.unregisterActionShortcut(josmAction);
        }
    }

    private void editProperty(int n) {
        String string;
        String string2;
        Collection<OsmPrimitive> collection = Main.main.getCurrentDataSet().getSelected();
        if (collection.isEmpty()) {
            return;
        }
        this.objKey = string2 = this.propertyData.getValueAt(n, 0).toString();
        String string3 = "<html>" + I18n.trn("This will change {0} object.", "This will change up to {0} objects.", collection.size(), collection.size()) + "<br><br>(" + I18n.tr("An empty value deletes the tag.", string2) + ")</html>";
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JLabel(string3), "North");
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel.add((Component)jPanel2, "Center");
        AutoCompletionManager autoCompletionManager = Main.main.getEditLayer().data.getAutoCompletionManager();
        List<AutoCompletionListItem> list = autoCompletionManager.getKeys();
        Collections.sort(list, this.defaultACItemComparator);
        AutoCompletingComboBox autoCompletingComboBox = new AutoCompletingComboBox(string2);
        autoCompletingComboBox.setPossibleACItems(list);
        autoCompletingComboBox.setEditable(true);
        autoCompletingComboBox.setSelectedItem(string2);
        jPanel2.add((Component)new JLabel(I18n.tr("Key", new Object[0])), GBC.std());
        jPanel2.add(Box.createHorizontalStrut(10), GBC.std());
        jPanel2.add((Component)autoCompletingComboBox, GBC.eol().fill(2));
        final Map map = (Map)this.propertyData.getValueAt(n, 1);
        Comparator<AutoCompletionListItem> comparator = new Comparator<AutoCompletionListItem>(){

            @Override
            public int compare(AutoCompletionListItem autoCompletionListItem, AutoCompletionListItem autoCompletionListItem2) {
                boolean bl;
                boolean bl2 = map.containsKey(autoCompletionListItem.getValue());
                if (bl2 == (bl = map.containsKey(autoCompletionListItem2.getValue()))) {
                    return String.CASE_INSENSITIVE_ORDER.compare(autoCompletionListItem.getValue(), autoCompletionListItem2.getValue());
                }
                if (bl2) {
                    return -1;
                }
                return 1;
            }
        };
        List<AutoCompletionListItem> list2 = autoCompletionManager.getValues(PropertiesDialog.getAutocompletionKeys(string2));
        Collections.sort(list2, comparator);
        String string4 = map.size() != 1 ? I18n.tr("<different>", new Object[0]) : (String)map.entrySet().iterator().next().getKey();
        final AutoCompletingComboBox autoCompletingComboBox2 = new AutoCompletingComboBox(string4);
        autoCompletingComboBox2.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                if (component instanceof JLabel) {
                    Map map;
                    String string = ((AutoCompletionListItem)object).getValue();
                    if (PropertiesDialog.this.valueCount.containsKey(PropertiesDialog.this.objKey) && (map = (Map)PropertiesDialog.this.valueCount.get(PropertiesDialog.this.objKey)).containsKey(string)) {
                        string = I18n.tr("{0} ({1})", string, map.get(string));
                        component.setFont(component.getFont().deriveFont(3));
                    }
                    ((JLabel)component).setText(string);
                }
                return component;
            }
        });
        autoCompletingComboBox2.setEditable(true);
        autoCompletingComboBox2.setPossibleACItems(list2);
        autoCompletingComboBox2.setSelectedItem(string4);
        autoCompletingComboBox2.getEditor().setItem(string4);
        jPanel2.add((Component)new JLabel(I18n.tr("Value", new Object[0])), GBC.std());
        jPanel2.add(Box.createHorizontalStrut(10), GBC.std());
        jPanel2.add((Component)autoCompletingComboBox2, GBC.eol().fill(2));
        this.addFocusAdapter(autoCompletingComboBox, autoCompletingComboBox2, autoCompletionManager, comparator);
        final JOptionPane jOptionPane = new JOptionPane(jPanel, 3, 2){

            public void selectInitialValue() {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemSelection();
                if (clipboard != null) {
                    Transferable transferable = clipboard.getContents(null);
                    autoCompletingComboBox2.requestFocusInWindow();
                    autoCompletingComboBox2.getEditor().selectAll();
                    clipboard.setContents(transferable, null);
                } else {
                    autoCompletingComboBox2.requestFocusInWindow();
                    autoCompletingComboBox2.getEditor().selectAll();
                }
            }
        };
        final JDialog jDialog = jOptionPane.createDialog(Main.parent, I18n.trn("Change value?", "Change values?", map.size(), new Object[0]));
        jDialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        Dimension dimension = jDialog.getSize();
        if (dimension.width > Main.parent.getSize().width) {
            dimension.width = Math.max(250, Main.parent.getSize().width);
            jDialog.setSize(dimension);
        }
        jDialog.setLocationRelativeTo(Main.parent);
        autoCompletingComboBox2.getEditor().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.setVisible(false);
                jOptionPane.setValue(0);
            }
        });
        String string5 = autoCompletingComboBox2.getEditor().getItem().toString();
        jDialog.setVisible(true);
        Object object = jOptionPane.getValue();
        if (object == null || object == JOptionPane.UNINITIALIZED_VALUE || object instanceof Integer && (Integer)object != 0) {
            autoCompletingComboBox2.getEditor().setItem(string5);
            return;
        }
        String string6 = autoCompletingComboBox2.getEditor().getItem().toString().trim();
        if (string6.equals("")) {
            string6 = null;
        }
        if ((string = autoCompletingComboBox.getEditor().getItem().toString().trim()).equals("")) {
            string = string2;
            string6 = null;
        }
        if (string2.equals(string) && I18n.tr("<different>", new Object[0]).equals(string6)) {
            return;
        }
        if (string2.equals(string) || string6 == null) {
            Main.main.undoRedo.add(new ChangePropertyCommand(collection, string, string6));
        } else {
            for (OsmPrimitive object2 : collection) {
                if (object2.get(string) == null) continue;
                Iterator iterator = new ExtendedDialog(Main.parent, I18n.tr("Overwrite key", new Object[0]), new String[]{I18n.tr("Replace", new Object[0]), I18n.tr("Cancel", new Object[0])});
                ((ExtendedDialog)((Object)iterator)).setButtonIcons(new String[]{"purge", "cancel"});
                ((ExtendedDialog)((Object)iterator)).setContent(I18n.tr("You changed the key from ''{0}'' to ''{1}''.\nThe new key is already used, overwrite values?", string2, string));
                ((ExtendedDialog)((Object)iterator)).setCancelButton(2);
                ((ExtendedDialog)((Object)iterator)).toggleEnable("overwriteEditKey");
                ((ExtendedDialog)((Object)iterator)).showDialog();
                if (((ExtendedDialog)((Object)iterator)).getValue() == 1) break;
                return;
            }
            Vector vector = new Vector();
            vector.add(new ChangePropertyCommand(collection, string2, null));
            if (string6.equals(I18n.tr("<different>", new Object[0]))) {
                HashMap hashMap = new HashMap();
                for (OsmPrimitive osmPrimitive : collection) {
                    String string7 = osmPrimitive.get(string2);
                    if (string7 == null) continue;
                    if (hashMap.containsKey(string7)) {
                        ((Vector)hashMap.get(string7)).add(osmPrimitive);
                        continue;
                    }
                    Vector<OsmPrimitive> vector2 = new Vector<OsmPrimitive>();
                    vector2.add(osmPrimitive);
                    hashMap.put(string7, vector2);
                }
                for (Map.Entry entry : hashMap.entrySet()) {
                    vector.add(new ChangePropertyCommand((Collection)entry.getValue(), string, (String)entry.getKey()));
                }
            } else {
                vector.add(new ChangePropertyCommand(collection, string, string6));
            }
            Main.main.undoRedo.add(new SequenceCommand(I18n.trn("Change properties of up to {0} object", "Change properties of up to {0} objects", collection.size(), collection.size()), vector));
        }
        if (!string2.equals(string)) {
            for (int i = 0; i < this.propertyTable.getRowCount(); ++i) {
                if (!this.propertyData.getValueAt(i, 0).toString().equals(string)) continue;
                n = i;
                break;
            }
        }
        this.propertyTable.changeSelection(n, 0, false, false);
    }

    private static List<String> getAutocompletionKeys(String string) {
        if ("name".equals(string) || "addr:street".equals(string)) {
            return Arrays.asList("addr:street", "name");
        }
        return Arrays.asList(string);
    }

    private void editMembership(int n) {
        Relation relation = (Relation)this.membershipData.getValueAt(n, 0);
        Main.map.relationListDialog.selectRelation(relation);
        RelationEditor.getEditor(Main.map.mapView.getEditLayer(), relation, ((MemberInfo)this.membershipData.getValueAt((int)n, (int)1)).role).setVisible(true);
    }

    private void addProperty() {
        Object object2;
        Object object3;
        Collection<OsmPrimitive> collection;
        if (Main.map.mapMode instanceof DrawAction) {
            collection = ((DrawAction)Main.map.mapMode).getInProgressSelection();
        } else {
            object3 = Main.main.getCurrentDataSet();
            if (object3 == null) {
                return;
            }
            collection = ((DataSet)object3).getSelected();
        }
        if (collection.isEmpty()) {
            return;
        }
        object3 = new JPanel(new GridBagLayout());
        ((Container)object3).add((Component)new JLabel("<html>" + I18n.trn("This will change up to {0} object.", "This will change up to {0} objects.", collection.size(), collection.size()) + "<br><br>" + I18n.tr("Please select a key", new Object[0])), GBC.eol().fill(2));
        final AutoCompletingComboBox autoCompletingComboBox = new AutoCompletingComboBox();
        AutoCompletionManager autoCompletionManager = Main.main.getEditLayer().data.getAutoCompletionManager();
        List<AutoCompletionListItem> list = autoCompletionManager.getKeys();
        AutoCompletionListItem autoCompletionListItem = null;
        Iterator<AutoCompletionListItem> iterator = list.iterator();
        block0: while (iterator.hasNext()) {
            object2 = iterator.next();
            if (((AutoCompletionListItem)object2).getValue().equals(lastAddKey)) {
                autoCompletionListItem = object2;
            }
            for (int i = 0; i < this.propertyData.getRowCount(); ++i) {
                if (!((AutoCompletionListItem)object2).getValue().equals(this.propertyData.getValueAt(i, 0))) continue;
                if (autoCompletionListItem == object2) {
                    autoCompletionListItem = null;
                }
                iterator.remove();
                continue block0;
            }
        }
        Collections.sort(list, this.defaultACItemComparator);
        autoCompletingComboBox.setPossibleACItems(list);
        autoCompletingComboBox.setEditable(true);
        ((Container)object3).add((Component)autoCompletingComboBox, GBC.eop().fill());
        ((Container)object3).add((Component)new JLabel(I18n.tr("Please select a value", new Object[0])), GBC.eol());
        object2 = new AutoCompletingComboBox();
        ((JComboBox)object2).setEditable(true);
        ((Container)object3).add((Component)object2, GBC.eop().fill());
        if (autoCompletionListItem != null) {
            autoCompletingComboBox.setSelectedItem(autoCompletionListItem);
            if (lastAddValue != null) {
                ((AutoCompletingComboBox)object2).setSelectedItem(lastAddValue);
            }
        }
        FocusAdapter focusAdapter = this.addFocusAdapter(autoCompletingComboBox, (AutoCompletingComboBox)object2, autoCompletionManager, this.defaultACItemComparator);
        focusAdapter.focusGained(null);
        int n = Main.pref.getInteger("properties.recently-added-tags", 5);
        if (n > 9) {
            n = 9;
        }
        ArrayList<JosmAction> arrayList = new ArrayList<JosmAction>();
        this.suggestRecentlyAddedTags((JPanel)object3, autoCompletingComboBox, (AutoCompletingComboBox)object2, arrayList, n, focusAdapter);
        JOptionPane jOptionPane = new JOptionPane(object3, -1, 2){

            public void selectInitialValue() {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemSelection();
                if (clipboard != null) {
                    Transferable transferable = clipboard.getContents(null);
                    autoCompletingComboBox.requestFocusInWindow();
                    autoCompletingComboBox.getEditor().selectAll();
                    clipboard.setContents(transferable, null);
                } else {
                    autoCompletingComboBox.requestFocusInWindow();
                    autoCompletingComboBox.getEditor().selectAll();
                }
            }
        };
        JDialog jDialog = jOptionPane.createDialog(Main.parent, I18n.tr("Add value?", new Object[0]));
        jDialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        jDialog.setVisible(true);
        for (JosmAction object4 : arrayList) {
            object4.destroy();
        }
        if (!Integer.valueOf(0).equals(jOptionPane.getValue())) {
            return;
        }
        String string = autoCompletingComboBox.getEditor().getItem().toString().trim();
        String string2 = ((JComboBox)object2).getEditor().getItem().toString().trim();
        if (string.isEmpty() || string2.isEmpty()) {
            return;
        }
        lastAddKey = string;
        lastAddValue = string2;
        recentTags.put(new Tag(string, string2), null);
        Main.main.undoRedo.add(new ChangePropertyCommand(collection, string, string2));
        this.btnAdd.requestFocusInWindow();
    }

    private void suggestRecentlyAddedTags(JPanel jPanel, final AutoCompletingComboBox autoCompletingComboBox, final AutoCompletingComboBox autoCompletingComboBox2, List<JosmAction> list, int n, final FocusAdapter focusAdapter) {
        if (n > 0 && !recentTags.isEmpty()) {
            jPanel.add((Component)new JLabel(I18n.tr("Recently added tags", new Object[0])), GBC.eol());
            int n2 = 1;
            LinkedList<Tag> linkedList = new LinkedList<Tag>(recentTags.keySet());
            for (int i = linkedList.size() - 1; i >= 0 && n2 <= n; --i, ++n2) {
                ImageIcon imageIcon;
                final Tag tag = (Tag)linkedList.get(i);
                String string = "properties:recent:" + n2;
                Shortcut shortcut = Shortcut.registerShortcut(string, null, 48 + n2, 5006);
                final JosmAction josmAction = new JosmAction(string, null, I18n.tr("Use this tag again", new Object[0]), shortcut, false){

                    public void actionPerformed(ActionEvent actionEvent) {
                        autoCompletingComboBox.setSelectedItem(tag.getKey());
                        autoCompletingComboBox2.setSelectedItem(tag.getValue());
                        focusAdapter.focusGained(null);
                    }
                };
                list.add(josmAction);
                for (int j = 0; j < this.propertyData.getRowCount(); ++j) {
                    if (!tag.getKey().equals(this.propertyData.getValueAt(j, 0))) continue;
                    josmAction.setEnabled(false);
                    break;
                }
                if ((imageIcon = MapPaintStyles.getNodeIcon(tag, false)) == null) {
                    imageIcon = new ImageIcon(new BufferedImage(16, 16, 2));
                }
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.ipadx = 5;
                jPanel.add((Component)new JLabel(josmAction.isEnabled() ? imageIcon : GuiHelper.getDisabledIcon(imageIcon)), gridBagConstraints);
                String string2 = josmAction.isEnabled() ? "" : "; color:gray";
                JLabel jLabel = new JLabel("<html><style>td{border:1px solid gray; font-weight:normal" + string2 + "}</style>" + "<table><tr><td>" + tag.toString() + "</td></tr></table></html>");
                if (josmAction.isEnabled()) {
                    jPanel.getInputMap(2).put(shortcut.getKeyStroke(), string);
                    jPanel.getActionMap().put(string, josmAction);
                    jLabel.setToolTipText((String)josmAction.getValue("ShortDescription"));
                    jLabel.setCursor(Cursor.getPredefinedCursor(12));
                    jLabel.addMouseListener(new MouseAdapter(){

                        public void mouseClicked(MouseEvent mouseEvent) {
                            josmAction.actionPerformed(null);
                        }
                    });
                } else {
                    jLabel.setEnabled(false);
                    jLabel.setToolTipText(I18n.tr("The key ''{0}'' is already used", tag.getKey()));
                }
                JPanel jPanel2 = new JPanel(new FlowLayout(0, 0, 0));
                jPanel2.add(jLabel);
                jPanel.add((Component)jPanel2, GBC.eol().fill(2));
            }
        }
    }

    private FocusAdapter addFocusAdapter(final AutoCompletingComboBox autoCompletingComboBox, final AutoCompletingComboBox autoCompletingComboBox2, final AutoCompletionManager autoCompletionManager, final Comparator<AutoCompletionListItem> comparator) {
        JTextComponent jTextComponent = (JTextComponent)autoCompletingComboBox2.getEditor().getEditorComponent();
        FocusAdapter focusAdapter = new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                String string = autoCompletingComboBox.getEditor().getItem().toString();
                List<AutoCompletionListItem> list = autoCompletionManager.getValues(PropertiesDialog.getAutocompletionKeys(string));
                Collections.sort(list, comparator);
                autoCompletingComboBox2.setPossibleACItems(list);
                PropertiesDialog.this.objKey = string;
            }
        };
        jTextComponent.addFocusListener(focusAdapter);
        return focusAdapter;
    }

    public PropertiesDialog(MapFrame mapFrame) {
        super(I18n.tr("Properties/Memberships", new Object[0]), "propertiesdialog", I18n.tr("Properties for selected objects.", new Object[0]), Shortcut.registerShortcut("subwindow:properties", I18n.tr("Toggle: {0}", I18n.tr("Properties/Memberships", new Object[0])), 80, 5007), 150, true);
        this.propertyMenu = new JPopupMenu();
        this.propertyMenu.add(this.copyValueAction);
        this.propertyMenu.add(this.copyKeyValueAction);
        this.propertyMenu.add(this.copyAllKeyValueAction);
        this.propertyMenu.addSeparator();
        this.propertyMenu.add(this.searchActionAny);
        this.propertyMenu.add(this.searchActionSame);
        this.propertyMenu.addSeparator();
        this.propertyMenu.add(this.helpAction);
        this.propertyData.setColumnIdentifiers(new String[]{I18n.tr("Key", new Object[0]), I18n.tr("Value", new Object[0])});
        this.propertyTable.setSelectionMode(2);
        this.propertyTable.getTableHeader().setReorderingAllowed(false);
        this.propertyTable.addMouseListener(new PopupMenuLauncher(){

            public void launch(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                int n = PropertiesDialog.this.propertyTable.rowAtPoint(point);
                if (n > -1) {
                    PropertiesDialog.this.propertyTable.changeSelection(n, 0, false, false);
                    PropertiesDialog.this.propertyMenu.show(PropertiesDialog.this.propertyTable, point.x, point.y - 3);
                }
            }
        });
        this.propertyTable.getColumnModel().getColumn(1).setCellRenderer(new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl, false, n, n2);
                if (object == null) {
                    return this;
                }
                if (component instanceof JLabel) {
                    String string = null;
                    if (object instanceof String) {
                        string = (String)object;
                    } else if (object instanceof Map) {
                        Map map = (Map)object;
                        if (map.size() != 1) {
                            string = I18n.tr("<different>", new Object[0]);
                            component.setFont(component.getFont().deriveFont(2));
                        } else {
                            Map.Entry entry = map.entrySet().iterator().next();
                            string = (String)entry.getKey();
                        }
                    }
                    ((JLabel)component).setText(string);
                }
                return component;
            }
        });
        this.membershipMenu = new JPopupMenu();
        this.membershipMenu.add(new SelectRelationAction(true));
        this.membershipMenu.add(new SelectRelationAction(false));
        this.membershipMenu.add(new SelectRelationMembersAction());
        this.membershipMenu.add(new DownloadIncompleteMembersAction());
        this.membershipMenu.addSeparator();
        this.membershipMenu.add(this.helpAction);
        this.membershipData.setColumnIdentifiers(new String[]{I18n.tr("Member Of", new Object[0]), I18n.tr("Role", new Object[0]), I18n.tr("Position", new Object[0])});
        this.membershipTable.setSelectionMode(0);
        this.membershipTable.addMouseListener(new PopupMenuLauncher(){

            public void launch(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                int n = PropertiesDialog.this.membershipTable.rowAtPoint(point);
                if (n > -1) {
                    PropertiesDialog.this.membershipTable.changeSelection(n, 0, false, false);
                    Relation relation = (Relation)PropertiesDialog.this.membershipData.getValueAt(n, 0);
                    for (Component component : PropertiesDialog.this.membershipMenu.getComponents()) {
                        Action action;
                        if (!(component instanceof JMenuItem) || !((action = ((JMenuItem)component).getAction()) instanceof RelationRelated)) continue;
                        ((RelationRelated)((Object)action)).setRelation(relation);
                    }
                    PropertiesDialog.this.membershipMenu.show(PropertiesDialog.this.membershipTable, point.x, point.y - 3);
                }
            }
        });
        TableColumnModel tableColumnModel = this.membershipTable.getColumnModel();
        this.membershipTable.getTableHeader().setReorderingAllowed(false);
        tableColumnModel.getColumn(0).setCellRenderer(new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl, false, n, n2);
                if (object == null) {
                    return this;
                }
                if (component instanceof JLabel) {
                    JLabel jLabel = (JLabel)component;
                    Relation relation = (Relation)object;
                    jLabel.setText(relation.getDisplayName(DefaultNameFormatter.getInstance()));
                    if (relation.isDisabledAndHidden()) {
                        jLabel.setFont(jLabel.getFont().deriveFont(2));
                    }
                }
                return component;
            }
        });
        tableColumnModel.getColumn(1).setCellRenderer(new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                if (object == null) {
                    return this;
                }
                Component component = super.getTableCellRendererComponent(jTable, object, bl, false, n, n2);
                boolean bl3 = ((Relation)jTable.getValueAt(n, 0)).isDisabledAndHidden();
                if (component instanceof JLabel) {
                    JLabel jLabel = (JLabel)component;
                    MemberInfo memberInfo = (MemberInfo)object;
                    String string = null;
                    for (RelationMember relationMember : memberInfo.role) {
                        if (string == null) {
                            string = relationMember.getRole();
                            continue;
                        }
                        if (string.equals(relationMember.getRole())) continue;
                        string = I18n.tr("<different>", new Object[0]);
                        break;
                    }
                    jLabel.setText(string);
                    if (bl3) {
                        jLabel.setFont(jLabel.getFont().deriveFont(2));
                    }
                }
                return component;
            }
        });
        tableColumnModel.getColumn(2).setCellRenderer(new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl, false, n, n2);
                boolean bl3 = ((Relation)jTable.getValueAt(n, 0)).isDisabledAndHidden();
                if (component instanceof JLabel) {
                    JLabel jLabel = (JLabel)component;
                    jLabel.setText(((MemberInfo)jTable.getValueAt(n, 1)).getPositionString());
                    if (bl3) {
                        jLabel.setFont(jLabel.getFont().deriveFont(2));
                    }
                }
                return component;
            }
        });
        tableColumnModel.getColumn(2).setPreferredWidth(20);
        tableColumnModel.getColumn(1).setPreferredWidth(40);
        tableColumnModel.getColumn(0).setPreferredWidth(200);
        JPanel jPanel = new JPanel();
        boolean bl = Main.pref.getBoolean("properties.presets.top", true);
        jPanel.setLayout(new GridBagLayout());
        if (bl) {
            jPanel.add((Component)this.presets, GBC.std().fill(2).insets(5, 2, 5, 2).anchor(18));
            double d = Double.MIN_VALUE;
            jPanel.add((Component)pluginHook, GBC.eol().insets(0, 1, 1, 1).anchor(12).weight(d, d));
        }
        jPanel.add((Component)this.selectSth, GBC.eol().fill().insets(10, 10, 10, 10));
        jPanel.add((Component)this.propertyTable.getTableHeader(), GBC.eol().fill(2));
        jPanel.add((Component)this.propertyTable, GBC.eol().fill(1));
        jPanel.add((Component)this.membershipTable.getTableHeader(), GBC.eol().fill(2));
        jPanel.add((Component)this.membershipTable, GBC.eol().fill(1));
        if (!bl) {
            jPanel.add((Component)this.presets, GBC.eol().fill(2).insets(5, 2, 5, 2));
        }
        this.propertyTable.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "onTableEnter");
        this.propertyTable.getActionMap().put("onTableEnter", this.editAction);
        this.membershipTable.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "onTableEnter");
        this.membershipTable.getActionMap().put("onTableEnter", this.editAction);
        this.propertyTable.getInputMap(1).put(KeyStroke.getKeyStroke(155, 0), "onTableInsert");
        this.propertyTable.getActionMap().put("onTableInsert", this.addAction);
        InputMapUtils.unassignCtrlShiftUpDown(this.propertyTable, 1);
        this.btnAdd = new SideButton(this.addAction);
        InputMapUtils.enableEnter(this.btnAdd);
        this.propertyTable.getSelectionModel().addListSelectionListener(this.editAction);
        this.membershipTable.getSelectionModel().addListSelectionListener(this.editAction);
        this.btnEdit = new SideButton(this.editAction);
        this.btnDel = new SideButton(this.deleteAction);
        this.membershipTable.getSelectionModel().addListSelectionListener(this.deleteAction);
        this.propertyTable.getSelectionModel().addListSelectionListener(this.deleteAction);
        this.getInputMap(1).put(KeyStroke.getKeyStroke(127, 0), "delete");
        this.getActionMap().put("delete", this.deleteAction);
        JScrollPane jScrollPane = (JScrollPane)this.createLayout(jPanel, true, Arrays.asList(this.btnAdd, this.btnEdit, this.btnDel));
        MouseClickWatch mouseClickWatch = new MouseClickWatch();
        this.propertyTable.addMouseListener(mouseClickWatch);
        this.membershipTable.addMouseListener(mouseClickWatch);
        jScrollPane.addMouseListener(mouseClickWatch);
        this.selectSth.setPreferredSize(jScrollPane.getSize());
        this.presets.setSize(jScrollPane.getSize());
        this.getInputMap(1).put(KeyStroke.getKeyStroke(112, 0), "onHelp");
        this.getActionMap().put("onHelp", this.helpAction);
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl && Main.main.getCurrentDataSet() != null) {
            this.selectionChanged(Main.main.getCurrentDataSet().getSelected());
        }
    }

    private int findRow(TableModel tableModel, Object object) {
        for (int i = 0; i < tableModel.getRowCount(); ++i) {
            if (!tableModel.getValueAt(i, 0).equals(object)) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void selectionChanged(Collection<? extends OsmPrimitive> collection) {
        int n;
        int n2;
        Object object;
        if (!this.isVisible()) {
            return;
        }
        if (this.propertyTable == null) {
            return;
        }
        if (this.propertyTable.getCellEditor() != null) {
            this.propertyTable.getCellEditor().cancelCellEditing();
        }
        String string = null;
        Relation relation = null;
        if (this.propertyTable.getSelectedRowCount() == 1) {
            string = (String)this.propertyData.getValueAt(this.propertyTable.getSelectedRow(), 0);
        }
        if (this.membershipTable.getSelectedRowCount() == 1) {
            relation = (Relation)this.membershipData.getValueAt(this.membershipTable.getSelectedRow(), 0);
        }
        this.propertyData.setRowCount(0);
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        this.valueCount.clear();
        EnumSet<TaggingPreset.PresetType> enumSet = EnumSet.noneOf(TaggingPreset.PresetType.class);
        for (OsmPrimitive object22 : collection) {
            enumSet.add(TaggingPreset.PresetType.forPrimitive(object22));
            for (String string2 : object22.keySet()) {
                String string3 = object22.get(string2);
                hashMap.put(string2, hashMap.containsKey(string2) ? (Integer)hashMap.get(string2) + 1 : 1);
                if (this.valueCount.containsKey(string2)) {
                    object.put((Object)string3, (object = this.valueCount.get(string2)).containsKey(string3) ? (Integer)object.get(string3) + 1 : 1);
                    continue;
                }
                object = new TreeMap<String, Integer>();
                ((TreeMap)object).put(string3, 1);
                this.valueCount.put(string2, (Map<String, Integer>)object);
            }
        }
        for (Map.Entry entry : this.valueCount.entrySet()) {
            void var9_15;
            boolean bl = false;
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                var9_15 += ((Integer)entry2.getValue()).intValue();
            }
            if (var9_15 < collection.size()) {
                ((Map)entry.getValue()).put("", collection.size() - var9_15);
            }
            this.propertyData.addRow(new Object[]{entry.getKey(), entry.getValue()});
            hashMap2.put((String)entry.getKey(), ((Map)entry.getValue()).size() == 1 ? (String)((Map)entry.getValue()).keySet().iterator().next() : I18n.tr("<different>", new Object[0]));
        }
        this.membershipData.setRowCount(0);
        HashMap hashMap3 = new HashMap();
        for (OsmPrimitive osmPrimitive : collection) {
            for (OsmPrimitive osmPrimitive2 : osmPrimitive.getReferrers()) {
                if (!(osmPrimitive2 instanceof Relation) || osmPrimitive2.isIncomplete() || osmPrimitive2.isDeleted()) continue;
                object = (Relation)osmPrimitive2;
                MemberInfo memberInfo = (MemberInfo)hashMap3.get(object);
                if (memberInfo == null) {
                    memberInfo = new MemberInfo();
                }
                hashMap3.put(object, memberInfo);
                int n3 = 1;
                for (RelationMember relationMember : ((Relation)object).getMembers()) {
                    if (relationMember.getMember() == osmPrimitive) {
                        memberInfo.add(relationMember, n3);
                    }
                    ++n3;
                }
            }
        }
        ArrayList arrayList = new ArrayList(hashMap3.keySet());
        Collections.sort(arrayList, new Comparator<Relation>(){

            @Override
            public int compare(Relation relation, Relation relation2) {
                int n = Boolean.valueOf(relation.isDisabledAndHidden()).compareTo(relation2.isDisabledAndHidden());
                if (n == 0) {
                    n = relation.getDisplayName(DefaultNameFormatter.getInstance()).compareTo(relation2.getDisplayName(DefaultNameFormatter.getInstance()));
                }
                return n;
            }
        });
        for (Relation relation2 : arrayList) {
            this.membershipData.addRow(new Object[]{relation2, hashMap3.get(relation2)});
        }
        this.presets.updatePresets(enumSet, hashMap2, this.presetHandler);
        this.membershipTable.getTableHeader().setVisible(this.membershipData.getRowCount() > 0);
        this.membershipTable.setVisible(this.membershipData.getRowCount() > 0);
        boolean bl = !collection.isEmpty();
        boolean bl2 = bl && this.propertyData.getRowCount() > 0;
        boolean bl3 = bl && this.membershipData.getRowCount() > 0;
        this.btnAdd.setEnabled(bl);
        this.btnEdit.setEnabled(bl2 || bl3);
        this.btnDel.setEnabled(bl2 || bl3);
        this.propertyTable.setVisible(bl2);
        this.propertyTable.getTableHeader().setVisible(bl2);
        this.selectSth.setVisible(!bl);
        pluginHook.setVisible(bl);
        if (string != null && (n2 = this.findRow(this.propertyData, string)) != -1) {
            this.propertyTable.changeSelection(n2, 0, false, false);
        } else if (relation != null && (n = this.findRow(this.membershipData, relation)) != -1) {
            this.membershipTable.changeSelection(n, 0, false, false);
        } else if (bl2) {
            this.propertyTable.changeSelection(0, 0, false, false);
        } else if (bl3) {
            this.membershipTable.changeSelection(0, 0, false, false);
        }
        if (this.propertyData.getRowCount() != 0 || this.membershipData.getRowCount() != 0) {
            this.setTitle(I18n.tr("Properties: {0} / Memberships: {1}", this.propertyData.getRowCount(), this.membershipData.getRowCount()));
        } else {
            this.setTitle(I18n.tr("Properties / Memberships", new Object[0]));
        }
    }

    private void updateSelection() {
        if (Main.main.getCurrentDataSet() == null) {
            this.selectionChanged(Collections.emptyList());
        } else {
            this.selectionChanged(Main.main.getCurrentDataSet().getSelected());
        }
    }

    @Override
    public void editLayerChanged(OsmDataLayer osmDataLayer, OsmDataLayer osmDataLayer2) {
        this.updateSelection();
    }

    @Override
    public void processDatasetEvent(AbstractDatasetChangedEvent abstractDatasetChangedEvent) {
        this.updateSelection();
    }

    public void addPropertyPopupMenuSeparator() {
        this.propertyMenu.addSeparator();
    }

    public JMenuItem addPropertyPopupMenuAction(Action action) {
        return this.propertyMenu.add(action);
    }

    public void addPropertyPopupMenuListener(PopupMenuListener popupMenuListener) {
        this.propertyMenu.addPopupMenuListener(popupMenuListener);
    }

    public void removePropertyPopupMenuListener(PopupMenuListener popupMenuListener) {
        this.propertyMenu.addPopupMenuListener(popupMenuListener);
    }

    public Tag getSelectedProperty() {
        int n = this.propertyTable.getSelectedRow();
        if (n == -1) {
            return null;
        }
        TreeMap treeMap = (TreeMap)this.propertyData.getValueAt(n, 1);
        return new Tag(this.propertyData.getValueAt(n, 0).toString(), treeMap.size() > 1 ? "" : (String)treeMap.keySet().iterator().next());
    }

    public void addMembershipPopupMenuSeparator() {
        this.membershipMenu.addSeparator();
    }

    public JMenuItem addMembershipPopupMenuAction(Action action) {
        return this.membershipMenu.add(action);
    }

    public void addMembershipPopupMenuListener(PopupMenuListener popupMenuListener) {
        this.membershipMenu.addPopupMenuListener(popupMenuListener);
    }

    public void removeMembershipPopupMenuListener(PopupMenuListener popupMenuListener) {
        this.membershipMenu.addPopupMenuListener(popupMenuListener);
    }

    public IRelation getSelectedMembershipRelation() {
        int n = this.membershipTable.getSelectedRow();
        return n > -1 ? (IRelation)this.membershipData.getValueAt(n, 0) : null;
    }

    @Override
    public void destroy() {
        super.destroy();
        for (JosmAction josmAction : this.josmActions) {
            josmAction.destroy();
        }
        Container container = pluginHook.getParent();
        if (container != null) {
            container.remove(pluginHook);
        }
    }

    class SearchAction
    extends AbstractAction {
        final boolean sameType;

        public SearchAction(boolean bl) {
            this.sameType = bl;
            if (bl) {
                this.putValue("Name", I18n.tr("Search Key/Value/Type", new Object[0]));
                this.putValue("ShortDescription", I18n.tr("Search with the key and value of the selected tag, restrict to type (i.e., node/way/relation)", new Object[0]));
            } else {
                this.putValue("Name", I18n.tr("Search Key/Value", new Object[0]));
                this.putValue("ShortDescription", I18n.tr("Search with the key and value of the selected tag", new Object[0]));
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (PropertiesDialog.this.propertyTable.getSelectedRowCount() != 1) {
                return;
            }
            String string = PropertiesDialog.this.propertyData.getValueAt(PropertiesDialog.this.propertyTable.getSelectedRow(), 0).toString();
            Collection<OsmPrimitive> collection = Main.main.getCurrentDataSet().getSelected();
            if (collection.isEmpty()) {
                return;
            }
            String string2 = "";
            String string3 = "";
            for (OsmPrimitive osmPrimitive : collection) {
                String string4 = osmPrimitive.get(string);
                if (string4 == null) continue;
                String string5 = "";
                if (!this.sameType) {
                    string5 = "";
                } else if (osmPrimitive instanceof Node) {
                    string5 = "type:node ";
                } else if (osmPrimitive instanceof Way) {
                    string5 = "type:way ";
                } else if (osmPrimitive instanceof Relation) {
                    string5 = "type:relation ";
                }
                string3 = string3 + string2 + "(" + string5 + "\"" + org.openstreetmap.josm.actions.search.SearchAction.escapeStringForSearch(string) + "\"=\"" + org.openstreetmap.josm.actions.search.SearchAction.escapeStringForSearch(string4) + "\")";
                string2 = " OR ";
            }
            SearchAction.SearchSetting searchSetting = new SearchAction.SearchSetting(string3, SearchAction.SearchMode.replace, true, false, false);
            org.openstreetmap.josm.actions.search.SearchAction.searchWithoutHistory(searchSetting);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CopyAllKeyValueAction
    extends AbstractCopyAction {
        public CopyAllKeyValueAction() {
            this.putValue("Name", I18n.tr("Copy all Keys/Values", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Copy the key and value of the all tags to clipboard", new Object[0]));
        }

        @Override
        protected Collection<String> getString(OsmPrimitive osmPrimitive, String string) {
            LinkedList<String> linkedList = new LinkedList<String>();
            for (Map.Entry<String, String> entry : osmPrimitive.getKeys().entrySet()) {
                linkedList.add(new Tag(entry.getKey(), entry.getValue()).toString());
            }
            return linkedList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CopyKeyValueAction
    extends AbstractCopyAction {
        public CopyKeyValueAction() {
            this.putValue("Name", I18n.tr("Copy Key/Value", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Copy the key and value of the selected tag to clipboard", new Object[0]));
        }

        @Override
        protected Collection<String> getString(OsmPrimitive osmPrimitive, String string) {
            String string2 = osmPrimitive.get(string);
            return string2 == null ? null : Collections.singleton(new Tag(string, string2).toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CopyValueAction
    extends AbstractCopyAction {
        public CopyValueAction() {
            this.putValue("Name", I18n.tr("Copy Value", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Copy the value of the selected tag to clipboard", new Object[0]));
        }

        @Override
        protected Collection<String> getString(OsmPrimitive osmPrimitive, String string) {
            String string2 = osmPrimitive.get(string);
            return string2 == null ? null : Collections.singleton(string2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class AbstractCopyAction
    extends AbstractAction {
        AbstractCopyAction() {
        }

        protected abstract Collection<String> getString(OsmPrimitive var1, String var2);

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (PropertiesDialog.this.propertyTable.getSelectedRowCount() != 1) {
                return;
            }
            String string = PropertiesDialog.this.propertyData.getValueAt(PropertiesDialog.this.propertyTable.getSelectedRow(), 0).toString();
            Collection<OsmPrimitive> collection = Main.main.getCurrentDataSet().getSelected();
            if (collection.isEmpty()) {
                return;
            }
            TreeSet<String> treeSet = new TreeSet<String>();
            for (OsmPrimitive osmPrimitive : collection) {
                Collection<String> collection2 = this.getString(osmPrimitive, string);
                if (collection2 == null) continue;
                treeSet.addAll(collection2);
            }
            Utils.copyToClipboard(Utils.join("\n", treeSet));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DownloadIncompleteMembersAction
    extends AbstractRelationAction {
        public DownloadIncompleteMembersAction() {
            this.putValue("ShortDescription", I18n.tr("Download incomplete members of selected relations", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs/relation", "downloadincompleteselected"));
            this.putValue("Name", I18n.tr("Download incomplete members", new Object[0]));
        }

        public Set<OsmPrimitive> buildSetOfIncompleteMembers(Relation relation) {
            HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
            hashSet.addAll(relation.getIncompleteMembers());
            return hashSet;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.relation.hasIncompleteMembers()) {
                return;
            }
            ArrayList<Relation> arrayList = new ArrayList<Relation>();
            arrayList.add(this.relation);
            Main.worker.submit(new DownloadRelationMemberTask(arrayList, this.buildSetOfIncompleteMembers(this.relation), Main.map.mapView.getEditLayer()));
        }
    }

    class SelectRelationMembersAction
    extends AbstractRelationAction {
        public SelectRelationMembersAction() {
            this.putValue("ShortDescription", I18n.tr("Select the members of selected relation", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("selectall"));
            this.putValue("Name", I18n.tr("Select members", new Object[0]));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
            hashSet.addAll(this.relation.getMemberPrimitives());
            Main.map.mapView.getEditLayer().data.setSelected(hashSet);
        }
    }

    static class SelectRelationAction
    extends AbstractRelationAction {
        boolean selectionmode;

        public SelectRelationAction(boolean bl) {
            this.selectionmode = bl;
            if (bl) {
                this.putValue("Name", I18n.tr("Select relation", new Object[0]));
                this.putValue("ShortDescription", I18n.tr("Select relation in main selection.", new Object[0]));
                this.putValue("SmallIcon", ImageProvider.get("dialogs", "select"));
            } else {
                this.putValue("Name", I18n.tr("Select in relation list", new Object[0]));
                this.putValue("ShortDescription", I18n.tr("Select relation in relation list.", new Object[0]));
                this.putValue("SmallIcon", ImageProvider.get("dialogs", "relationlist"));
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.selectionmode) {
                Main.map.mapView.getEditLayer().data.setSelected(this.relation);
            } else {
                Main.map.relationListDialog.selectRelation(this.relation);
                Main.map.relationListDialog.unfurlDialog();
            }
        }
    }

    static abstract class AbstractRelationAction
    extends AbstractAction
    implements RelationRelated {
        protected Relation relation;

        AbstractRelationAction() {
        }

        public Relation getRelation() {
            return this.relation;
        }

        public void setRelation(Relation relation) {
            this.relation = relation;
        }
    }

    public static interface RelationRelated {
        public Relation getRelation();

        public void setRelation(Relation var1);
    }

    class HelpAction
    extends AbstractAction {
        public HelpAction() {
            this.putValue("Name", I18n.tr("Go to OSM wiki for tag help (F1)", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Launch browser with wiki help for selected object", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "search"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                String string = Main.pref.get("url.openstreetmap-wiki", "http://wiki.openstreetmap.org/wiki/");
                String string2 = LanguageInfo.getWikiLanguagePrefix();
                final ArrayList<URI> arrayList = new ArrayList<URI>();
                if (PropertiesDialog.this.propertyTable.getSelectedRowCount() == 1) {
                    int n = PropertiesDialog.this.propertyTable.getSelectedRow();
                    String string3 = URLEncoder.encode(PropertiesDialog.this.propertyData.getValueAt(n, 0).toString(), "UTF-8");
                    String string4 = URLEncoder.encode((String)((Map)PropertiesDialog.this.propertyData.getValueAt(n, 1)).entrySet().iterator().next().getKey(), "UTF-8");
                    arrayList.add(new URI(String.format("%s%sTag:%s=%s", string, string2, string3, string4)));
                    arrayList.add(new URI(String.format("%sTag:%s=%s", string, string3, string4)));
                    arrayList.add(new URI(String.format("%s%sKey:%s", string, string2, string3)));
                    arrayList.add(new URI(String.format("%sKey:%s", string, string3)));
                    arrayList.add(new URI(String.format("%s%sMap_Features", string, string2)));
                    arrayList.add(new URI(String.format("%sMap_Features", string)));
                } else if (PropertiesDialog.this.membershipTable.getSelectedRowCount() == 1) {
                    int n = PropertiesDialog.this.membershipTable.getSelectedRow();
                    String string5 = URLEncoder.encode(((Relation)PropertiesDialog.this.membershipData.getValueAt(n, 0)).get("type"), "UTF-8");
                    if (string5 != null && !string5.equals("")) {
                        arrayList.add(new URI(String.format("%s%sRelation:%s", string, string2, string5)));
                        arrayList.add(new URI(String.format("%sRelation:%s", string, string5)));
                    }
                    arrayList.add(new URI(String.format("%s%sRelations", string, string2)));
                    arrayList.add(new URI(String.format("%sRelations", string)));
                } else {
                    arrayList.add(new URI(String.format("%s%sMap_Features", string, string2)));
                    arrayList.add(new URI(String.format("%sMap_Features", string)));
                }
                Main.worker.execute(new Runnable(){

                    public void run() {
                        try {
                            for (URI uRI : arrayList) {
                                HttpURLConnection httpURLConnection = (HttpURLConnection)uRI.toURL().openConnection();
                                httpURLConnection.setConnectTimeout(Main.pref.getInteger("socket.timeout.connect", 15) * 1000);
                                if (httpURLConnection.getResponseCode() != 200) {
                                    Main.info("INFO: {0} does not exist", uRI);
                                    httpURLConnection.disconnect();
                                    continue;
                                }
                                int n = httpURLConnection.getContentLength();
                                httpURLConnection.disconnect();
                                httpURLConnection = (HttpURLConnection)new URI(uRI.toString().replace("=", "%3D").replaceFirst("/wiki/", "/w/index.php?redirect=no&title=")).toURL().openConnection();
                                httpURLConnection.setConnectTimeout(Main.pref.getInteger("socket.timeout.connect", 15) * 1000);
                                if (Math.abs(httpURLConnection.getContentLength() - n) > 200) {
                                    Main.info("INFO: {0} is a mediawiki redirect", uRI);
                                    httpURLConnection.disconnect();
                                    continue;
                                }
                                Main.info("INFO: browsing to {0}", uRI);
                                httpURLConnection.disconnect();
                                OpenBrowser.displayUrl(uRI.toString());
                                break;
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                });
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    class EditAction
    extends JosmAction
    implements ListSelectionListener {
        public EditAction() {
            super(I18n.tr("Edit", new Object[0]), "dialogs/edit", I18n.tr("Edit the value of the selected key for all objects", new Object[0]), Shortcut.registerShortcut("properties:edit", I18n.tr("Edit Properties", new Object[0]), 83, 5004), false);
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.isEnabled()) {
                return;
            }
            if (PropertiesDialog.this.propertyTable.getSelectedRowCount() == 1) {
                int n = PropertiesDialog.this.propertyTable.getSelectedRow();
                PropertiesDialog.this.editProperty(n);
            } else if (PropertiesDialog.this.membershipTable.getSelectedRowCount() == 1) {
                int n = PropertiesDialog.this.membershipTable.getSelectedRow();
                PropertiesDialog.this.editMembership(n);
            }
        }

        protected void updateEnabledState() {
            this.setEnabled((PropertiesDialog.this.propertyTable != null && PropertiesDialog.this.propertyTable.getSelectedRowCount() == 1) ^ (PropertiesDialog.this.membershipTable != null && PropertiesDialog.this.membershipTable.getSelectedRowCount() == 1));
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }
    }

    class AddAction
    extends JosmAction {
        public AddAction() {
            super(I18n.tr("Add", new Object[0]), "dialogs/add", I18n.tr("Add a new key/value pair to all objects", new Object[0]), Shortcut.registerShortcut("properties:add", I18n.tr("Add Property", new Object[0]), 65, 5004), false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PropertiesDialog.this.addProperty();
        }
    }

    class DeleteAction
    extends JosmAction
    implements ListSelectionListener {
        public DeleteAction() {
            super(I18n.tr("Delete", new Object[0]), "dialogs/delete", I18n.tr("Delete the selected key in all objects", new Object[0]), Shortcut.registerShortcut("properties:delete", I18n.tr("Delete Properties", new Object[0]), 68, 5010), false);
            this.updateEnabledState();
        }

        /*
         * WARNING - void declaration
         */
        protected void deleteProperties(int[] nArray) {
            void var4_7;
            HashMap<String, String> hashMap = new HashMap<String, String>(nArray.length);
            int n = nArray[0];
            for (int n2 : nArray) {
                String string = PropertiesDialog.this.propertyData.getValueAt(n2, 0).toString();
                if (n2 == n + 1) {
                    n = n2;
                }
                hashMap.put(string, null);
            }
            Object var4_5 = null;
            int n3 = PropertiesDialog.this.propertyData.getRowCount();
            if (n3 > nArray.length) {
                n = n == nArray[nArray.length - 1] ? (n + 1 < n3 ? n + 1 : nArray[0] - 1) : ++n;
                String string = (String)PropertiesDialog.this.propertyData.getValueAt(n, 0);
            }
            Collection<OsmPrimitive> collection = Main.main.getCurrentDataSet().getSelected();
            Main.main.undoRedo.add(new ChangePropertyCommand(collection, hashMap));
            PropertiesDialog.this.membershipTable.clearSelection();
            if (var4_7 != null) {
                PropertiesDialog.this.propertyTable.changeSelection(PropertiesDialog.this.findRow(PropertiesDialog.this.propertyData, var4_7), 0, false, false);
            }
        }

        protected void deleteFromRelation(int n) {
            Relation relation = (Relation)PropertiesDialog.this.membershipData.getValueAt(n, 0);
            Relation relation2 = null;
            int n2 = PropertiesDialog.this.membershipTable.getRowCount();
            if (n2 > 1) {
                relation2 = (Relation)PropertiesDialog.this.membershipData.getValueAt(n + 1 < n2 ? n + 1 : n - 1, 0);
            }
            ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, I18n.tr("Change relation", new Object[0]), new String[]{I18n.tr("Delete from relation", new Object[0]), I18n.tr("Cancel", new Object[0])});
            extendedDialog.setButtonIcons(new String[]{"dialogs/delete.png", "cancel.png"});
            extendedDialog.setContent(I18n.tr("Really delete selection from relation {0}?", relation.getDisplayName(DefaultNameFormatter.getInstance())));
            extendedDialog.toggleEnable("delete_from_relation");
            extendedDialog.showDialog();
            if (extendedDialog.getValue() != 1) {
                return;
            }
            Relation relation3 = new Relation(relation);
            Collection<OsmPrimitive> collection = Main.main.getCurrentDataSet().getSelected();
            for (OsmPrimitive osmPrimitive : collection) {
                relation3.removeMembersFor(osmPrimitive);
            }
            Main.main.undoRedo.add(new ChangeCommand(relation, relation3));
            PropertiesDialog.this.propertyTable.clearSelection();
            if (relation2 != null) {
                PropertiesDialog.this.membershipTable.changeSelection(PropertiesDialog.this.findRow(PropertiesDialog.this.membershipData, relation2), 0, false, false);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (PropertiesDialog.this.propertyTable.getSelectedRowCount() > 0) {
                int[] nArray = PropertiesDialog.this.propertyTable.getSelectedRows();
                this.deleteProperties(nArray);
            } else if (PropertiesDialog.this.membershipTable.getSelectedRowCount() > 0) {
                int n = PropertiesDialog.this.membershipTable.getSelectedRow();
                this.deleteFromRelation(n);
            }
        }

        protected void updateEnabledState() {
            this.setEnabled(PropertiesDialog.this.propertyTable != null && PropertiesDialog.this.propertyTable.getSelectedRowCount() >= 1 || PropertiesDialog.this.membershipTable != null && PropertiesDialog.this.membershipTable.getSelectedRowCount() == 1);
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }
    }

    static class MemberInfo {
        List<RelationMember> role = new ArrayList<RelationMember>();
        List<Integer> position = new ArrayList<Integer>();
        private String positionString = null;

        MemberInfo() {
        }

        void add(RelationMember relationMember, Integer n) {
            this.role.add(relationMember);
            this.position.add(n);
        }

        String getPositionString() {
            if (this.positionString == null) {
                Collections.sort(this.position);
                this.positionString = String.valueOf(this.position.get(0));
                int n = 0;
                int n2 = this.position.get(0);
                for (int i = 1; i < this.position.size(); ++i) {
                    int n3 = this.position.get(i);
                    if (n3 == n2 + 1) {
                        ++n;
                    } else if (n == 0) {
                        this.positionString = this.positionString + "," + String.valueOf(n3);
                    } else {
                        this.positionString = this.positionString + "-" + String.valueOf(n2);
                        this.positionString = this.positionString + "," + String.valueOf(n3);
                        n = 0;
                    }
                    n2 = n3;
                }
                if (n >= 1) {
                    this.positionString = this.positionString + "-" + String.valueOf(n2);
                }
            }
            if (this.positionString.length() > 20) {
                this.positionString = this.positionString.substring(0, 17) + "...";
            }
            return this.positionString;
        }
    }

    public class MouseClickWatch
    extends MouseAdapter {
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() < 2) {
                if (mouseEvent.getSource() == PropertiesDialog.this.propertyTable) {
                    PropertiesDialog.this.membershipTable.clearSelection();
                } else if (mouseEvent.getSource() == PropertiesDialog.this.membershipTable) {
                    PropertiesDialog.this.propertyTable.clearSelection();
                }
            } else if (mouseEvent.getSource() == PropertiesDialog.this.propertyTable) {
                int n = PropertiesDialog.this.propertyTable.rowAtPoint(mouseEvent.getPoint());
                if (n > -1) {
                    PropertiesDialog.this.editProperty(n);
                } else {
                    PropertiesDialog.this.addProperty();
                }
            } else if (mouseEvent.getSource() == PropertiesDialog.this.membershipTable) {
                int n = PropertiesDialog.this.membershipTable.rowAtPoint(mouseEvent.getPoint());
                if (n > -1) {
                    PropertiesDialog.this.editMembership(n);
                }
            } else {
                PropertiesDialog.this.addProperty();
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() == PropertiesDialog.this.propertyTable) {
                PropertiesDialog.this.membershipTable.clearSelection();
            } else if (mouseEvent.getSource() == PropertiesDialog.this.membershipTable) {
                PropertiesDialog.this.propertyTable.clearSelection();
            }
        }
    }
}

