/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.LinkedList;
import java.util.List;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class DeprecatedTags
extends Test {
    private List<DeprecationCheck> checks = new LinkedList<DeprecationCheck>();

    public DeprecatedTags() {
        super(I18n.tr("Deprecated Tags", new Object[0]), I18n.tr("Checks and corrects deprecated tags.", new Object[0]));
        this.checks.add(new DeprecationCheck(2101).testAndRemove("barrier", "wire_fence").add("barrier", "fence").add("fence_type", "chain"));
        this.checks.add(new DeprecationCheck(2102).testAndRemove("barrier", "wood_fence").add("barrier", "fence").add("fence_type", "wood"));
        this.checks.add(new DeprecationCheck(2103).testAndRemove("highway", "ford").add("ford", "yes"));
        this.checks.add(new DeprecationCheck(2104).test("class").alternative("highway"));
        this.checks.add(new DeprecationCheck(2105).testAndRemove("highway", "stile").add("barrier", "stile"));
        this.checks.add(new DeprecationCheck(2106).testAndRemove("highway", "incline").add("highway", "road").add("incline", "up"));
        this.checks.add(new DeprecationCheck(2107).testAndRemove("highway", "incline_steep").add("highway", "road").add("incline", "up"));
        this.checks.add(new DeprecationCheck(2108).testAndRemove("highway", "unsurfaced").add("highway", "road").add("incline", "unpaved"));
        this.checks.add(new DeprecationCheck(2109).test("landuse", "wood").alternative("landuse", "forest").alternative("natural", "wood"));
        this.checks.add(new DeprecationCheck(2110).testAndRemove("natural", "marsh").add("natural", "wetland").add("wetland", "marsh"));
        this.checks.add(new DeprecationCheck(2111).test("highway", "byway"));
        this.checks.add(new DeprecationCheck(2112).test("power_source").alternative("generator:source"));
        this.checks.add(new DeprecationCheck(2113).test("power_rating").alternative("generator:output"));
        this.checks.add(new DeprecationCheck(2114).testAndRemove("shop", "organic").add("shop", "supermarket").add("organic", "only"));
        this.checks.add(new DeprecationCheck(2115).testAndRemove("bicycle_parking", "sheffield").add("bicycle_parking", "stands"));
    }

    public void visit(OsmPrimitive osmPrimitive) {
        for (DeprecationCheck deprecationCheck : this.checks) {
            if (!deprecationCheck.matchesPrimitive(osmPrimitive)) continue;
            this.errors.add(new DeprecationError(osmPrimitive, deprecationCheck));
        }
    }

    public void visit(Node node) {
        this.visit((OsmPrimitive)node);
    }

    public void visit(Way way) {
        this.visit((OsmPrimitive)way);
    }

    public void visit(Relation relation) {
        this.visit((OsmPrimitive)relation);
    }

    private class DeprecationError
    extends TestError {
        OsmPrimitive p;
        DeprecationCheck check;

        DeprecationError(OsmPrimitive osmPrimitive, DeprecationCheck deprecationCheck) {
            super((Test)DeprecatedTags.this, Severity.WARNING, deprecationCheck.getDescription(), deprecationCheck.code, osmPrimitive);
            this.p = osmPrimitive;
            this.check = deprecationCheck;
        }

        public boolean isFixable() {
            return !this.check.change.isEmpty();
        }

        public Command getFix() {
            return this.check.fixPrimitive(this.p);
        }
    }

    private static class DeprecationCheck {
        int code;
        List<Tag> test = new LinkedList<Tag>();
        List<Tag> change = new LinkedList<Tag>();
        List<Tag> alternatives = new LinkedList<Tag>();

        public DeprecationCheck(int n) {
            this.code = n;
        }

        DeprecationCheck test(String string, String string2) {
            this.test.add(new Tag(string, string2));
            return this;
        }

        DeprecationCheck test(String string) {
            return this.test(string, null);
        }

        DeprecationCheck add(String string, String string2) {
            this.change.add(new Tag(string, string2));
            return this;
        }

        DeprecationCheck remove(String string) {
            this.change.add(new Tag(string));
            return this;
        }

        DeprecationCheck testAndRemove(String string, String string2) {
            return this.test(string, string2).remove(string);
        }

        DeprecationCheck testAndRemove(String string) {
            return this.test(string).remove(string);
        }

        DeprecationCheck alternative(String string, String string2) {
            this.alternatives.add(new Tag(string, string2));
            return this;
        }

        DeprecationCheck alternative(String string) {
            return this.alternative(string, null);
        }

        boolean matchesPrimitive(OsmPrimitive osmPrimitive) {
            for (Tag tag : this.test) {
                String string = tag.getKey();
                String string2 = tag.getValue();
                if (string2.isEmpty() && !osmPrimitive.hasKey(string)) {
                    return false;
                }
                if (string2.isEmpty() || string2.equals(osmPrimitive.get(string))) continue;
                return false;
            }
            return true;
        }

        Command fixPrimitive(OsmPrimitive osmPrimitive) {
            LinkedList<Command> linkedList = new LinkedList<Command>();
            for (Tag tag : this.change) {
                linkedList.add(new ChangePropertyCommand(osmPrimitive, tag.getKey(), tag.getValue()));
            }
            return new SequenceCommand(I18n.tr("Deprecation fix of {0}", Utils.join(", ", this.test)), linkedList);
        }

        String getDescription() {
            if (this.alternatives.isEmpty()) {
                return I18n.tr("{0} is deprecated", Utils.join(", ", this.test));
            }
            return I18n.tr("{0} is deprecated, use {1} instead", Utils.join(", ", this.test), Utils.join(I18n.tr(" or ", new Object[0]), this.alternatives));
        }
    }
}

