/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.AbstractProjection;
import org.openstreetmap.josm.data.projection.Ellipsoid;
import org.openstreetmap.josm.data.projection.ProjectionConfigurationException;
import org.openstreetmap.josm.data.projection.Projections;
import org.openstreetmap.josm.data.projection.datum.CentricDatum;
import org.openstreetmap.josm.data.projection.datum.Datum;
import org.openstreetmap.josm.data.projection.datum.NTV2Datum;
import org.openstreetmap.josm.data.projection.datum.NTV2GridShiftFileWrapper;
import org.openstreetmap.josm.data.projection.datum.NullDatum;
import org.openstreetmap.josm.data.projection.datum.SevenParameterDatum;
import org.openstreetmap.josm.data.projection.datum.ThreeParameterDatum;
import org.openstreetmap.josm.data.projection.datum.WGS84Datum;
import org.openstreetmap.josm.data.projection.proj.Mercator;
import org.openstreetmap.josm.data.projection.proj.Proj;
import org.openstreetmap.josm.data.projection.proj.ProjParameters;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomProjection
extends AbstractProjection {
    protected String pref;
    protected Bounds bounds;

    public CustomProjection() {
        this.pref = null;
    }

    public CustomProjection(String string) {
        try {
            this.pref = string;
            this.update(string);
        }
        catch (ProjectionConfigurationException projectionConfigurationException) {
            try {
                this.update(null);
            }
            catch (ProjectionConfigurationException projectionConfigurationException2) {
                throw new RuntimeException();
            }
        }
    }

    public void update(String string) throws ProjectionConfigurationException {
        this.pref = string;
        if (string == null) {
            this.ellps = Ellipsoid.WGS84;
            this.datum = WGS84Datum.INSTANCE;
            this.proj = new Mercator();
            this.bounds = new Bounds(new LatLon(-85.05112877980659, -180.0), new LatLon(85.05112877980659, 180.0), true);
        } else {
            Map<String, String> map = this.parseParameterList(string);
            this.ellps = this.parseEllipsoid(map);
            this.datum = this.parseDatum(map, this.ellps);
            this.proj = this.parseProjection(map, this.ellps);
            String string2 = map.get(Param.x_0.key);
            if (string2 != null) {
                this.x_0 = CustomProjection.parseDouble(string2, Param.x_0.key);
            }
            if ((string2 = map.get(Param.y_0.key)) != null) {
                this.y_0 = CustomProjection.parseDouble(string2, Param.y_0.key);
            }
            if ((string2 = map.get(Param.lon_0.key)) != null) {
                this.lon_0 = CustomProjection.parseAngle(string2, Param.lon_0.key);
            }
            if ((string2 = map.get(Param.k_0.key)) != null) {
                this.k_0 = CustomProjection.parseDouble(string2, Param.k_0.key);
            }
            if ((string2 = map.get(Param.bounds.key)) != null) {
                this.bounds = CustomProjection.parseBounds(string2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, String> parseParameterList(String string) throws ProjectionConfigurationException {
        Object object;
        String string2;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String[] stringArray = string.trim().split("\\s+");
        if (string.trim().isEmpty()) {
            stringArray = new String[]{};
        }
        for (int i = 0; i < stringArray.length; ++i) {
            void object2;
            Object object3;
            string2 = stringArray[i];
            if (string2.isEmpty() || string2.charAt(0) != '+') {
                throw new ProjectionConfigurationException(I18n.tr("Parameter must begin with a ''+'' character (found ''{0}'')", string2));
            }
            object = Pattern.compile("\\+([a-zA-Z0-9_]+)(=(.*))?").matcher(string2);
            if (((Matcher)object).matches()) {
                object3 = ((Matcher)object).group(1);
                if (((String)object3).equals("k")) {
                    object3 = Param.k_0.key;
                }
                Object var8_11 = null;
                if (((Matcher)object).groupCount() >= 3) {
                    String string3 = ((Matcher)object).group(3);
                    if (((String)object3).equals(Param.proj.key) && (string3.equals("longlat") || string3.equals("latlon") || string3.equals("latlong"))) {
                        String string4 = "lonlat";
                    }
                }
                if (!Param.paramsByKey.containsKey(object3)) {
                    throw new ProjectionConfigurationException(I18n.tr("Unkown parameter: ''{0}''.", object3));
                }
                if (Param.paramsByKey.get((Object)object3).hasValue && object2 == null) {
                    throw new ProjectionConfigurationException(I18n.tr("Value expected for parameter ''{0}''.", object3));
                }
                if (!Param.paramsByKey.get((Object)object3).hasValue && object2 != null) {
                    throw new ProjectionConfigurationException(I18n.tr("No value expected for parameter ''{0}''.", object3));
                }
            } else {
                throw new ProjectionConfigurationException(I18n.tr("Unexpected parameter format (''{0}'')", string2));
            }
            hashMap.put((String)object3, (String)object2);
        }
        String string3 = (String)hashMap.get(Param.init.key);
        if (string3 != null) {
            string2 = Projections.getInit(string3);
            if (string2 == null) {
                throw new ProjectionConfigurationException(I18n.tr("Value ''{0}'' for option +init not supported.", string3));
            }
            object = null;
            try {
                object = this.parseParameterList(string2);
            }
            catch (ProjectionConfigurationException projectionConfigurationException) {
                throw new ProjectionConfigurationException(I18n.tr(string3 + ": " + projectionConfigurationException.getMessage(), new Object[0]));
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                object.put(entry.getKey(), entry.getValue());
            }
            return object;
        }
        return hashMap;
    }

    public Ellipsoid parseEllipsoid(Map<String, String> map) throws ProjectionConfigurationException {
        String string = map.get(Param.ellps.key);
        if (string != null) {
            Ellipsoid ellipsoid = Projections.getEllipsoid(string);
            if (ellipsoid == null) {
                throw new ProjectionConfigurationException(I18n.tr("Ellipsoid ''{0}'' not supported.", string));
            }
            return ellipsoid;
        }
        String string2 = map.get(Param.a.key);
        if (string2 != null) {
            double d = CustomProjection.parseDouble(string2, Param.a.key);
            if (map.get(Param.es.key) != null) {
                double d2 = CustomProjection.parseDouble(map, Param.es.key);
                return Ellipsoid.create_a_es(d, d2);
            }
            if (map.get(Param.rf.key) != null) {
                double d3 = CustomProjection.parseDouble(map, Param.rf.key);
                return Ellipsoid.create_a_rf(d, d3);
            }
            if (map.get(Param.f.key) != null) {
                double d4 = CustomProjection.parseDouble(map, Param.f.key);
                return Ellipsoid.create_a_f(d, d4);
            }
            if (map.get(Param.b.key) != null) {
                double d5 = CustomProjection.parseDouble(map, Param.b.key);
                return Ellipsoid.create_a_b(d, d5);
            }
        }
        if (map.containsKey(Param.a.key) || map.containsKey(Param.es.key) || map.containsKey(Param.rf.key) || map.containsKey(Param.f.key) || map.containsKey(Param.b.key)) {
            throw new ProjectionConfigurationException(I18n.tr("Combination of ellipsoid parameters is not supported.", new Object[0]));
        }
        if (map.containsKey(Param.no_defs.key)) {
            throw new ProjectionConfigurationException(I18n.tr("Ellipsoid required (+ellps=* or +a=*, +b=*)", new Object[0]));
        }
        return Ellipsoid.WGS84;
    }

    public Datum parseDatum(Map<String, String> map, Ellipsoid ellipsoid) throws ProjectionConfigurationException {
        String string = map.get(Param.nadgrids.key);
        if (string != null) {
            if (string.startsWith("@")) {
                string = string.substring(1);
            }
            if (string.equals("null")) {
                return new NullDatum(null, ellipsoid);
            }
            NTV2GridShiftFileWrapper nTV2GridShiftFileWrapper = Projections.getNTV2Grid(string);
            if (nTV2GridShiftFileWrapper == null) {
                throw new ProjectionConfigurationException(I18n.tr("Grid shift file ''{0}'' for option +nadgrids not supported.", string));
            }
            return new NTV2Datum(string, null, ellipsoid, nTV2GridShiftFileWrapper);
        }
        String string2 = map.get(Param.towgs84.key);
        if (string2 != null) {
            return this.parseToWGS84(string2, ellipsoid);
        }
        String string3 = map.get(Param.datum.key);
        if (string3 != null) {
            Datum datum = Projections.getDatum(string3);
            if (datum == null) {
                throw new ProjectionConfigurationException(I18n.tr("Unkown datum identifier: ''{0}''", string3));
            }
            return datum;
        }
        if (map.containsKey(Param.no_defs.key)) {
            throw new ProjectionConfigurationException(I18n.tr("Datum required (+datum=*, +towgs84=* or +nadgirds=*)", new Object[0]));
        }
        return new CentricDatum(null, null, ellipsoid);
    }

    public Datum parseToWGS84(String string, Ellipsoid ellipsoid) throws ProjectionConfigurationException {
        int n;
        int n2;
        String[] stringArray = string.split(",");
        if (stringArray.length != 3 && stringArray.length != 7) {
            throw new ProjectionConfigurationException(I18n.tr("Unexpected number of arguments for parameter ''towgs84'' (must be 3 or 7)", new Object[0]));
        }
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            try {
                arrayList.add(Double.parseDouble(stringArray[n2]));
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                throw new ProjectionConfigurationException(I18n.tr("Unable to parse value of parameter ''towgs84'' (''{0}'')", stringArray[n2]));
            }
        }
        n2 = 1;
        for (n = 0; n < arrayList.size(); ++n) {
            if ((Double)arrayList.get(n) == 0.0) continue;
            n2 = 0;
            break;
        }
        if (n2 != 0) {
            return new CentricDatum(null, null, ellipsoid);
        }
        n = 1;
        for (int i = 3; i < arrayList.size(); ++i) {
            if ((Double)arrayList.get(i) == 0.0) continue;
            n = 0;
            break;
        }
        if (n != 0) {
            return new ThreeParameterDatum(null, null, ellipsoid, (Double)arrayList.get(0), (Double)arrayList.get(1), (Double)arrayList.get(2));
        }
        return new SevenParameterDatum(null, null, ellipsoid, (Double)arrayList.get(0), (Double)arrayList.get(1), (Double)arrayList.get(2), (Double)arrayList.get(3), (Double)arrayList.get(4), (Double)arrayList.get(5), (Double)arrayList.get(6));
    }

    public Proj parseProjection(Map<String, String> map, Ellipsoid ellipsoid) throws ProjectionConfigurationException {
        String string = map.get(Param.proj.key);
        if (string == null) {
            throw new ProjectionConfigurationException(I18n.tr("Projection required (+proj=*)", new Object[0]));
        }
        Proj proj = Projections.getBaseProjection(string);
        if (proj == null) {
            throw new ProjectionConfigurationException(I18n.tr("Unkown projection identifier: ''{0}''", string));
        }
        ProjParameters projParameters = new ProjParameters();
        projParameters.ellps = ellipsoid;
        String string2 = map.get(Param.lat_0.key);
        if (string2 != null) {
            projParameters.lat_0 = CustomProjection.parseAngle(string2, Param.lat_0.key);
        }
        if ((string2 = map.get(Param.lat_1.key)) != null) {
            projParameters.lat_1 = CustomProjection.parseAngle(string2, Param.lat_1.key);
        }
        if ((string2 = map.get(Param.lat_2.key)) != null) {
            projParameters.lat_2 = CustomProjection.parseAngle(string2, Param.lat_2.key);
        }
        proj.initialize(projParameters);
        return proj;
    }

    public static Bounds parseBounds(String string) throws ProjectionConfigurationException {
        String[] stringArray = string.split(",");
        if (stringArray.length != 4) {
            throw new ProjectionConfigurationException(I18n.tr("Unexpected number of arguments for parameter ''+bounds'' (must be 4)", new Object[0]));
        }
        return new Bounds(CustomProjection.parseAngle(stringArray[1], "minlat (+bounds)"), CustomProjection.parseAngle(stringArray[0], "minlon (+bounds)"), CustomProjection.parseAngle(stringArray[3], "maxlat (+bounds)"), CustomProjection.parseAngle(stringArray[2], "maxlon (+bounds)"), false);
    }

    public static double parseDouble(Map<String, String> map, String string) throws ProjectionConfigurationException {
        String string2 = map.get(string);
        if (string2 == null && map.containsKey(string)) {
            throw new ProjectionConfigurationException(I18n.tr("Expected number argument for parameter ''{0}''", string));
        }
        return CustomProjection.parseDouble(string2, string);
    }

    public static double parseDouble(String string, String string2) throws ProjectionConfigurationException {
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ProjectionConfigurationException(I18n.tr("Unable to parse value ''{1}'' of parameter ''{0}'' as number.", string2, string));
        }
    }

    public static double parseAngle(String string, String string2) throws ProjectionConfigurationException {
        String string3 = string;
        double d = 0.0;
        boolean bl = false;
        Matcher matcher = Pattern.compile("^-").matcher(string3);
        if (matcher.find()) {
            bl = true;
            string3 = string3.substring(matcher.end());
        }
        boolean bl2 = false;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        matcher = Pattern.compile("^(\\d+(\\.\\d*)?)d").matcher(string3);
        if (matcher.find()) {
            string3 = string3.substring(matcher.end());
            d2 = Double.parseDouble(matcher.group(1));
            bl2 = true;
        }
        if ((matcher = Pattern.compile("^(\\d+(\\.\\d*)?)'").matcher(string3)).find()) {
            string3 = string3.substring(matcher.end());
            d3 = Double.parseDouble(matcher.group(1));
            bl2 = true;
        }
        if ((matcher = Pattern.compile("^(\\d+(\\.\\d*)?)\"").matcher(string3)).find()) {
            string3 = string3.substring(matcher.end());
            d4 = Double.parseDouble(matcher.group(1));
            bl2 = true;
        }
        if (bl2) {
            d = d2 + d3 / 60.0 + d4 / 3600.0;
        } else {
            matcher = Pattern.compile("^(\\d+(\\.\\d*)?)").matcher(string3);
            if (matcher.find()) {
                string3 = string3.substring(matcher.end());
                d += Double.parseDouble(matcher.group(1));
            }
        }
        matcher = Pattern.compile("^(N|E)", 2).matcher(string3);
        if (matcher.find()) {
            string3 = string3.substring(matcher.end());
        } else {
            matcher = Pattern.compile("^(S|W)", 2).matcher(string3);
            if (matcher.find()) {
                string3 = string3.substring(matcher.end());
                boolean bl3 = bl = !bl;
            }
        }
        if (bl) {
            d = -d;
        }
        if (!string3.isEmpty()) {
            throw new ProjectionConfigurationException(I18n.tr("Unable to parse value ''{1}'' of parameter ''{0}'' as coordinate value.", string2, string));
        }
        return d;
    }

    @Override
    public Integer getEpsgCode() {
        return null;
    }

    @Override
    public String toCode() {
        return "proj:" + (this.pref == null ? "ERROR" : this.pref);
    }

    @Override
    public String getCacheDirectoryName() {
        return "proj-" + Utils.md5Hex(this.pref == null ? "" : this.pref).substring(0, 4);
    }

    @Override
    public Bounds getWorldBoundsLatLon() {
        if (this.bounds != null) {
            return this.bounds;
        }
        return new Bounds(new LatLon(-90.0, -180.0), new LatLon(90.0, 180.0));
    }

    @Override
    public String toString() {
        return I18n.tr("Custom Projection", new Object[0]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum Param {
        x_0("x_0", true),
        y_0("y_0", true),
        lon_0("lon_0", true),
        k_0("k_0", true),
        ellps("ellps", true),
        a("a", true),
        es("es", true),
        rf("rf", true),
        f("f", true),
        b("b", true),
        datum("datum", true),
        towgs84("towgs84", true),
        nadgrids("nadgrids", true),
        proj("proj", true),
        lat_0("lat_0", true),
        lat_1("lat_1", true),
        lat_2("lat_2", true),
        wktext("wktext", false),
        units("units", true),
        no_defs("no_defs", false),
        init("init", true),
        bounds("bounds", true);

        public String key;
        public boolean hasValue;
        public static final Map<String, Param> paramsByKey;

        private Param(String string2, boolean bl) {
            this.key = string2;
            this.hasValue = bl;
        }

        static {
            paramsByKey = new HashMap<String, Param>();
            for (Param param : Param.values()) {
                paramsByKey.put(param.key, param);
            }
        }
    }
}

