/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CopyAction
extends JosmAction {
    public CopyAction() {
        super(I18n.tr("Copy", new Object[0]), "copy", I18n.tr("Copy selected objects to paste buffer.", new Object[0]), Shortcut.registerShortcut("system:copy", I18n.tr("Edit: {0}", I18n.tr("Copy", new Object[0])), 67, 5006), true);
        this.putValue("help", HelpUtil.ht("/Action/Copy"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.isEmptySelection()) {
            return;
        }
        Collection<OsmPrimitive> collection = CopyAction.getCurrentDataSet().getSelected();
        CopyAction.copy(CopyAction.getEditLayer(), collection);
    }

    public static void copy(OsmDataLayer osmDataLayer, Collection<OsmPrimitive> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        for (OsmPrimitive osmPrimitive : collection) {
            stringBuilder.append(osmPrimitive.getId()).append(",");
        }
        String string = stringBuilder.substring(0, stringBuilder.length() - 1);
        Utils.copyToClipboard(string);
        Main.pasteBuffer.makeCopy(collection);
        Main.pasteSource = osmDataLayer;
    }

    @Override
    protected void updateEnabledState() {
        if (CopyAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(CopyAction.getCurrentDataSet().getSelected());
        }
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> collection) {
        this.setEnabled(collection != null && !collection.isEmpty());
    }

    private boolean isEmptySelection() {
        Collection<OsmPrimitive> collection = CopyAction.getCurrentDataSet().getSelected();
        if (collection.isEmpty()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Please select something to copy.", new Object[0]), I18n.tr("Information", new Object[0]), 1);
            return true;
        }
        return false;
    }
}

