/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import org.openstreetmap.gui.jmapviewer.interfaces.TileJob;

public class JobDispatcher {
    private static final JobDispatcher instance = new JobDispatcher();
    protected BlockingDeque<TileJob> jobQueue = new LinkedBlockingDeque<TileJob>();
    public static int WORKER_THREAD_MAX_COUNT = 8;
    public static int WORKER_THREAD_TIMEOUT = 30;
    protected boolean modeLIFO = false;
    protected int workerThreadCount = 0;
    protected int workerThreadIdleCount = 0;
    protected int workerThreadId = 0;

    public static JobDispatcher getInstance() {
        return instance;
    }

    private JobDispatcher() {
        this.addWorkerThread().firstThread = true;
    }

    public void cancelOutstandingJobs() {
        this.jobQueue.clear();
    }

    public static void setMaxWorkers(int n) {
        WORKER_THREAD_MAX_COUNT = n;
    }

    public void setLIFO(boolean bl) {
        this.modeLIFO = bl;
    }

    public void addJob(TileJob tileJob) {
        try {
            if (tileJob.getTile() != null) {
                for (TileJob tileJob2 : this.jobQueue) {
                    if (tileJob2.getTile() != tileJob.getTile()) continue;
                    return;
                }
            }
            this.jobQueue.put(tileJob);
            if (this.workerThreadIdleCount == 0 && this.workerThreadCount < WORKER_THREAD_MAX_COUNT) {
                this.addWorkerThread();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JobThread addWorkerThread() {
        JobThread jobThread = new JobThread(++this.workerThreadId);
        JobDispatcher jobDispatcher = this;
        synchronized (jobDispatcher) {
            ++this.workerThreadCount;
        }
        jobThread.start();
        return jobThread;
    }

    public class JobThread
    extends Thread {
        Runnable job;
        boolean firstThread;

        public JobThread(int n) {
            super("OSMJobThread " + n);
            this.firstThread = false;
            this.setDaemon(true);
            this.job = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.executeJobs();
            JobDispatcher jobDispatcher = instance;
            synchronized (jobDispatcher) {
                --JobDispatcher.this.workerThreadCount;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void executeJobs() {
            while (!this.isInterrupted()) {
                JobDispatcher jobDispatcher;
                try {
                    jobDispatcher = instance;
                    synchronized (jobDispatcher) {
                        ++JobDispatcher.this.workerThreadIdleCount;
                    }
                    this.job = JobDispatcher.this.modeLIFO ? (this.firstThread ? (Runnable)JobDispatcher.this.jobQueue.takeLast() : (Runnable)JobDispatcher.this.jobQueue.pollLast(WORKER_THREAD_TIMEOUT, TimeUnit.SECONDS)) : (this.firstThread ? (Runnable)JobDispatcher.this.jobQueue.take() : (Runnable)JobDispatcher.this.jobQueue.poll(WORKER_THREAD_TIMEOUT, TimeUnit.SECONDS));
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
                finally {
                    jobDispatcher = instance;
                    synchronized (jobDispatcher) {
                        --JobDispatcher.this.workerThreadIdleCount;
                    }
                }
                if (this.job == null) {
                    return;
                }
                try {
                    this.job.run();
                    this.job = null;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }
}

