/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.server;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.preferences.server.ApiUrlTestTask;
import org.openstreetmap.josm.gui.widgets.AbstractTextComponentValidator;
import org.openstreetmap.josm.gui.widgets.SelectAllOnFocusGainedDecorator;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class OsmApiUrlInputPanel
extends JPanel {
    public static final String API_URL_PROP = OsmApiUrlInputPanel.class.getName() + ".apiUrl";
    private JLabel lblValid;
    private JLabel lblApiUrl;
    private JTextField tfOsmServerUrl;
    private ApiUrlValidator valOsmServerUrl;
    private SideButton btnTest;
    private JCheckBox cbUseDefaultServerUrl;

    protected JPanel buildDefultServerUrlPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        gridBagConstraints.gridwidth = 1;
        this.cbUseDefaultServerUrl = new JCheckBox();
        jPanel.add((Component)this.cbUseDefaultServerUrl, gridBagConstraints);
        this.cbUseDefaultServerUrl.addItemListener(new UseDefaultServerUrlChangeHandler());
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        JLabel jLabel = new JLabel(I18n.tr("<html>Use the default OSM server URL (<strong>{0}</strong>)</html>", "http://api.openstreetmap.org/api"));
        jLabel.setFont(jLabel.getFont().deriveFont(0));
        jPanel.add((Component)jLabel, gridBagConstraints);
        return jPanel;
    }

    protected void build() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridwidth = 4;
        this.add((Component)this.buildDefultServerUrlPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.lblApiUrl = new JLabel(I18n.tr("OSM Server URL:", new Object[0]));
        this.add((Component)this.lblApiUrl, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        this.tfOsmServerUrl = new JTextField();
        this.add((Component)this.tfOsmServerUrl, gridBagConstraints);
        SelectAllOnFocusGainedDecorator.decorate(this.tfOsmServerUrl);
        this.valOsmServerUrl = new ApiUrlValidator(this.tfOsmServerUrl);
        this.valOsmServerUrl.validate();
        ApiUrlPropagator apiUrlPropagator = new ApiUrlPropagator();
        this.tfOsmServerUrl.addActionListener(apiUrlPropagator);
        this.tfOsmServerUrl.addFocusListener(apiUrlPropagator);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.0;
        this.lblValid = new JLabel();
        this.add((Component)this.lblValid, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.weightx = 0.0;
        ValidateApiUrlAction validateApiUrlAction = new ValidateApiUrlAction();
        this.tfOsmServerUrl.getDocument().addDocumentListener(validateApiUrlAction);
        this.btnTest = new SideButton(validateApiUrlAction);
        this.add((Component)this.btnTest, gridBagConstraints);
    }

    public OsmApiUrlInputPanel() {
        this.build();
        HelpUtil.setHelpContext(this, HelpUtil.ht("/Preferences/Connection#ApiUrl"));
    }

    public void initFromPreferences() {
        String string = Main.pref.get("osm-server.url", null);
        if (string == null) {
            this.cbUseDefaultServerUrl.setSelected(true);
            this.firePropertyChange(API_URL_PROP, null, "http://api.openstreetmap.org/api");
        } else if (string.trim().equals("http://api.openstreetmap.org/api")) {
            this.cbUseDefaultServerUrl.setSelected(true);
            this.firePropertyChange(API_URL_PROP, null, "http://api.openstreetmap.org/api");
        } else {
            this.cbUseDefaultServerUrl.setSelected(false);
            this.tfOsmServerUrl.setText(string);
            this.firePropertyChange(API_URL_PROP, null, string);
        }
    }

    public void saveToPreferences() {
        String string = Main.pref.get("osm-server.url", null);
        if (this.cbUseDefaultServerUrl.isSelected()) {
            Main.pref.put("osm-server.url", null);
        } else if (this.tfOsmServerUrl.getText().trim().equals("http://api.openstreetmap.org/api")) {
            Main.pref.put("osm-server.url", null);
        } else {
            Main.pref.put("osm-server.url", this.tfOsmServerUrl.getText().trim());
        }
        String string2 = Main.pref.get("osm-server.url", null);
        if (string == null && string2 != null || string != null && !string.equals(string2)) {
            try {
                OsmApi.getOsmApi().initialize(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setApiUrlInputEnabled(boolean bl) {
        this.lblApiUrl.setEnabled(bl);
        this.tfOsmServerUrl.setEnabled(bl);
        this.lblValid.setEnabled(bl);
        this.btnTest.setEnabled(bl);
    }

    class ApiUrlPropagator
    extends FocusAdapter
    implements ActionListener {
        ApiUrlPropagator() {
        }

        public void propagate() {
            OsmApiUrlInputPanel.this.firePropertyChange(API_URL_PROP, null, OsmApiUrlInputPanel.this.tfOsmServerUrl.getText());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.propagate();
        }

        public void focusLost(FocusEvent focusEvent) {
            this.propagate();
        }
    }

    class UseDefaultServerUrlChangeHandler
    implements ItemListener {
        UseDefaultServerUrlChangeHandler() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            switch (itemEvent.getStateChange()) {
                case 1: {
                    OsmApiUrlInputPanel.this.setApiUrlInputEnabled(false);
                    OsmApiUrlInputPanel.this.firePropertyChange(API_URL_PROP, null, "http://api.openstreetmap.org/api");
                    break;
                }
                case 2: {
                    OsmApiUrlInputPanel.this.setApiUrlInputEnabled(true);
                    OsmApiUrlInputPanel.this.valOsmServerUrl.validate();
                    OsmApiUrlInputPanel.this.tfOsmServerUrl.requestFocusInWindow();
                    OsmApiUrlInputPanel.this.firePropertyChange(API_URL_PROP, null, OsmApiUrlInputPanel.this.tfOsmServerUrl.getText());
                }
            }
        }
    }

    private static class ApiUrlValidator
    extends AbstractTextComponentValidator {
        public ApiUrlValidator(JTextComponent jTextComponent) throws IllegalArgumentException {
            super(jTextComponent);
        }

        public boolean isValid() {
            if (this.getComponent().getText().trim().equals("")) {
                return false;
            }
            try {
                new URL(this.getComponent().getText().trim());
                return true;
            }
            catch (MalformedURLException malformedURLException) {
                return false;
            }
        }

        public void validate() {
            if (this.getComponent().getText().trim().equals("")) {
                this.feedbackInvalid(I18n.tr("OSM API URL must not be empty. Please enter the OSM API URL.", new Object[0]));
                return;
            }
            if (!this.isValid()) {
                this.feedbackInvalid(I18n.tr("The current value is not a valid URL", new Object[0]));
            } else {
                this.feedbackValid(I18n.tr("Please enter the OSM API URL.", new Object[0]));
            }
        }
    }

    class ValidateApiUrlAction
    extends AbstractAction
    implements DocumentListener {
        private String lastTestedUrl = null;

        public ValidateApiUrlAction() {
            this.putValue("Name", I18n.tr("Validate", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Test the API URL", new Object[0]));
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            final String string = OsmApiUrlInputPanel.this.tfOsmServerUrl.getText().trim();
            final ApiUrlTestTask apiUrlTestTask = new ApiUrlTestTask(OsmApiUrlInputPanel.this, string);
            Main.worker.submit(apiUrlTestTask);
            Runnable runnable = new Runnable(){

                public void run() {
                    if (apiUrlTestTask.isCanceled()) {
                        return;
                    }
                    Runnable runnable = new Runnable(){

                        public void run() {
                            if (apiUrlTestTask.isSuccess()) {
                                OsmApiUrlInputPanel.this.lblValid.setIcon(ImageProvider.get("dialogs/changeset", "valid"));
                                OsmApiUrlInputPanel.this.lblValid.setToolTipText(I18n.tr("The API URL is valid.", new Object[0]));
                                ValidateApiUrlAction.this.lastTestedUrl = string;
                                ValidateApiUrlAction.this.updateEnabledState();
                            } else {
                                OsmApiUrlInputPanel.this.lblValid.setIcon(ImageProvider.get("warning-small"));
                                OsmApiUrlInputPanel.this.lblValid.setToolTipText(I18n.tr("Validation failed. The API URL seems to be invalid.", new Object[0]));
                            }
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                }
            };
            Main.worker.submit(runnable);
        }

        protected void updateEnabledState() {
            boolean bl;
            boolean bl2 = bl = !OsmApiUrlInputPanel.this.tfOsmServerUrl.getText().trim().equals("") && !OsmApiUrlInputPanel.this.tfOsmServerUrl.getText().trim().equals(this.lastTestedUrl);
            if (bl) {
                OsmApiUrlInputPanel.this.lblValid.setIcon(null);
            }
            this.setEnabled(bl);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.updateEnabledState();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.updateEnabledState();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.updateEnabledState();
        }
    }
}

