/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.geoimage;

import java.awt.Image;
import java.io.File;
import java.util.Date;
import org.openstreetmap.josm.data.coor.CachedLatLon;
import org.openstreetmap.josm.data.coor.LatLon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ImageEntry
implements Comparable<ImageEntry>,
Cloneable {
    private File file;
    private Integer exifOrientation;
    private LatLon exifCoor;
    private Double exifImgDir;
    private Date exifTime;
    Image thumbnail;
    private CachedLatLon pos;
    private Double speed;
    private Double elevation;
    private Date gpsTime;
    ImageEntry tmp;

    public CachedLatLon getPos() {
        if (this.tmp != null) {
            return this.tmp.pos;
        }
        return this.pos;
    }

    public Double getSpeed() {
        if (this.tmp != null) {
            return this.tmp.speed;
        }
        return this.speed;
    }

    public Double getElevation() {
        if (this.tmp != null) {
            return this.tmp.elevation;
        }
        return this.elevation;
    }

    public Date getGpsTime() {
        if (this.tmp != null) {
            return this.tmp.gpsTime;
        }
        return this.gpsTime;
    }

    public File getFile() {
        return this.file;
    }

    public Integer getExifOrientation() {
        return this.exifOrientation;
    }

    public Date getExifTime() {
        return this.exifTime;
    }

    LatLon getExifCoor() {
        return this.exifCoor;
    }

    public Double getExifImgDir() {
        return this.exifImgDir;
    }

    public void setPos(CachedLatLon cachedLatLon) {
        this.pos = cachedLatLon;
    }

    public void setPos(LatLon latLon) {
        this.pos = new CachedLatLon(latLon);
    }

    public void setSpeed(Double d) {
        this.speed = d;
    }

    public void setElevation(Double d) {
        this.elevation = d;
    }

    void setFile(File file) {
        this.file = file;
    }

    void setExifOrientation(Integer n) {
        this.exifOrientation = n;
    }

    void setExifTime(Date date) {
        this.exifTime = date;
    }

    void setGpsTime(Date date) {
        this.gpsTime = date;
    }

    void setExifCoor(LatLon latLon) {
        this.exifCoor = latLon;
    }

    void setExifImgDir(double d) {
        this.exifImgDir = d;
    }

    public ImageEntry clone() {
        Object object;
        try {
            object = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException();
        }
        return (ImageEntry)object;
    }

    @Override
    public int compareTo(ImageEntry imageEntry) {
        if (this.exifTime != null && imageEntry.exifTime != null) {
            return this.exifTime.compareTo(imageEntry.exifTime);
        }
        if (this.exifTime == null && imageEntry.exifTime == null) {
            return 0;
        }
        if (this.exifTime == null) {
            return -1;
        }
        return 1;
    }

    public void cleanTmp() {
        this.tmp = this.clone();
        this.tmp.setPos(null);
        this.tmp.tmp = null;
    }

    public void applyTmp() {
        if (this.tmp != null) {
            this.pos = this.tmp.pos;
            this.speed = this.tmp.speed;
            this.elevation = this.tmp.elevation;
            this.gpsTime = this.tmp.gpsTime;
            this.tmp = null;
        }
    }

    public boolean isTagged() {
        return this.pos != null;
    }

    public String toString() {
        String string = this.file.getName() + ": " + "pos = " + this.pos + " | " + "exifCoor = " + this.exifCoor + " | " + (this.tmp == null ? " tmp==null" : " [tmp] pos = " + this.tmp.pos + "");
        return string;
    }
}

