/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.imagery;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import javax.imageio.ImageIO;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.gui.layer.WMSLayer;
import org.openstreetmap.josm.tools.I18n;

public class GeorefImage
implements Serializable {
    private static final long serialVersionUID = 1L;
    private WMSLayer layer;
    private State state;
    private BufferedImage image;
    private SoftReference<BufferedImage> reImg;
    private int xIndex;
    private int yIndex;
    private static final Color transparentColor = new Color(0, 0, 0, 0);
    private Color fadeColor = transparentColor;

    public EastNorth getMin() {
        return this.layer.getEastNorth(this.xIndex, this.yIndex);
    }

    public EastNorth getMax() {
        return this.layer.getEastNorth(this.xIndex + 1, this.yIndex + 1);
    }

    public GeorefImage(WMSLayer wMSLayer) {
        this.layer = wMSLayer;
    }

    public void changePosition(int n, int n2) {
        if (!this.equalPosition(n, n2)) {
            this.xIndex = n;
            this.yIndex = n2;
            this.image = null;
            this.flushedResizedCachedInstance();
        }
    }

    public boolean equalPosition(int n, int n2) {
        return this.xIndex == n && this.yIndex == n2;
    }

    public void changeImage(State state, BufferedImage bufferedImage) {
        this.flushedResizedCachedInstance();
        this.image = bufferedImage;
        this.state = state;
        switch (state) {
            case FAILED: {
                BufferedImage bufferedImage2 = this.createImage();
                this.layer.drawErrorTile(bufferedImage2);
                this.image = bufferedImage2;
                break;
            }
            case NOT_IN_CACHE: {
                BufferedImage bufferedImage3 = this.createImage();
                Graphics graphics = bufferedImage3.getGraphics();
                graphics.setColor(Color.GRAY);
                graphics.fillRect(0, 0, bufferedImage3.getWidth(), bufferedImage3.getHeight());
                Font font = graphics.getFont();
                Font font2 = font.deriveFont(0).deriveFont(36.0f);
                graphics.setFont(font2);
                graphics.setColor(Color.BLACK);
                String string = I18n.tr("Not in cache", new Object[0]);
                graphics.drawString(string, (bufferedImage3.getWidth() - graphics.getFontMetrics().stringWidth(string)) / 2, bufferedImage3.getHeight() / 2);
                graphics.setFont(font);
                this.image = bufferedImage3;
                break;
            }
            default: {
                if (this.image == null) break;
                this.image = this.layer.sharpenImage(this.image);
            }
        }
    }

    private BufferedImage createImage() {
        return new BufferedImage(this.layer.getImageSize(), this.layer.getImageSize(), 1);
    }

    public boolean paint(Graphics graphics, NavigatableComponent navigatableComponent, int n, int n2, int n3, int n4) {
        BufferedImage bufferedImage;
        if (this.image == null) {
            return false;
        }
        if (this.xIndex != n || this.yIndex != n2) {
            return false;
        }
        int n5 = this.layer.getImageX(n);
        int n6 = this.layer.getImageY(n2);
        int n7 = this.layer.getImageWidth(n);
        int n8 = this.layer.getImageHeight(n2);
        int n9 = n5 - n3;
        int n10 = navigatableComponent.getHeight() - (n6 - n4) - n8;
        if (n7 == 0 || n8 == 0) {
            return false;
        }
        Color color = ImageryLayer.PROP_FADE_AMOUNT.get() == 0 ? transparentColor : ImageryLayer.getFadeColorWithAlpha();
        BufferedImage bufferedImage2 = bufferedImage = this.reImg == null ? null : this.reImg.get();
        if (bufferedImage != null && bufferedImage.getWidth() == n7 && bufferedImage.getHeight() == n8 && this.fadeColor.equals(color)) {
            graphics.drawImage(bufferedImage, n9, n10, null);
            return true;
        }
        this.fadeColor = color;
        boolean bl = WMSLayer.PROP_ALPHA_CHANNEL.get() != false && this.getImage().getTransparency() != 1;
        try {
            int n11;
            if (bufferedImage != null) {
                bufferedImage.flush();
            }
            long l = Runtime.getRuntime().maxMemory() - Runtime.getRuntime().totalMemory();
            int n12 = n11 = bl ? 4 : 3;
            if (n7 > 2000 || n8 > 2000 || (long)(n7 * n8 * n11) > l) {
                this.fallbackDraw(graphics, this.getImage(), n9, n10, n7, n8, bl);
            } else {
                bufferedImage = new BufferedImage(n7, n8, bl ? 2 : 5);
                bufferedImage.getGraphics().drawImage(this.getImage(), 0, 0, n7, n8, 0, 0, this.getImage().getWidth(null), this.getImage().getHeight(null), null);
                if (!bl) {
                    this.drawFadeRect(bufferedImage.getGraphics(), 0, 0, n7, n8);
                }
                bufferedImage.getGraphics().dispose();
                graphics.drawImage(bufferedImage, n9, n10, null);
                this.reImg = new SoftReference<BufferedImage>(bufferedImage);
            }
        }
        catch (Exception exception) {
            this.fallbackDraw(graphics, this.getImage(), n9, n10, n7, n8, bl);
        }
        return true;
    }

    private void fallbackDraw(Graphics graphics, Image image, int n, int n2, int n3, int n4, boolean bl) {
        this.flushedResizedCachedInstance();
        graphics.drawImage(image, n, n2, n + n3, n2 + n4, 0, 0, image.getWidth(null), image.getHeight(null), null);
        if (!bl) {
            this.drawFadeRect(graphics, n, n2, n3, n4);
        }
    }

    private void drawFadeRect(Graphics graphics, int n, int n2, int n3, int n4) {
        if (this.fadeColor != transparentColor) {
            graphics.setColor(this.fadeColor);
            graphics.fillRect(n, n2, n3, n4);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.state = (State)((Object)objectInputStream.readObject());
        boolean bl = objectInputStream.readBoolean();
        if (bl) {
            this.image = ImageIO.read(ImageIO.createImageInputStream(objectInputStream));
        } else {
            objectInputStream.readObject();
            this.image = null;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject((Object)this.state);
        if (this.getImage() == null) {
            objectOutputStream.writeBoolean(false);
            objectOutputStream.writeObject(null);
        } else {
            objectOutputStream.writeBoolean(true);
            ImageIO.write((RenderedImage)this.getImage(), "png", ImageIO.createImageOutputStream(objectOutputStream));
        }
    }

    public void flushedResizedCachedInstance() {
        BufferedImage bufferedImage;
        if (this.reImg != null && (bufferedImage = this.reImg.get()) != null) {
            bufferedImage.flush();
        }
        this.reImg = null;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public State getState() {
        return this.state;
    }

    public int getXIndex() {
        return this.xIndex;
    }

    public int getYIndex() {
        return this.yIndex;
    }

    public void setLayer(WMSLayer wMSLayer) {
        this.layer = wMSLayer;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        IMAGE,
        NOT_IN_CACHE,
        FAILED,
        PARTLY_IN_CACHE;

    }
}

