/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins;

import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedList;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.plugins.PluginDownloadException;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginDownloadTask
extends PleaseWaitRunnable {
    private final Collection<PluginInformation> toUpdate = new LinkedList<PluginInformation>();
    private final Collection<PluginInformation> failed = new LinkedList<PluginInformation>();
    private final Collection<PluginInformation> downloaded = new LinkedList<PluginInformation>();
    private Exception lastException;
    private boolean canceled;
    private HttpURLConnection downloadConnection;

    public PluginDownloadTask(Component component, Collection<PluginInformation> collection, String string) throws IllegalArgumentException {
        super(component, string == null ? "" : string, false);
        CheckParameterUtil.ensureParameterNotNull(collection, "toUpdate");
        this.toUpdate.addAll(collection);
    }

    public PluginDownloadTask(ProgressMonitor progressMonitor, Collection<PluginInformation> collection, String string) {
        super(string, progressMonitor == null ? NullProgressMonitor.INSTANCE : progressMonitor, false);
        CheckParameterUtil.ensureParameterNotNull(collection, "toUpdate");
        this.toUpdate.addAll(collection);
    }

    public void setPluginsToDownload(Collection<PluginInformation> collection) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(collection, "toUpdate");
        this.toUpdate.clear();
        this.toUpdate.addAll(collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void cancel() {
        this.canceled = true;
        PluginDownloadTask pluginDownloadTask = this;
        synchronized (pluginDownloadTask) {
            if (this.downloadConnection != null) {
                this.downloadConnection.disconnect();
            }
        }
    }

    @Override
    protected void finish() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void download(PluginInformation pluginInformation, File file) throws PluginDownloadException {
        Object object;
        Object object2;
        if (pluginInformation.mainversion > Version.getInstance().getVersion()) {
            object2 = new ExtendedDialog(Main.parent, I18n.tr("Skip download", new Object[0]), new String[]{I18n.tr("Download Plugin", new Object[0]), I18n.tr("Skip Download", new Object[0])});
            ((ExtendedDialog)object2).setContent(I18n.tr("JOSM version {0} required for plugin {1}.", pluginInformation.mainversion, pluginInformation.name));
            ((ExtendedDialog)object2).setButtonIcons(new String[]{"download.png", "cancel.png"});
            ((ExtendedDialog)object2).showDialog();
            int n = ((ExtendedDialog)object2).getValue();
            if (n != 1) {
                throw new PluginDownloadException(I18n.tr("Download skipped", new Object[0]));
            }
        }
        object2 = null;
        InputStream inputStream = null;
        try {
            if (pluginInformation.downloadlink == null) {
                String string = I18n.tr("Warning: Cannot download plugin ''{0}''. Its download link is not known. Skipping download.", pluginInformation.name);
                System.err.println(string);
                throw new PluginDownloadException(string);
            }
            object = new URL(pluginInformation.downloadlink);
            Object object3 = this;
            synchronized (object3) {
                this.downloadConnection = (HttpURLConnection)((URL)object).openConnection();
                this.downloadConnection.setRequestProperty("Cache-Control", "no-cache");
                this.downloadConnection.setRequestProperty("User-Agent", Version.getInstance().getAgentString());
                this.downloadConnection.setRequestProperty("Host", ((URL)object).getHost());
                this.downloadConnection.connect();
            }
            inputStream = this.downloadConnection.getInputStream();
            object2 = new FileOutputStream(file);
            object3 = new byte[8192];
            int n = inputStream.read((byte[])object3);
            while (n != -1) {
                ((OutputStream)object2).write((byte[])object3, 0, n);
                n = inputStream.read((byte[])object3);
            }
            ((OutputStream)object2).close();
            inputStream.close();
            Utils.close(inputStream);
            object = this;
        }
        catch (MalformedURLException malformedURLException) {
            String string = I18n.tr("Warning: Cannot download plugin ''{0}''. Its download link ''{1}'' is not a valid URL. Skipping download.", pluginInformation.name, pluginInformation.downloadlink);
            System.err.println(string);
            throw new PluginDownloadException(string);
            catch (IOException iOException) {
                if (!this.canceled) throw new PluginDownloadException(iOException);
                return;
            }
        }
        synchronized (object) {
            this.downloadConnection = null;
        }
        Utils.close((OutputStream)object2);
        return;
        finally {
            Utils.close(inputStream);
            PluginDownloadTask pluginDownloadTask = this;
            synchronized (pluginDownloadTask) {
                this.downloadConnection = null;
            }
            Utils.close(object2);
        }
    }

    @Override
    protected void realRun() throws SAXException, IOException {
        File file = Main.pref.getPluginsDirectory();
        if (!file.exists() && !file.mkdirs()) {
            this.lastException = new PluginDownloadException(I18n.tr("Failed to create plugin directory ''{0}''", file.toString()));
            this.failed.addAll(this.toUpdate);
            return;
        }
        this.getProgressMonitor().setTicksCount(this.toUpdate.size());
        for (PluginInformation pluginInformation : this.toUpdate) {
            if (this.canceled) {
                return;
            }
            this.progressMonitor.subTask(I18n.tr("Downloading Plugin {0}...", pluginInformation.name));
            this.progressMonitor.worked(1);
            File file2 = new File(file, pluginInformation.name + ".jar.new");
            try {
                this.download(pluginInformation, file2);
            }
            catch (PluginDownloadException pluginDownloadException) {
                pluginDownloadException.printStackTrace();
                this.failed.add(pluginInformation);
                continue;
            }
            this.downloaded.add(pluginInformation);
        }
        PluginHandler.installDownloadedPlugins(false);
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public Collection<PluginInformation> getFailedPlugins() {
        return this.failed;
    }

    public Collection<PluginInformation> getDownloadedPlugins() {
        return this.downloaded;
    }
}

