/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.xml;

import java.awt.Color;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.Range;
import org.openstreetmap.josm.gui.mappaint.xml.AreaPrototype;
import org.openstreetmap.josm.gui.mappaint.xml.IconPrototype;
import org.openstreetmap.josm.gui.mappaint.xml.LinePrototype;
import org.openstreetmap.josm.gui.mappaint.xml.LinemodPrototype;
import org.openstreetmap.josm.gui.mappaint.xml.XmlCondition;
import org.openstreetmap.josm.gui.mappaint.xml.XmlStyleSource;
import org.openstreetmap.josm.tools.ColorHelper;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class XmlStyleSourceHandler
extends DefaultHandler {
    private boolean inDoc;
    private boolean inRule;
    private boolean inCondition;
    private boolean inLine;
    private boolean inLineMod;
    private boolean inIcon;
    private boolean inArea;
    private boolean inScaleMax;
    private boolean inScaleMin;
    private boolean hadLine;
    private boolean hadLineMod;
    private boolean hadIcon;
    private boolean hadArea;
    private RuleElem rule = new RuleElem();
    XmlStyleSource style;

    public XmlStyleSourceHandler(XmlStyleSource xmlStyleSource) {
        this.style = xmlStyleSource;
        this.inArea = false;
        this.inIcon = false;
        this.inLine = false;
        this.inCondition = false;
        this.inRule = false;
        this.inDoc = false;
        this.rule.init();
    }

    Color convertColor(String string) {
        int n = string.indexOf("#");
        Color color = n < 0 ? Main.pref.getColor("mappaint." + this.style.getPrefName() + "." + string, Color.red) : (n == 0 ? ColorHelper.html2color(string) : Main.pref.getColor("mappaint." + this.style.getPrefName() + "." + string.substring(0, n), ColorHelper.html2color(string.substring(n))));
        return color;
    }

    public void startDocument() {
        this.inDoc = true;
    }

    public void endDocument() {
        this.inDoc = false;
    }

    private void error(String string) {
        String string2 = this.style.getDisplayString() + " (" + this.rule.cond.key + "=" + this.rule.cond.value + "): " + string;
        System.err.println(string2);
        this.style.logError(new Exception(string2));
    }

    private void startElementLine(String string, Attributes attributes, LinePrototype linePrototype) {
        for (int i = 0; i < attributes.getLength(); ++i) {
            Object object;
            if (attributes.getQName(i).equals("width")) {
                object = attributes.getValue(i);
                if (object.startsWith("+") || object.startsWith("-") || object.endsWith("%")) continue;
                linePrototype.setWidth(Integer.parseInt((String)object));
                continue;
            }
            if (attributes.getQName(i).equals("colour")) {
                linePrototype.color = this.convertColor(attributes.getValue(i));
                continue;
            }
            if (attributes.getQName(i).equals("realwidth")) {
                linePrototype.realWidth = Integer.parseInt(attributes.getValue(i));
                continue;
            }
            if (attributes.getQName(i).equals("dashed")) {
                int n;
                try {
                    String[] stringArray = attributes.getValue(i).split(",");
                    object = new Float[stringArray.length];
                    for (n = 0; n < stringArray.length; ++n) {
                        object[n] = Float.valueOf(Integer.parseInt(stringArray[n]));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    n = Boolean.parseBoolean(attributes.getValue(i));
                    object = n != 0 ? new Float[]{Float.valueOf(9.0f)} : null;
                }
                linePrototype.setDashed(object == null ? null : Arrays.asList(object));
                continue;
            }
            if (attributes.getQName(i).equals("dashedcolour")) {
                linePrototype.dashedColor = this.convertColor(attributes.getValue(i));
                continue;
            }
            if (attributes.getQName(i).equals("priority")) {
                linePrototype.priority = Integer.parseInt(attributes.getValue(i));
                continue;
            }
            if (attributes.getQName(i).equals("mode") && linePrototype instanceof LinemodPrototype) continue;
            this.error("The element \"" + string + "\" has unknown attribute \"" + attributes.getQName(i) + "\"!");
        }
    }

    private void startElementLinemod(String string, Attributes attributes, LinemodPrototype linemodPrototype) {
        this.startElementLine(string, attributes, linemodPrototype);
        for (int i = 0; i < attributes.getLength(); ++i) {
            if (attributes.getQName(i).equals("width")) {
                String string2 = attributes.getValue(i);
                if (string2.startsWith("+")) {
                    linemodPrototype.setWidth(Integer.parseInt(string2.substring(1)));
                    linemodPrototype.widthMode = LinemodPrototype.WidthMode.OFFSET;
                    continue;
                }
                if (string2.startsWith("-")) {
                    linemodPrototype.setWidth(Integer.parseInt(string2));
                    linemodPrototype.widthMode = LinemodPrototype.WidthMode.OFFSET;
                    continue;
                }
                if (string2.endsWith("%")) {
                    linemodPrototype.setWidth(Integer.parseInt(string2.substring(0, string2.length() - 1)));
                    linemodPrototype.widthMode = LinemodPrototype.WidthMode.PERCENT;
                    continue;
                }
                linemodPrototype.setWidth(Integer.parseInt(string2));
                continue;
            }
            if (!attributes.getQName(i).equals("mode")) continue;
            linemodPrototype.over = !attributes.getValue(i).equals("under");
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) {
        if (this.inDoc) {
            if (string3.equals("rule")) {
                this.inRule = true;
            } else if (string3.equals("rules")) {
                if (this.style.name == null) {
                    this.style.name = attributes.getValue("name");
                }
                if (this.style.title == null) {
                    this.style.title = attributes.getValue("shortdescription");
                }
                if (this.style.icon == null) {
                    this.style.icon = attributes.getValue("icon");
                }
            } else if (string3.equals("scale_max")) {
                this.inScaleMax = true;
            } else if (string3.equals("scale_min")) {
                this.inScaleMin = true;
            } else if (string3.equals("condition") && this.inRule) {
                this.inCondition = true;
                XmlCondition xmlCondition = this.rule.cond;
                if (xmlCondition.key != null) {
                    if (this.rule.conditions == null) {
                        this.rule.conditions = new LinkedList<XmlCondition>();
                    }
                    this.rule.conditions.add(new XmlCondition(this.rule.cond));
                    xmlCondition = new XmlCondition();
                    this.rule.conditions.add(xmlCondition);
                }
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (attributes.getQName(i).equals("k")) {
                        xmlCondition.key = attributes.getValue(i);
                        continue;
                    }
                    if (attributes.getQName(i).equals("v")) {
                        xmlCondition.value = attributes.getValue(i);
                        continue;
                    }
                    if (attributes.getQName(i).equals("b")) {
                        xmlCondition.boolValue = attributes.getValue(i);
                        continue;
                    }
                    this.error("The element \"" + string3 + "\" has unknown attribute \"" + attributes.getQName(i) + "\"!");
                }
                if (xmlCondition.key == null) {
                    this.error("The condition has no key!");
                }
            } else if (string3.equals("line")) {
                this.inLine = true;
                this.hadLine = true;
                this.startElementLine(string3, attributes, this.rule.line);
            } else if (string3.equals("linemod")) {
                this.inLineMod = true;
                this.hadLineMod = true;
                this.startElementLinemod(string3, attributes, this.rule.linemod);
            } else if (string3.equals("icon")) {
                this.inIcon = true;
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (attributes.getQName(i).equals("src")) {
                        MapPaintStyles.IconReference iconReference = new MapPaintStyles.IconReference(attributes.getValue(i), this.style);
                        this.hadIcon = iconReference != null;
                        this.rule.icon.icon = iconReference;
                        continue;
                    }
                    if (attributes.getQName(i).equals("annotate")) {
                        this.rule.icon.annotate = Boolean.parseBoolean(attributes.getValue(i));
                        continue;
                    }
                    if (attributes.getQName(i).equals("priority")) {
                        this.rule.icon.priority = Integer.parseInt(attributes.getValue(i));
                        continue;
                    }
                    this.error("The element \"" + string3 + "\" has unknown attribute \"" + attributes.getQName(i) + "\"!");
                }
            } else if (string3.equals("area")) {
                this.inArea = true;
                this.hadArea = true;
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (attributes.getQName(i).equals("colour")) {
                        this.rule.area.color = this.convertColor(attributes.getValue(i));
                        continue;
                    }
                    if (attributes.getQName(i).equals("closed")) {
                        this.rule.area.closed = Boolean.parseBoolean(attributes.getValue(i));
                        continue;
                    }
                    if (attributes.getQName(i).equals("priority")) {
                        this.rule.area.priority = Integer.parseInt(attributes.getValue(i));
                        continue;
                    }
                    this.error("The element \"" + string3 + "\" has unknown attribute \"" + attributes.getQName(i) + "\"!");
                }
            } else {
                this.error("The element \"" + string3 + "\" is unknown!");
            }
        }
    }

    public void endElement(String string, String string2, String string3) {
        if (this.inRule && string3.equals("rule")) {
            if (this.hadLine) {
                this.style.add(this.rule.cond, this.rule.conditions, new LinePrototype(this.rule.line, new Range(this.rule.scaleMin, this.rule.scaleMax)));
            }
            if (this.hadLineMod) {
                this.style.add(this.rule.cond, this.rule.conditions, new LinemodPrototype(this.rule.linemod, new Range(this.rule.scaleMin, this.rule.scaleMax)));
            }
            if (this.hadIcon) {
                this.style.add(this.rule.cond, this.rule.conditions, new IconPrototype(this.rule.icon, new Range(this.rule.scaleMin, this.rule.scaleMax)));
            }
            if (this.hadArea) {
                this.style.add(this.rule.cond, this.rule.conditions, new AreaPrototype(this.rule.area, new Range(this.rule.scaleMin, this.rule.scaleMax)));
            }
            this.inRule = false;
            this.hadArea = false;
            this.hadIcon = false;
            this.hadLineMod = false;
            this.hadLine = false;
            this.rule.init();
        } else if (this.inCondition && string3.equals("condition")) {
            this.inCondition = false;
        } else if (this.inLine && string3.equals("line")) {
            this.inLine = false;
        } else if (this.inLineMod && string3.equals("linemod")) {
            this.inLineMod = false;
        } else if (this.inIcon && string3.equals("icon")) {
            this.inIcon = false;
        } else if (this.inArea && string3.equals("area")) {
            this.inArea = false;
        } else if (string3.equals("scale_max")) {
            this.inScaleMax = false;
        } else if (string3.equals("scale_min")) {
            this.inScaleMin = false;
        }
    }

    public void characters(char[] cArray, int n, int n2) {
        if (this.inScaleMax) {
            this.rule.scaleMax = Long.parseLong(new String(cArray, n, n2));
        } else if (this.inScaleMin) {
            this.rule.scaleMin = Long.parseLong(new String(cArray, n, n2));
        }
    }

    static class RuleElem {
        XmlCondition cond = new XmlCondition();
        Collection<XmlCondition> conditions;
        double scaleMax;
        double scaleMin;
        LinePrototype line = new LinePrototype();
        LinemodPrototype linemod = new LinemodPrototype();
        AreaPrototype area = new AreaPrototype();
        IconPrototype icon = new IconPrototype();

        RuleElem() {
        }

        public void init() {
            this.conditions = null;
            this.scaleMax = Double.POSITIVE_INFINITY;
            this.scaleMin = 0.0;
            this.line.init();
            this.cond.init();
            this.linemod.init();
            this.area.init();
            this.icon.init();
        }
    }
}

