/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.Authenticator;
import java.net.ProxySelector;
import java.net.URL;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import org.jdesktop.swinghelper.debug.CheckThreadViolationRepaintManager;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.AutosaveTask;
import org.openstreetmap.josm.data.CustomConfigurator;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.SplashScreen;
import org.openstreetmap.josm.gui.download.DownloadDialog;
import org.openstreetmap.josm.gui.preferences.server.OAuthAccessTokenHolder;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.DefaultProxySelector;
import org.openstreetmap.josm.io.auth.CredentialsManager;
import org.openstreetmap.josm.io.auth.DefaultAuthenticator;
import org.openstreetmap.josm.io.remotecontrol.RemoteControl;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.tools.BugReportExceptionHandler;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainApplication
extends Main {
    public MainApplication() {
    }

    public MainApplication(JFrame jFrame) {
        jFrame.setContentPane(contentPanePrivate);
        jFrame.setJMenuBar(this.menu);
        geometry.applySafe(jFrame);
        LinkedList<Image> linkedList = new LinkedList<Image>();
        linkedList.add(ImageProvider.get("logo_16x16x32").getImage());
        linkedList.add(ImageProvider.get("logo_16x16x8").getImage());
        linkedList.add(ImageProvider.get("logo_32x32x32").getImage());
        linkedList.add(ImageProvider.get("logo_32x32x8").getImage());
        linkedList.add(ImageProvider.get("logo_48x48x32").getImage());
        linkedList.add(ImageProvider.get("logo_48x48x8").getImage());
        linkedList.add(ImageProvider.get("logo").getImage());
        jFrame.setIconImages(linkedList);
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Main.exitJosm(true);
            }
        });
        jFrame.setDefaultCloseOperation(0);
    }

    public static void showHelp() {
        System.out.println(I18n.tr("Java OpenStreetMap Editor", new Object[0]) + "\n\n" + I18n.tr("usage", new Object[0]) + ":\n" + "\tjava -jar josm.jar <options>...\n\n" + I18n.tr("options", new Object[0]) + ":\n" + "\t--help|-h                                 " + I18n.tr("Show this help", new Object[0]) + "\n" + "\t--geometry=widthxheight(+|-)x(+|-)y       " + I18n.tr("Standard unix geometry argument", new Object[0]) + "\n" + "\t[--download=]minlat,minlon,maxlat,maxlon  " + I18n.tr("Download the bounding box", new Object[0]) + "\n" + "\t[--download=]<url>                        " + I18n.tr("Download the location at the url (with lat=x&lon=y&zoom=z)", new Object[0]) + "\n" + "\t[--download=]<filename>                   " + I18n.tr("Open a file (any file type that can be opened with File/Open)", new Object[0]) + "\n" + "\t--downloadgps=minlat,minlon,maxlat,maxlon " + I18n.tr("Download the bounding box as raw gps", new Object[0]) + "\n" + "\t--downloadgps=<url>                       " + I18n.tr("Download the location at the url (with lat=x&lon=y&zoom=z) as raw gps", new Object[0]) + "\n" + "\t--selection=<searchstring>                " + I18n.tr("Select with the given search", new Object[0]) + "\n" + "\t--[no-]maximize                           " + I18n.tr("Launch in maximized mode", new Object[0]) + "\n" + "\t--reset-preferences                       " + I18n.tr("Reset the preferences to default", new Object[0]) + "\n\n" + "\t--load-preferences=<url-to-xml>           " + I18n.tr("Changes preferences according to the XML file", new Object[0]) + "\n\n" + "\t--set=<key>=<value>                       " + I18n.tr("Set preference key to value", new Object[0]) + "\n\n" + "\t--language=<language>                     " + I18n.tr("Set the language", new Object[0]) + "\n\n" + I18n.tr("options provided as Java system properties", new Object[0]) + ":\n" + "\t-Djosm.home=" + I18n.tr("/PATH/TO/JOSM/FOLDER/         ", new Object[0]) + I18n.tr("Change the folder for all user settings", new Object[0]) + "\n\n" + I18n.tr("note: For some tasks, JOSM needs a lot of memory. It can be necessary to add the following\n      Java option to specify the maximum size of allocated memory in megabytes", new Object[0]) + ":\n" + "\t-Xmx...m\n\n" + I18n.tr("examples", new Object[0]) + ":\n" + "\tjava -jar josm.jar track1.gpx track2.gpx london.osm\n" + "\tjava -jar josm.jar http://www.openstreetmap.org/index.html?lat=43.2&lon=11.1&zoom=13\n" + "\tjava -jar josm.jar london.osm --selection=http://www.ostertag.name/osm/OSM_errors_node-duplicate.xml\n" + "\tjava -jar josm.jar 43.2,11.1,43.4,11.4\n" + "\tjava -Djosm.home=/home/user/.josm_dev -jar josm.jar\n" + "\tjava -Xmx400m -jar josm.jar\n\n" + I18n.tr("Parameters --download, --downloadgps, and --selection are processed in this order.", new Object[0]) + "\n" + I18n.tr("Make sure you load some data if you use --selection.", new Object[0]) + "\n");
    }

    private static Map<Option, Collection<String>> buildCommandLineArgumentMap(String[] stringArray) {
        Collection<String> collection;
        int n;
        ArrayList<LongOpt> arrayList = new ArrayList<LongOpt>();
        for (Option option : Option.values()) {
            arrayList.add(new LongOpt(option.getName(), option.requiresArgument() ? 1 : 0, null, 0));
        }
        Getopt getopt = new Getopt("JOSM", stringArray, "hv", arrayList.toArray(new LongOpt[0]));
        HashMap<Option, Collection<String>> hashMap = new HashMap<Option, Collection<String>>();
        while ((n = getopt.getopt()) != -1) {
            Option option;
            option = null;
            switch (n) {
                case 104: {
                    option = Option.HELP;
                    break;
                }
                case 118: {
                    option = Option.VERSION;
                    break;
                }
                case 0: {
                    option = Option.values()[getopt.getLongind()];
                }
            }
            if (option != null) {
                collection = (ArrayList<String>)hashMap.get((Object)option);
                if (collection == null) {
                    collection = new ArrayList<String>();
                    hashMap.put(option, collection);
                }
                collection.add(getopt.getOptarg());
                continue;
            }
            throw new IllegalArgumentException();
        }
        for (int i = getopt.getOptind(); i < stringArray.length; ++i) {
            collection = (Collection)hashMap.get((Object)Option.DOWNLOAD);
            if (collection == null) {
                collection = new ArrayList();
                hashMap.put(Option.DOWNLOAD, collection);
            }
            collection.add(stringArray[i]);
        }
        return hashMap;
    }

    /*
     * WARNING - void declaration
     */
    public static void main(String[] stringArray) {
        void var5_14;
        Object object;
        Object object4;
        I18n.init();
        Main.checkJava6();
        Main.pref = new Preferences();
        Policy.setPolicy(new Policy(){
            private PermissionCollection pc = new Permissions();
            {
                this.pc.add(new AllPermission());
            }

            public void refresh() {
            }

            public PermissionCollection getPermissions(CodeSource codeSource) {
                return this.pc;
            }
        });
        Thread.setDefaultUncaughtExceptionHandler(new BugReportExceptionHandler());
        System.setProperty("sun.awt.exception.handler", BugReportExceptionHandler.class.getName());
        Main.determinePlatformHook();
        Main.platform.preStartupHook();
        Map<Option, Collection<String>> map = null;
        try {
            map = MainApplication.buildCommandLineArgumentMap(stringArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.exit(1);
        }
        if (map.containsKey((Object)Option.VERSION)) {
            System.out.println(Version.getInstance().getAgentString());
            System.exit(0);
        } else {
            System.out.println(Version.getInstance().getReleaseAttributes());
        }
        Main.pref.init(map.containsKey((Object)Option.RESET_PREFERENCES));
        if (map.containsKey((Object)Option.LANGUAGE)) {
            I18n.set(map.get((Object)Option.LANGUAGE).iterator().next());
        } else {
            I18n.set(Main.pref.get("language", null));
        }
        Main.pref.updateSystemProperties();
        JFrame jFrame = new JFrame(I18n.tr("Java OpenStreetMap Editor", new Object[0]));
        Main.parent = jFrame;
        if (map.containsKey((Object)Option.LOAD_PREFERENCES)) {
            object4 = new CustomConfigurator.XMLCommandProcessor(Main.pref);
            for (String string : map.get((Object)Option.LOAD_PREFERENCES)) {
                System.out.println("Reading preferences from " + string);
                try {
                    object = new URL(string);
                    ((CustomConfigurator.XMLCommandProcessor)object4).openAndReadXML(((URL)object).openStream());
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
        }
        if (map.containsKey((Object)Option.SET)) {
            for (String string : map.get((Object)Option.SET)) {
                String[] stringArray2 = string.split("=", 2);
                Main.pref.put(stringArray2[0], "null".equals(stringArray2[1]) ? null : stringArray2[1]);
            }
        }
        DefaultAuthenticator.createInstance();
        Authenticator.setDefault(DefaultAuthenticator.getInstance());
        ProxySelector.setDefault(new DefaultProxySelector(ProxySelector.getDefault()));
        OAuthAccessTokenHolder.getInstance().init(Main.pref, CredentialsManager.getInstance());
        if (map.containsKey((Object)Option.HELP)) {
            MainApplication.showHelp();
            System.exit(0);
        }
        object4 = new SplashScreen();
        final ProgressMonitor progressMonitor = ((SplashScreen)object4).getProgressMonitor();
        progressMonitor.beginTask(I18n.tr("Initializing", new Object[0]));
        ((Window)object4).setVisible(Main.pref.getBoolean("draw.splashscreen", true));
        Main.setInitStatusListener(new Main.InitStatusListener(){

            public void updateStatus(String string) {
                progressMonitor.indeterminateSubTask(string);
            }
        });
        List<PluginInformation> list = PluginHandler.buildListOfPluginsToLoad((Component)object4, progressMonitor.createSubTaskMonitor(1, false));
        if (!list.isEmpty() && PluginHandler.checkAndConfirmPluginUpdate((Component)object4)) {
            progressMonitor.subTask(I18n.tr("Updating plugins", new Object[0]));
            List<PluginInformation> list2 = PluginHandler.updatePlugins((Component)object4, list, progressMonitor.createSubTaskMonitor(1, false));
        }
        progressMonitor.indeterminateSubTask(I18n.tr("Installing updated plugins", new Object[0]));
        PluginHandler.installDownloadedPlugins(true);
        progressMonitor.indeterminateSubTask(I18n.tr("Loading early plugins", new Object[0]));
        PluginHandler.loadEarlyPlugins((Component)object4, (Collection<PluginInformation>)var5_14, progressMonitor.createSubTaskMonitor(1, false));
        progressMonitor.indeterminateSubTask(I18n.tr("Setting defaults", new Object[0]));
        MainApplication.preConstructorInit(map);
        progressMonitor.indeterminateSubTask(I18n.tr("Creating main GUI", new Object[0]));
        Main.addListener();
        object = new MainApplication(jFrame);
        progressMonitor.indeterminateSubTask(I18n.tr("Loading plugins", new Object[0]));
        PluginHandler.loadLatePlugins((Component)object4, (Collection<PluginInformation>)var5_14, progressMonitor.createSubTaskMonitor(1, false));
        toolbar.refreshToolbarControl();
        ((Window)object4).setVisible(false);
        ((Window)object4).dispose();
        jFrame.setVisible(true);
        boolean bl = Boolean.parseBoolean(Main.pref.get("gui.maximized"));
        if (!map.containsKey((Object)Option.NO_MAXIMIZE) && bl || map.containsKey((Object)Option.MAXIMIZE)) {
            if (Toolkit.getDefaultToolkit().isFrameStateSupported(6)) {
                Main.windowState = 6;
                jFrame.setExtendedState(Main.windowState);
            } else {
                Main.debug("Main window: maximizing not supported");
            }
        }
        if (((Main)object).menu.fullscreenToggleAction != null) {
            ((Main)object).menu.fullscreenToggleAction.initial();
        }
        Map<Option, Collection<String>> map2 = map;
        SwingUtilities.invokeLater(new Runnable((Main)object, map2){
            final /* synthetic */ Main val$main;
            final /* synthetic */ Map val$args_final;
            {
                this.val$main = main;
                this.val$args_final = map;
            }

            public void run() {
                if (AutosaveTask.PROP_AUTOSAVE_ENABLED.get()) {
                    AutosaveTask autosaveTask = new AutosaveTask();
                    List<File> list = autosaveTask.getUnsavedLayersFiles();
                    if (!list.isEmpty()) {
                        ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, I18n.tr("Unsaved osm data", new Object[0]), new String[]{I18n.tr("Restore", new Object[0]), I18n.tr("Cancel", new Object[0]), I18n.tr("Discard", new Object[0])});
                        extendedDialog.setContent(I18n.trn("JOSM found {0} unsaved osm data layer. ", "JOSM found {0} unsaved osm data layers. ", list.size(), list.size()) + I18n.tr("It looks like JOSM crashed last time. Would you like to restore the data?", new Object[0]));
                        extendedDialog.setButtonIcons(new String[]{"ok", "cancel", "dialogs/remove"});
                        int n = extendedDialog.showDialog().getValue();
                        if (n == 1) {
                            autosaveTask.recoverUnsavedLayers();
                        } else if (n == 3) {
                            autosaveTask.dicardUnsavedLayers();
                        }
                    }
                    autosaveTask.schedule();
                }
                this.val$main.postConstructorProcessCmdLine(this.val$args_final);
                DownloadDialog.autostartIfNeeded();
            }
        });
        if (RemoteControl.PROP_REMOTECONTROL_ENABLED.get()) {
            RemoteControl.start();
        }
        if (Main.pref.getBoolean("debug.edt-checker.enable", Version.getInstance().isLocalBuild())) {
            System.out.println("Enabled EDT checker, wrongful access to gui from non EDT thread will be printed to console");
            RepaintManager.setCurrentManager(new CheckThreadViolationRepaintManager());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Option {
        HELP(false),
        VERSION(false),
        LANGUAGE(true),
        RESET_PREFERENCES(false),
        LOAD_PREFERENCES(true),
        SET(true),
        GEOMETRY(true),
        NO_MAXIMIZE(false),
        MAXIMIZE(false),
        DOWNLOAD(true),
        DOWNLOADGPS(true),
        SELECTION(true);

        private String name = this.name().toLowerCase().replace("_", "-");
        private boolean requiresArgument;

        private Option(boolean bl) {
            this.requiresArgument = bl;
        }

        public String getName() {
            return this.name;
        }

        public boolean requiresArgument() {
            return this.requiresArgument;
        }

        public static Map<Option, Collection<String>> fromStringMap(Map<String, Collection<String>> map) {
            HashMap<Option, Collection<String>> hashMap = new HashMap<Option, Collection<String>>();
            for (Map.Entry<String, Collection<String>> entry : map.entrySet()) {
                Option option = Option.valueOf(entry.getKey().toUpperCase().replace("-", "_"));
                if (option == null) continue;
                hashMap.put(option, entry.getValue());
            }
            return hashMap;
        }
    }
}

