/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.QuadBuckets;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.tools.FilteredCollection;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Predicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildingInBuilding
extends Test {
    protected static final int BUILDING_INSIDE_BUILDING = 2001;
    protected List<OsmPrimitive> primitivesToCheck = new LinkedList<OsmPrimitive>();
    protected QuadBuckets<Way> index = new QuadBuckets();

    public BuildingInBuilding() {
        super(I18n.tr("Building inside building", new Object[0]), I18n.tr("Checks for building areas inside of buildings.", new Object[0]));
    }

    @Override
    public void visit(Node node) {
        if (node.isUsable() && BuildingInBuilding.isBuilding(node)) {
            this.primitivesToCheck.add(node);
        }
    }

    @Override
    public void visit(Way way) {
        if (way.isUsable() && way.isClosed() && BuildingInBuilding.isBuilding(way)) {
            this.primitivesToCheck.add(way);
            this.index.add(way);
        }
    }

    private static boolean isInPolygon(Node node, List<Node> list) {
        return Geometry.nodeInsidePolygon(node, list);
    }

    private static boolean isInPolygon(Way way, List<Node> list) {
        for (Node object : way.getNodes()) {
            if (BuildingInBuilding.isInPolygon(object, list)) continue;
            return false;
        }
        for (int i = 1; i < way.getNodesCount(); ++i) {
            LatLon latLon = way.getNode(i).getCoor().getCenter(way.getNode(i - 1).getCoor());
            if (latLon == null || BuildingInBuilding.isInPolygon(new Node(latLon), list)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void endTest() {
        for (final OsmPrimitive osmPrimitive : this.primitivesToCheck) {
            FilteredCollection<Way> filteredCollection = new FilteredCollection<Way>((Collection<Way>)this.index.search(osmPrimitive.getBBox()), new Predicate<Way>(){

                @Override
                public boolean evaluate(Way way) {
                    if (osmPrimitive.equals(way)) {
                        return false;
                    }
                    if (osmPrimitive instanceof Node) {
                        return BuildingInBuilding.isInPolygon((Node)osmPrimitive, (List<Node>)way.getNodes()) || way.getNodes().contains(osmPrimitive);
                    }
                    if (osmPrimitive instanceof Way) {
                        return BuildingInBuilding.isInPolygon((Way)osmPrimitive, (List<Node>)way.getNodes()) && !BuildingInBuilding.this.isInInnerWay((Way)osmPrimitive, way);
                    }
                    return false;
                }
            });
            if (filteredCollection.isEmpty()) continue;
            this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr("Building inside building", new Object[0]), 2001, osmPrimitive));
        }
        super.endTest();
    }

    private boolean isInInnerWay(Way way, Way way2) {
        for (OsmPrimitive osmPrimitive : way2.getReferrers()) {
            if (!(osmPrimitive instanceof Relation) || !((Relation)osmPrimitive).isMultipolygon()) continue;
            for (RelationMember relationMember : ((Relation)osmPrimitive).getMembers()) {
                Way way3;
                if (!relationMember.hasRole() || !relationMember.getRole().equals("inner") || !relationMember.getType().equals((Object)OsmPrimitiveType.WAY) || !BuildingInBuilding.isInPolygon(way3 = relationMember.getWay(), way2.getNodes()) || !BuildingInBuilding.isInPolygon(way, way3.getNodes())) continue;
                return true;
            }
        }
        return false;
    }
}

