/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection;

import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.AbstractProjection;
import org.openstreetmap.josm.data.projection.Ellipsoid;
import org.openstreetmap.josm.data.projection.ProjectionConfigurationException;
import org.openstreetmap.josm.data.projection.datum.GRS80Datum;
import org.openstreetmap.josm.data.projection.proj.LambertConformalConic;
import org.openstreetmap.josm.data.projection.proj.ProjParameters;
import org.openstreetmap.josm.tools.I18n;

public class LambertCC9Zones
extends AbstractProjection {
    public static final double cMaxLatZonesRadian = Math.toRadians(51.1);
    public static final double cMinLatZonesDegree = 41.0;
    public static final double cMaxOverlappingZones = 1.5;
    public static final int DEFAULT_ZONE = 0;
    private final int layoutZone;

    public LambertCC9Zones() {
        this(0);
    }

    public LambertCC9Zones(final int n) {
        this.ellps = Ellipsoid.GRS80;
        this.datum = GRS80Datum.INSTANCE;
        this.layoutZone = n;
        this.x_0 = 1700000.0;
        this.y_0 = (n + 1) * 1000000 + 200000;
        this.lon_0 = 3.0;
        if (this.proj == null) {
            this.proj = new LambertConformalConic();
        }
        try {
            this.proj.initialize(new ProjParameters(){
                {
                    this.ellps = LambertCC9Zones.this.ellps;
                    this.lat_0 = 42.0 + (double)n;
                    this.lat_1 = 41.25 + (double)n;
                    this.lat_2 = 42.75 + (double)n;
                }
            });
        }
        catch (ProjectionConfigurationException projectionConfigurationException) {
            throw new RuntimeException(projectionConfigurationException);
        }
    }

    public String toString() {
        return I18n.tr("Lambert CC9 Zone (France)", new Object[0]);
    }

    public static int north2ZoneNumber(double d) {
        int n = (int)(d / 1000000.0) - 1;
        if (n < 0) {
            return 0;
        }
        if (n > 8) {
            return 8;
        }
        return n;
    }

    public Integer getEpsgCode() {
        return 3942 + this.layoutZone;
    }

    public int hashCode() {
        return this.getClass().getName().hashCode() + this.layoutZone;
    }

    public String getCacheDirectoryName() {
        return "lambert";
    }

    public Bounds getWorldBoundsLatLon() {
        double d = 41.0 + (double)(this.layoutZone + 1);
        return new Bounds(new LatLon(Math.max(d - 1.0 - 1.5, 41.0), -5.5), new LatLon(Math.min(d + 1.0 + 1.5, Math.toDegrees(cMaxLatZonesRadian)), 10.2), false);
    }

    public int getLayoutZone() {
        return this.layoutZone;
    }
}

