/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.session.SessionReader;
import org.openstreetmap.josm.tools.I18n;

public class SessionLoadAction
extends JosmAction {
    public SessionLoadAction() {
        super(I18n.tr("Load Session", new Object[0]), "open", I18n.tr("Load a session from file.", new Object[0]), null, true, "load-session", true);
        this.putValue("help", HelpUtil.ht("/Action/SessionLoad"));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = Main.pref.get("lastDirectory");
        if (string.equals("")) {
            string = ".";
        }
        JFileChooser jFileChooser = new JFileChooser(new File(string));
        jFileChooser.setDialogTitle(I18n.tr("Open session", new Object[0]));
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setAcceptAllFileFilterUsed(true);
        ExtensionFileFilter extensionFileFilter = new ExtensionFileFilter("jos,joz", "jos", I18n.tr("Session file (*.jos, *.joz)", new Object[0]));
        jFileChooser.addChoosableFileFilter(extensionFileFilter);
        int n = jFileChooser.showOpenDialog(Main.parent);
        if (n != 0) {
            return;
        }
        if (!jFileChooser.getCurrentDirectory().getAbsolutePath().equals(string)) {
            Main.pref.put("lastDirectory", jFileChooser.getCurrentDirectory().getAbsolutePath());
        }
        File file = jFileChooser.getSelectedFile();
        boolean bl = true;
        if (file.getName().toLowerCase().endsWith(".jos")) {
            bl = false;
        }
        Main.worker.submit(new Loader(file, bl));
    }

    public static class Loader
    extends PleaseWaitRunnable {
        private boolean canceled;
        private File file;
        private boolean zip;
        private List<Layer> layers;
        private List<Runnable> postLoadTasks;

        public Loader(File file, boolean bl) {
            super(I18n.tr("Loading session ''{0}''", file.getName()));
            this.file = file;
            this.zip = bl;
        }

        protected void cancel() {
            Thread.currentThread();
            Thread.dumpStack();
            this.canceled = true;
        }

        protected void finish() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (Loader.this.canceled) {
                        return;
                    }
                    for (Object object : Loader.this.layers) {
                        if (Loader.this.canceled) {
                            return;
                        }
                        Main.main.addLayer((Layer)object);
                    }
                    for (Object object : Loader.this.postLoadTasks) {
                        if (Loader.this.canceled) {
                            return;
                        }
                        if (object == null) continue;
                        object.run();
                    }
                }
            });
        }

        protected void realRun() {
            try {
                ProgressMonitor progressMonitor = this.getProgressMonitor();
                SessionReader sessionReader = new SessionReader();
                sessionReader.loadSession(this.file, this.zip, progressMonitor);
                this.layers = sessionReader.getLayers();
                this.postLoadTasks = sessionReader.getPostLoadTasks();
            }
            catch (IllegalDataException illegalDataException) {
                illegalDataException.printStackTrace();
                HelpAwareOptionPane.showMessageDialogInEDT(Main.parent, I18n.tr("<html>Could not load session file ''{0}''.<br>Error is:<br>{1}</html>", this.file.getName(), illegalDataException.getMessage()), I18n.tr("Data Error", new Object[0]), 0, null);
                this.cancel();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                HelpAwareOptionPane.showMessageDialogInEDT(Main.parent, I18n.tr("<html>Could not load session file ''{0}''.<br>Error is:<br>{1}</html>", this.file.getName(), iOException.getMessage()), I18n.tr("IO Error", new Object[0]), 0, null);
                this.cancel();
            }
            catch (RuntimeException runtimeException) {
                this.cancel();
                throw runtimeException;
            }
            catch (Error error) {
                this.cancel();
                throw error;
            }
        }
    }
}

