/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.awt.Font;
import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPaintSettings;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPainter;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.Keyword;
import org.openstreetmap.josm.gui.mappaint.mapcss.Instruction;
import org.openstreetmap.josm.tools.Utils;

public abstract class ElemStyle {
    public float major_z_index;
    public float z_index;
    public float object_z_index;
    public boolean isModifier;
    private static String DEFAULT_FONT_NAME = null;
    private static Float DEFAULT_FONT_SIZE = null;
    private static final Map<FontDescriptor, Font> FONT_MAP = new HashMap<FontDescriptor, Font>();

    public ElemStyle(float f, float f2, float f3, boolean bl) {
        this.major_z_index = f;
        this.z_index = f2;
        this.object_z_index = f3;
        this.isModifier = bl;
    }

    protected ElemStyle(Cascade cascade, float f) {
        this.major_z_index = cascade.get("major-z-index", Float.valueOf(f), Float.class).floatValue();
        this.z_index = cascade.get("z-index", Float.valueOf(0.0f), Float.class).floatValue();
        this.object_z_index = cascade.get("object-z-index", Float.valueOf(0.0f), Float.class).floatValue();
        this.isModifier = cascade.get("modifier", false, Boolean.class);
    }

    public abstract void paintPrimitive(OsmPrimitive var1, MapPaintSettings var2, MapPainter var3, boolean var4, boolean var5);

    public boolean isProperLineStyle() {
        return false;
    }

    protected static Float getWidth(Cascade cascade, String string, Float f) {
        Float f2 = cascade.get(string, null, Float.class, true);
        if (f2 != null) {
            if (f2.floatValue() > 0.0f) {
                return f2;
            }
        } else {
            Instruction.RelativeFloat relativeFloat;
            Keyword keyword = cascade.get(string, null, Keyword.class, true);
            if (Utils.equal(keyword, Keyword.THINNEST)) {
                return Float.valueOf(0.0f);
            }
            if (Utils.equal(keyword, Keyword.DEFAULT)) {
                return Float.valueOf(MapPaintSettings.INSTANCE.getDefaultSegmentWidth());
            }
            if (f != null && (relativeFloat = cascade.get(string, null, Instruction.RelativeFloat.class, true)) != null) {
                return Float.valueOf(f.floatValue() + relativeFloat.val);
            }
        }
        return null;
    }

    private static void initDefaultFontParameters() {
        if (DEFAULT_FONT_NAME != null) {
            return;
        }
        DEFAULT_FONT_NAME = Main.pref.get("mappaint.font", "Helvetica");
        DEFAULT_FONT_SIZE = Float.valueOf(Main.pref.getInteger("mappaint.fontsize", 8));
    }

    private static Font getCachedFont(FontDescriptor fontDescriptor) {
        Font font = FONT_MAP.get(fontDescriptor);
        if (font != null) {
            return font;
        }
        font = new Font(fontDescriptor.name, fontDescriptor.style, fontDescriptor.size);
        FONT_MAP.put(fontDescriptor, font);
        return font;
    }

    private static Font getCachedFont(String string, int n, int n2) {
        return ElemStyle.getCachedFont(new FontDescriptor(string, n, n2));
    }

    protected static Font getFont(Cascade cascade) {
        ElemStyle.initDefaultFontParameters();
        String string = cascade.get("font-family", DEFAULT_FONT_NAME, String.class);
        float f = cascade.get("font-size", DEFAULT_FONT_SIZE, Float.class).floatValue();
        int n = 0;
        Keyword keyword = cascade.get("font-weight", null, Keyword.class);
        if (keyword != null && Utils.equal(keyword, "bold")) {
            n = 1;
        }
        int n2 = 0;
        Keyword keyword2 = cascade.get("font-style", null, Keyword.class);
        if (keyword2 != null && Utils.equal(keyword2.val, "italic")) {
            n2 = 2;
        }
        return ElemStyle.getCachedFont(string, n2 | n, Math.round(f));
    }

    public boolean equals(Object object) {
        if (!(object instanceof ElemStyle)) {
            return false;
        }
        ElemStyle elemStyle = (ElemStyle)object;
        return this.major_z_index == elemStyle.major_z_index && this.z_index == elemStyle.z_index && this.object_z_index == elemStyle.object_z_index && this.isModifier == elemStyle.isModifier;
    }

    public int hashCode() {
        int n = 5;
        n = 41 * n + Float.floatToIntBits(this.major_z_index);
        n = 41 * n + Float.floatToIntBits(this.z_index);
        n = 41 * n + Float.floatToIntBits(this.object_z_index);
        n = 41 * n + (this.isModifier ? 1 : 0);
        return n;
    }

    public String toString() {
        return String.format("z_idx=[%s/%s/%s] ", Float.valueOf(this.major_z_index), Float.valueOf(this.z_index), Float.valueOf(this.object_z_index)) + (this.isModifier ? "modifier " : "");
    }

    private static class FontDescriptor {
        public String name;
        public int style;
        public int size;

        public FontDescriptor(String string, int n, int n2) {
            this.name = string;
            this.style = n;
            this.size = n2;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
            n = 31 * n + this.size;
            n = 31 * n + this.style;
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            FontDescriptor fontDescriptor = (FontDescriptor)object;
            if (this.name == null ? fontDescriptor.name != null : !this.name.equals(fontDescriptor.name)) {
                return false;
            }
            if (this.size != fontDescriptor.size) {
                return false;
            }
            return this.style == fontDescriptor.style;
        }
    }
}

