/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection;

import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.AbstractProjection;
import org.openstreetmap.josm.data.projection.Ellipsoid;
import org.openstreetmap.josm.data.projection.ProjectionConfigurationException;
import org.openstreetmap.josm.data.projection.datum.GRS80Datum;
import org.openstreetmap.josm.data.projection.proj.ProjParameters;
import org.openstreetmap.josm.data.projection.proj.TransverseMercator;
import org.openstreetmap.josm.tools.I18n;

public class Puwg
extends AbstractProjection {
    public static final int DEFAULT_ZONE = 0;
    private final int zone;
    public static PuwgData[] zones = new PuwgData[]{new Epsg2180(), new Epsg2176(), new Epsg2177(), new Epsg2178(), new Epsg2179()};

    public Puwg() {
        this(0);
    }

    public Puwg(int n) {
        if (n < 0 || n >= zones.length) {
            throw new IllegalArgumentException();
        }
        this.ellps = Ellipsoid.GRS80;
        this.proj = new TransverseMercator();
        try {
            this.proj.initialize(new ProjParameters(){
                {
                    this.ellps = Puwg.this.ellps;
                }
            });
        }
        catch (ProjectionConfigurationException projectionConfigurationException) {
            throw new RuntimeException(projectionConfigurationException);
        }
        this.datum = GRS80Datum.INSTANCE;
        this.zone = n;
        PuwgData puwgData = zones[n];
        this.x_0 = puwgData.getPuwgFalseEasting();
        this.y_0 = puwgData.getPuwgFalseNorthing();
        this.lon_0 = puwgData.getPuwgCentralMeridianDeg();
        this.k_0 = puwgData.getPuwgScaleFactor();
    }

    public String toString() {
        return I18n.tr("PUWG (Poland)", new Object[0]);
    }

    public Integer getEpsgCode() {
        return zones[this.zone].getEpsgCode();
    }

    public int hashCode() {
        return this.getClass().getName().hashCode() + this.zone;
    }

    public String getCacheDirectoryName() {
        return zones[this.zone].getCacheDirectoryName();
    }

    public Bounds getWorldBoundsLatLon() {
        return zones[this.zone].getWorldBoundsLatLon();
    }

    public static class Epsg2179
    extends Puwg2000 {
        private static final int PuwgZone = 8;

        public int getZone() {
            return 8;
        }
    }

    public static class Epsg2178
    extends Puwg2000 {
        private static final int PuwgZone = 7;

        public int getZone() {
            return 7;
        }
    }

    public static class Epsg2177
    extends Puwg2000 {
        private static final int PuwgZone = 6;

        public int getZone() {
            return 6;
        }
    }

    public static class Epsg2176
    extends Puwg2000 {
        private static final int PuwgZone = 5;

        public int getZone() {
            return 5;
        }
    }

    static abstract class Puwg2000
    implements PuwgData {
        private static final double PuwgFalseEasting = 500000.0;
        private static final double PuwgFalseNorthing = 0.0;
        private static final double PuwgScaleFactor = 0.999923;
        private final Integer[] Puwg2000Code = new Integer[]{2176, 2177, 2178, 2179};
        private final String[] Puwg2000CDName = new String[]{"epsg2176", "epsg2177", "epsg2178", "epsg2179"};

        Puwg2000() {
        }

        public String toString() {
            return I18n.tr("PUWG 2000 Zone {0} (Poland)", Integer.toString(this.getZone()));
        }

        public Integer getEpsgCode() {
            return this.Puwg2000Code[this.getZoneIndex()];
        }

        public String toCode() {
            return "EPSG:" + this.getEpsgCode();
        }

        public String getCacheDirectoryName() {
            return this.Puwg2000CDName[this.getZoneIndex()];
        }

        public Bounds getWorldBoundsLatLon() {
            return new Bounds(new LatLon(49.0, (double)(3 * this.getZone()) - 1.5), new LatLon(54.84, (double)(3 * this.getZone()) + 1.5), false);
        }

        public double getPuwgCentralMeridianDeg() {
            return (double)this.getZone() * 3.0;
        }

        public double getPuwgCentralMeridian() {
            return Math.toRadians((double)this.getZone() * 3.0);
        }

        public double getPuwgFalseNorthing() {
            return 0.0;
        }

        public double getPuwgFalseEasting() {
            return 1000000.0 * (double)this.getZone() + 500000.0;
        }

        public double getPuwgScaleFactor() {
            return 0.999923;
        }

        public abstract int getZone();

        public int getZoneIndex() {
            return this.getZone() - 5;
        }
    }

    public static class Epsg2180
    implements PuwgData {
        private static final double Epsg2180FalseEasting = 500000.0;
        private static final double Epsg2180FalseNorthing = -5300000.0;
        private static final double Epsg2180ScaleFactor = 0.9993;
        private static final double Epsg2180CentralMeridian = 19.0;

        public String toString() {
            return I18n.tr("PUWG 1992 (Poland)", new Object[0]);
        }

        public Integer getEpsgCode() {
            return 2180;
        }

        public String toCode() {
            return "EPSG:" + this.getEpsgCode();
        }

        public String getCacheDirectoryName() {
            return "epsg2180";
        }

        public Bounds getWorldBoundsLatLon() {
            return new Bounds(new LatLon(49.0, 14.12), new LatLon(54.84, 24.15), false);
        }

        public double getPuwgCentralMeridianDeg() {
            return 19.0;
        }

        public double getPuwgCentralMeridian() {
            return Math.toRadians(19.0);
        }

        public double getPuwgFalseEasting() {
            return 500000.0;
        }

        public double getPuwgFalseNorthing() {
            return -5300000.0;
        }

        public double getPuwgScaleFactor() {
            return 0.9993;
        }
    }

    public static interface PuwgData {
        public double getPuwgCentralMeridianDeg();

        public double getPuwgCentralMeridian();

        public double getPuwgFalseEasting();

        public double getPuwgFalseNorthing();

        public double getPuwgScaleFactor();

        public Integer getEpsgCode();

        public String toCode();

        public String getCacheDirectoryName();

        public Bounds getWorldBoundsLatLon();
    }
}

