/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection.datum;

import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.Ellipsoid;
import org.openstreetmap.josm.data.projection.datum.AbstractDatum;
import org.openstreetmap.josm.data.projection.datum.NTV2GridShift;
import org.openstreetmap.josm.data.projection.datum.NTV2GridShiftFile;

public class NTV2Datum
extends AbstractDatum {
    protected NTV2GridShiftFile nadgrids;

    public NTV2Datum(String string, String string2, Ellipsoid ellipsoid, NTV2GridShiftFile nTV2GridShiftFile) {
        super(string, string2, ellipsoid);
        this.nadgrids = nTV2GridShiftFile;
    }

    public LatLon toWGS84(LatLon latLon) {
        NTV2GridShift nTV2GridShift = new NTV2GridShift(latLon);
        this.nadgrids.gridShiftForward(nTV2GridShift);
        return new LatLon(latLon.lat() + nTV2GridShift.getLatShiftDegrees(), latLon.lon() + nTV2GridShift.getLonShiftPositiveEastDegrees());
    }

    public LatLon fromWGS84(LatLon latLon) {
        NTV2GridShift nTV2GridShift = new NTV2GridShift(latLon);
        this.nadgrids.gridShiftReverse(nTV2GridShift);
        return new LatLon(latLon.lat() + nTV2GridShift.getLatShiftDegrees(), latLon.lon() + nTV2GridShift.getLonShiftPositiveEastDegrees());
    }
}

