/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.AbstractProjection;
import org.openstreetmap.josm.data.projection.Ellipsoid;
import org.openstreetmap.josm.data.projection.ProjectionConfigurationException;
import org.openstreetmap.josm.data.projection.ProjectionSubPrefs;
import org.openstreetmap.josm.data.projection.datum.GRS80Datum;
import org.openstreetmap.josm.data.projection.proj.ProjParameters;
import org.openstreetmap.josm.data.projection.proj.TransverseMercator;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UTM
extends AbstractProjection
implements ProjectionSubPrefs {
    private static final int DEFAULT_ZONE = 30;
    private int zone;
    private static final Hemisphere DEFAULT_HEMISPHERE = Hemisphere.North;
    private Hemisphere hemisphere;
    private boolean offset;

    public UTM() {
        this(30, DEFAULT_HEMISPHERE, false);
    }

    public UTM(int n, Hemisphere hemisphere, boolean bl) {
        this.ellps = Ellipsoid.GRS80;
        this.proj = new TransverseMercator();
        try {
            this.proj.initialize(new ProjParameters(){
                {
                    this.ellps = UTM.this.ellps;
                }
            });
        }
        catch (ProjectionConfigurationException projectionConfigurationException) {
            throw new RuntimeException(projectionConfigurationException);
        }
        this.datum = GRS80Datum.INSTANCE;
        this.updateParameters(n, hemisphere, bl);
    }

    public void updateParameters(int n, Hemisphere hemisphere, boolean bl) {
        this.zone = n;
        this.hemisphere = hemisphere;
        this.offset = bl;
        this.x_0 = 500000 + (bl ? 3000000 : 0);
        this.y_0 = hemisphere == Hemisphere.North ? 0.0 : 1.0E7;
        this.lon_0 = this.getUtmCentralMeridianDeg(n);
        this.k_0 = 0.9996;
    }

    private double getUtmCentralMeridianDeg(int n) {
        return -183.0 + (double)n * 6.0;
    }

    public int getzone() {
        return this.zone;
    }

    @Override
    public String toString() {
        return I18n.tr("UTM", new Object[0]);
    }

    @Override
    public Integer getEpsgCode() {
        return (this.offset ? 325800 : 32600) + this.getzone() + (this.hemisphere == Hemisphere.South ? 100 : 0);
    }

    public int hashCode() {
        return this.toCode().hashCode();
    }

    @Override
    public String getCacheDirectoryName() {
        return "epsg" + this.getEpsgCode();
    }

    @Override
    public Bounds getWorldBoundsLatLon() {
        if (this.hemisphere == Hemisphere.North) {
            return new Bounds(new LatLon(-5.0, this.getUtmCentralMeridianDeg(this.getzone()) - 5.0), new LatLon(85.0, this.getUtmCentralMeridianDeg(this.getzone()) + 5.0));
        }
        return new Bounds(new LatLon(-85.0, this.getUtmCentralMeridianDeg(this.getzone()) - 5.0), new LatLon(5.0, this.getUtmCentralMeridianDeg(this.getzone()) + 5.0));
    }

    @Override
    public void setupPreferencePanel(JPanel jPanel, ActionListener actionListener) {
        JComboBox<Integer> jComboBox = new JComboBox<Integer>();
        for (int i = 1; i <= 60; ++i) {
            jComboBox.addItem(i);
        }
        jComboBox.setSelectedIndex(this.zone - 1);
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)new JLabel(I18n.tr("UTM Zone", new Object[0])), GBC.std().insets(5, 5, 0, 5));
        jPanel.add(GBC.glue(1, 0), GBC.std().fill(2));
        jPanel.add(jComboBox, GBC.eop().fill(2));
        jPanel.add(GBC.glue(1, 1), GBC.eol().fill(1));
        JRadioButton jRadioButton = new JRadioButton();
        jRadioButton.setSelected(this.hemisphere == Hemisphere.North);
        JRadioButton jRadioButton2 = new JRadioButton();
        jRadioButton2.setSelected(this.hemisphere == Hemisphere.South);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        jPanel2.add((Component)new JLabel(I18n.tr("North", new Object[0])), GBC.std().insets(5, 5, 0, 5));
        jPanel2.add((Component)jRadioButton, GBC.std().fill(2));
        jPanel2.add(GBC.glue(1, 0), GBC.std().fill(2));
        jPanel2.add((Component)new JLabel(I18n.tr("South", new Object[0])), GBC.std().insets(5, 5, 0, 5));
        jPanel2.add((Component)jRadioButton2, GBC.std().fill(2));
        jPanel2.add(GBC.glue(1, 1), GBC.eol().fill(1));
        jPanel.add((Component)new JLabel(I18n.tr("Hemisphere", new Object[0])), GBC.std().insets(5, 5, 0, 5));
        jPanel.add(GBC.glue(1, 0), GBC.std().fill(2));
        jPanel.add((Component)jPanel2, GBC.eop().fill(2));
        jPanel.add(GBC.glue(1, 1), GBC.eol().fill(1));
        JCheckBox jCheckBox = new JCheckBox();
        jCheckBox.setSelected(this.offset);
        jPanel.add((Component)new JLabel(I18n.tr("Offset 3.000.000m east", new Object[0])), GBC.std().insets(5, 5, 0, 5));
        jPanel.add(GBC.glue(1, 0), GBC.std().fill(2));
        jPanel.add((Component)jCheckBox, GBC.eop().fill(2));
        jPanel.add(GBC.glue(1, 1), GBC.eol().fill(1));
        if (actionListener != null) {
            jRadioButton.addActionListener(actionListener);
            jRadioButton2.addActionListener(actionListener);
            jComboBox.addActionListener(actionListener);
            jCheckBox.addActionListener(actionListener);
        }
    }

    @Override
    public Collection<String> getPreferences(JPanel jPanel) {
        Component component;
        Component component2;
        int n = 30;
        Hemisphere hemisphere = DEFAULT_HEMISPHERE;
        boolean bl = false;
        Component component3 = jPanel.getComponent(2);
        if (component3 instanceof JComboBox) {
            n = ((JComboBox)component3).getSelectedIndex() + 1;
        }
        if ((component2 = jPanel.getComponent(6)) instanceof JPanel && (component = ((JPanel)component2).getComponent(4)) instanceof JRadioButton) {
            Hemisphere hemisphere2 = hemisphere = ((JRadioButton)component).isSelected() ? Hemisphere.South : Hemisphere.North;
        }
        if ((component = jPanel.getComponent(10)) instanceof JCheckBox) {
            bl = ((JCheckBox)component).isSelected();
        }
        return Arrays.asList(Integer.toString(n), hemisphere.toString(), bl ? "offset" : "standard");
    }

    @Override
    public void setPreferences(Collection<String> collection) {
        int n = 30;
        Hemisphere hemisphere = DEFAULT_HEMISPHERE;
        boolean bl = false;
        if (collection != null) {
            String[] stringArray = collection.toArray(new String[0]);
            try {
                n = Integer.parseInt(stringArray[0]);
                if (n <= 0 || n > 60) {
                    n = 30;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (stringArray.length > 1) {
                hemisphere = Hemisphere.valueOf(stringArray[1]);
            }
            if (stringArray.length > 2) {
                bl = stringArray[2].equals("offset");
            }
        }
        this.updateParameters(n, hemisphere, bl);
    }

    @Override
    public String[] allCodes() {
        ArrayList<String> arrayList = new ArrayList<String>(240);
        for (int i = 1; i <= 60; ++i) {
            for (boolean bl : new boolean[]{false, true}) {
                for (Hemisphere hemisphere : Hemisphere.values()) {
                    arrayList.add("EPSG:" + ((bl ? 325800 : 32600) + i + (hemisphere == Hemisphere.South ? 100 : 0)));
                }
            }
        }
        return arrayList.toArray(new String[0]);
    }

    @Override
    public Collection<String> getPreferencesFromCode(String string) {
        boolean bl;
        boolean bl2 = bl = string.startsWith("EPSG:3258") || string.startsWith("EPSG:3259");
        if (string.startsWith("EPSG:326") || string.startsWith("EPSG:327") || bl) {
            try {
                String string2;
                Hemisphere hemisphere;
                if (bl) {
                    hemisphere = string.charAt(8) == '8' ? Hemisphere.North : Hemisphere.South;
                    string2 = string.substring(9);
                } else {
                    hemisphere = string.charAt(7) == '6' ? Hemisphere.North : Hemisphere.South;
                    string2 = string.substring(8);
                }
                int n = Integer.parseInt(string2);
                if (n > 0 && n <= 60) {
                    return Arrays.asList(string2, hemisphere.toString(), bl ? "offset" : "standard");
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Hemisphere {
        North,
        South;

    }
}

