/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Box;
import javax.swing.JPanel;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.AbstractProjection;
import org.openstreetmap.josm.data.projection.Ellipsoid;
import org.openstreetmap.josm.data.projection.ProjectionConfigurationException;
import org.openstreetmap.josm.data.projection.ProjectionSubPrefs;
import org.openstreetmap.josm.data.projection.datum.ThreeParameterDatum;
import org.openstreetmap.josm.data.projection.proj.ProjParameters;
import org.openstreetmap.josm.data.projection.proj.SwissObliqueMercator;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwissGrid
extends AbstractProjection
implements ProjectionSubPrefs {
    public SwissGrid() {
        this.ellps = Ellipsoid.Bessel1841;
        this.datum = new ThreeParameterDatum("SwissGrid Datum", null, this.ellps, 674.374, 15.056, 405.346);
        this.x_0 = 600000.0;
        this.y_0 = 200000.0;
        this.lon_0 = 7.439583333333333;
        this.proj = new SwissObliqueMercator();
        try {
            this.proj.initialize(new ProjParameters(){
                {
                    this.ellps = SwissGrid.this.ellps;
                    this.lat_0 = 46.95240555555556;
                }
            });
        }
        catch (ProjectionConfigurationException projectionConfigurationException) {
            throw new RuntimeException(projectionConfigurationException);
        }
    }

    @Override
    public String toString() {
        return I18n.tr("Swiss Grid (Switzerland)", new Object[0]);
    }

    @Override
    public Integer getEpsgCode() {
        return 21781;
    }

    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    @Override
    public String getCacheDirectoryName() {
        return "swissgrid";
    }

    @Override
    public Bounds getWorldBoundsLatLon() {
        return new Bounds(new LatLon(45.7, 5.7), new LatLon(47.9, 10.6));
    }

    @Override
    public void setupPreferencePanel(JPanel jPanel, ActionListener actionListener) {
        jPanel.add((Component)new HtmlPanel(I18n.tr("<i>CH1903 / LV03 (without local corrections)</i>", new Object[0])), GBC.eol().fill(2));
        jPanel.add(Box.createVerticalGlue(), GBC.eol().fill(1));
    }

    @Override
    public void setPreferences(Collection<String> collection) {
    }

    @Override
    public Collection<String> getPreferences(JPanel jPanel) {
        return Collections.singletonList("CH1903");
    }

    @Override
    public String[] allCodes() {
        return new String[]{"EPSG:21781"};
    }

    @Override
    public Collection<String> getPreferencesFromCode(String string) {
        if ("EPSG:21781".equals(string)) {
            return Collections.singletonList("CH1903");
        }
        return null;
    }
}

