/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.Desktop;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import javax.swing.JApplet;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.I18n;

public class OpenBrowser {
    private static void displayUrlFallback(URI uRI) throws IOException {
        if (Main.platform == null) {
            throw new IllegalStateException(I18n.tr("Failed to open URL. There is currently no platform set. Please set a platform first.", new Object[0]));
        }
        Main.platform.openUrl(uRI.toString());
    }

    public static String displayUrl(URI uRI) {
        if (Main.applet) {
            try {
                JApplet jApplet = (JApplet)Main.parent;
                jApplet.getAppletContext().showDocument(uRI.toURL());
                return null;
            }
            catch (MalformedURLException malformedURLException) {
                return malformedURLException.getMessage();
            }
        }
        if (Desktop.isDesktopSupported()) {
            try {
                try {
                    Desktop.getDesktop().browse(uRI);
                }
                catch (IOException iOException) {
                    System.err.println("Warning: Desktop class failed. Platform dependent fall back for open url in browser.");
                    OpenBrowser.displayUrlFallback(uRI);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return exception.getMessage();
            }
        } else {
            try {
                System.err.println("Warning: Desktop class is not supported. Platform dependent fall back for open url in browser.");
                OpenBrowser.displayUrlFallback(uRI);
            }
            catch (IOException iOException) {
                return iOException.getMessage();
            }
        }
        return null;
    }

    public static String displayUrl(String string) {
        try {
            return OpenBrowser.displayUrl(new URI(string));
        }
        catch (Exception exception) {
            return exception.getMessage();
        }
    }
}

