/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import com.kitfox.svg.SVGDiagram;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.ImageProvider;

class ImageResource {
    private HashMap<Dimension, BufferedImage> imgCache = new HashMap();
    private SVGDiagram svg;
    public static final Dimension DEFAULT_DIMENSION = new Dimension(-1, -1);

    public ImageResource(BufferedImage bufferedImage) {
        CheckParameterUtil.ensureParameterNotNull(bufferedImage);
        this.imgCache.put(DEFAULT_DIMENSION, bufferedImage);
    }

    public ImageResource(SVGDiagram sVGDiagram) {
        CheckParameterUtil.ensureParameterNotNull(sVGDiagram);
        this.svg = sVGDiagram;
    }

    public ImageIcon getImageIcon() {
        return this.getImageIcon(DEFAULT_DIMENSION);
    }

    public ImageIcon getImageIcon(Dimension dimension) {
        if (dimension.width < -1 || dimension.width == 0 || dimension.height < -1 || dimension.height == 0) {
            throw new IllegalArgumentException();
        }
        BufferedImage bufferedImage = this.imgCache.get(dimension);
        if (bufferedImage != null) {
            return new ImageIcon(bufferedImage);
        }
        if (this.svg != null) {
            bufferedImage = ImageProvider.createImageFromSvg(this.svg, dimension);
            this.imgCache.put(dimension, bufferedImage);
            return new ImageIcon(bufferedImage);
        }
        BufferedImage bufferedImage2 = this.imgCache.get(DEFAULT_DIMENSION);
        if (bufferedImage2 == null) {
            throw new AssertionError();
        }
        int n = dimension.width;
        int n2 = dimension.height;
        ImageIcon imageIcon = new ImageIcon(bufferedImage2);
        if (n == -1) {
            n = imageIcon.getIconWidth() * n2 / imageIcon.getIconHeight();
        } else if (n2 == -1) {
            n2 = imageIcon.getIconHeight() * n / imageIcon.getIconWidth();
        }
        Image image = imageIcon.getImage().getScaledInstance(n, n2, 4);
        bufferedImage = new BufferedImage(n, n2, 2);
        bufferedImage.getGraphics().drawImage(image, 0, 0, null);
        this.imgCache.put(dimension, bufferedImage);
        return new ImageIcon(bufferedImage);
    }

    public ImageIcon getImageIconBounded(Dimension dimension) {
        float f;
        float f2;
        if (dimension.width < -1 || dimension.width == 0 || dimension.height < -1 || dimension.height == 0) {
            throw new IllegalArgumentException();
        }
        if (this.svg != null) {
            f2 = this.svg.getWidth();
            f = this.svg.getHeight();
        } else {
            BufferedImage bufferedImage = this.imgCache.get(DEFAULT_DIMENSION);
            if (bufferedImage == null) {
                throw new AssertionError();
            }
            ImageIcon imageIcon = new ImageIcon(bufferedImage);
            f2 = imageIcon.getIconWidth();
            f = imageIcon.getIconHeight();
        }
        int n = dimension.width;
        int n2 = dimension.height;
        if (f2 <= (float)n) {
            n = -1;
        }
        if (f <= (float)n2) {
            n2 = -1;
        }
        if (n == -1 && n2 == -1) {
            return this.getImageIcon(DEFAULT_DIMENSION);
        }
        if (n == -1) {
            return this.getImageIcon(new Dimension(-1, n2));
        }
        if (n2 == -1) {
            return this.getImageIcon(new Dimension(n, -1));
        }
        if (f2 / (float)n > f / (float)n2) {
            return this.getImageIcon(new Dimension(n, -1));
        }
        return this.getImageIcon(new Dimension(-1, n2));
    }
}

