/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.imagery;

import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.imagery.GeorefImage;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.WMSLayer;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.io.ProgressInputStream;
import org.openstreetmap.josm.io.imagery.Grabber;
import org.openstreetmap.josm.io.imagery.WMSRequest;
import org.openstreetmap.josm.tools.Utils;

public class WMSGrabber
extends Grabber {
    protected String baseURL;
    private ImageryInfo info;
    private Map<String, String> props = new HashMap<String, String>();
    public static final NumberFormat latLonFormat = new DecimalFormat("###0.0000000", new DecimalFormatSymbols(Locale.US));

    public WMSGrabber(MapView mapView, WMSLayer wMSLayer, boolean bl) {
        super(mapView, wMSLayer, bl);
        this.info = wMSLayer.getInfo();
        this.baseURL = this.info.getUrl();
        if (wMSLayer.getInfo().getCookies() != null && !wMSLayer.getInfo().getCookies().equals("")) {
            this.props.put("Cookie", wMSLayer.getInfo().getCookies());
        }
        this.props.put("User-Agent", Main.pref.get("imagery.wms.user_agent", Version.getInstance().getAgentString()));
        Pattern pattern = Pattern.compile("\\{header\\(([^,]+),([^}]+)\\)\\}");
        StringBuffer stringBuffer = new StringBuffer();
        Matcher matcher = pattern.matcher(this.baseURL);
        while (matcher.find()) {
            this.props.put(matcher.group(1), matcher.group(2));
            matcher.appendReplacement(stringBuffer, "");
        }
        matcher.appendTail(stringBuffer);
        this.baseURL = stringBuffer.toString();
    }

    void fetch(WMSRequest wMSRequest, int n) throws Exception {
        URL uRL = null;
        try {
            uRL = this.getURL(this.b.minEast, this.b.minNorth, this.b.maxEast, this.b.maxNorth, this.width(), this.height());
            wMSRequest.finish(GeorefImage.State.IMAGE, this.grab(wMSRequest, uRL, n));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new Exception(exception.getMessage() + "\nImage couldn't be fetched: " + (uRL != null ? uRL.toString() : ""));
        }
    }

    protected URL getURL(double d, double d2, double d3, double d4, int n, int n2) throws MalformedURLException {
        Object object;
        String string = Main.getProjection().toCode();
        if (!this.info.getServerProjections().contains(string) && "EPSG:3857".equals(Main.getProjection().toCode())) {
            LatLon latLon = Main.getProjection().eastNorth2latlon(new EastNorth(d, d2));
            object = Main.getProjection().eastNorth2latlon(new EastNorth(d3, d4));
            string = "EPSG:4326";
            d2 = latLon.lat();
            d = latLon.lon();
            d4 = ((LatLon)object).lat();
            d3 = ((LatLon)object).lon();
        }
        if (string.equals("EPSG:4326") && !this.info.getServerProjections().contains(string) && this.info.getServerProjections().contains("CRS:84")) {
            string = "CRS:84";
        }
        boolean bl = false;
        if (this.baseURL.toLowerCase().contains("crs=epsg:4326")) {
            bl = true;
        } else if (this.baseURL.toLowerCase().contains("crs=") && string.equals("EPSG:4326")) {
            bl = true;
        }
        object = bl ? String.format("%s,%s,%s,%s", latLonFormat.format(d2), latLonFormat.format(d), latLonFormat.format(d4), latLonFormat.format(d3)) : String.format("%s,%s,%s,%s", latLonFormat.format(d), latLonFormat.format(d2), latLonFormat.format(d3), latLonFormat.format(d4));
        return new URL(this.baseURL.replaceAll("\\{proj(\\([^})]+\\))?\\}", string).replaceAll("\\{bbox\\}", (String)object).replaceAll("\\{w\\}", latLonFormat.format(d)).replaceAll("\\{s\\}", latLonFormat.format(d2)).replaceAll("\\{e\\}", latLonFormat.format(d3)).replaceAll("\\{n\\}", latLonFormat.format(d4)).replaceAll("\\{width\\}", String.valueOf(n)).replaceAll("\\{height\\}", String.valueOf(n2)).replace(" ", "%20"));
    }

    public boolean loadFromCache(WMSRequest wMSRequest) {
        BufferedImage bufferedImage;
        BufferedImage bufferedImage2 = this.layer.cache.getExactMatch(Main.getProjection(), wMSRequest.getPixelPerDegree(), this.b.minEast, this.b.minNorth);
        if (bufferedImage2 != null) {
            wMSRequest.finish(GeorefImage.State.IMAGE, bufferedImage2);
            return true;
        }
        if (wMSRequest.isAllowPartialCacheMatch() && (bufferedImage = this.layer.cache.getPartialMatch(Main.getProjection(), wMSRequest.getPixelPerDegree(), this.b.minEast, this.b.minNorth)) != null) {
            wMSRequest.finish(GeorefImage.State.PARTLY_IN_CACHE, bufferedImage);
            return true;
        }
        if (!wMSRequest.isReal() && !this.layer.hasAutoDownload()) {
            wMSRequest.finish(GeorefImage.State.NOT_IN_CACHE, null);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BufferedImage grab(WMSRequest wMSRequest, URL uRL, int n) throws IOException, OsmTransferException {
        System.out.println("Grabbing WMS " + (n > 1 ? "(attempt " + n + ") " : "") + uRL);
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        for (Map.Entry<String, String> object2 : this.props.entrySet()) {
            httpURLConnection.setRequestProperty(object2.getKey(), object2.getValue());
        }
        httpURLConnection.setConnectTimeout(Main.pref.getInteger("socket.timeout.connect", 15) * 1000);
        httpURLConnection.setReadTimeout(Main.pref.getInteger("socket.timeout.read", 30) * 1000);
        String string = httpURLConnection.getHeaderField("Content-Type");
        if (httpURLConnection.getResponseCode() != 200 || string != null && !string.startsWith("image")) {
            throw new IOException(this.readException(httpURLConnection));
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ProgressInputStream progressInputStream = new ProgressInputStream(httpURLConnection, null);
        try {
            Utils.copyStream(progressInputStream, byteArrayOutputStream);
        }
        finally {
            ((InputStream)progressInputStream).close();
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        BufferedImage bufferedImage = this.layer.normalizeImage(ImageIO.read(byteArrayInputStream));
        byteArrayInputStream.reset();
        this.layer.cache.saveToCache(this.layer.isOverlapEnabled() ? bufferedImage : null, byteArrayInputStream, Main.getProjection(), wMSRequest.getPixelPerDegree(), this.b.minEast, this.b.minNorth);
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String readException(URLConnection uRLConnection) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        InputStream inputStream = uRLConnection.getInputStream();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string.replaceAll("[^\\p{Print}]", ""));
                stringBuilder.append('\n');
            }
            String string2 = stringBuilder.toString();
            return string2;
        }
        finally {
            bufferedReader.close();
        }
    }
}

