/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.auth;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.josm.gui.io.CredentialDialog;
import org.openstreetmap.josm.io.auth.CredentialsAgent;
import org.openstreetmap.josm.io.auth.CredentialsAgentException;
import org.openstreetmap.josm.io.auth.CredentialsAgentResponse;

public abstract class AbstractCredentialsAgent
implements CredentialsAgent {
    protected Map<Authenticator.RequestorType, PasswordAuthentication> memoryCredentialsCache = new HashMap<Authenticator.RequestorType, PasswordAuthentication>();

    public CredentialsAgentResponse getCredentials(Authenticator.RequestorType requestorType, String string, boolean bl) throws CredentialsAgentException {
        if (requestorType == null) {
            return null;
        }
        PasswordAuthentication passwordAuthentication = this.lookup(requestorType, string);
        String string2 = passwordAuthentication == null || passwordAuthentication.getUserName() == null ? "" : passwordAuthentication.getUserName();
        String string3 = passwordAuthentication == null || passwordAuthentication.getPassword() == null ? "" : String.valueOf(passwordAuthentication.getPassword());
        CredentialsAgentResponse credentialsAgentResponse = new CredentialsAgentResponse();
        if (!bl && this.memoryCredentialsCache.containsKey((Object)requestorType) && (passwordAuthentication == null || passwordAuthentication.getPassword() == null || passwordAuthentication.getPassword().length == 0)) {
            PasswordAuthentication passwordAuthentication2 = this.memoryCredentialsCache.get((Object)requestorType);
            credentialsAgentResponse.setUsername(passwordAuthentication2.getUserName());
            credentialsAgentResponse.setPassword(passwordAuthentication2.getPassword());
            credentialsAgentResponse.setCanceled(false);
        } else if (bl || string2.equals("") || string3.equals("")) {
            CredentialDialog credentialDialog = null;
            switch (requestorType) {
                case SERVER: {
                    credentialDialog = CredentialDialog.getOsmApiCredentialDialog(string2, string3, string, this.getSaveUsernameAndPasswordCheckboxText());
                    break;
                }
                case PROXY: {
                    credentialDialog = CredentialDialog.getHttpProxyCredentialDialog(string2, string3, string, this.getSaveUsernameAndPasswordCheckboxText());
                }
            }
            credentialDialog.setVisible(true);
            credentialsAgentResponse.setCanceled(credentialDialog.isCanceled());
            if (credentialDialog.isCanceled()) {
                return credentialsAgentResponse;
            }
            credentialsAgentResponse.setUsername(credentialDialog.getUsername());
            credentialsAgentResponse.setPassword(credentialDialog.getPassword());
            if (credentialDialog.isSaveCredentials()) {
                this.store(requestorType, string, new PasswordAuthentication(credentialsAgentResponse.getUsername(), credentialsAgentResponse.getPassword()));
            } else {
                PasswordAuthentication passwordAuthentication3 = new PasswordAuthentication(credentialDialog.getUsername(), credentialDialog.getPassword());
                this.memoryCredentialsCache.put(requestorType, passwordAuthentication3);
            }
        } else {
            credentialsAgentResponse.setUsername(string2);
            credentialsAgentResponse.setPassword(string3.toCharArray());
            credentialsAgentResponse.setCanceled(false);
        }
        return credentialsAgentResponse;
    }

    public abstract String getSaveUsernameAndPasswordCheckboxText();
}

