/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.awt.Component;
import java.text.SimpleDateFormat;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class ChangesetCellRenderer
extends JLabel
implements ListCellRenderer {
    private ImageIcon icon = ImageProvider.get("data", "changeset");

    public ChangesetCellRenderer() {
        this.setOpaque(true);
    }

    protected String buildToolTipText(Changeset changeset) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        stringBuilder.append("<strong>").append(I18n.tr("Changeset id:", new Object[0])).append("</strong>").append(changeset.getId()).append("<br>");
        if (changeset.getCreatedAt() != null) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
            stringBuilder.append("<strong>").append(I18n.tr("Created at:", new Object[0])).append("</strong>").append(simpleDateFormat.format(changeset.getCreatedAt())).append("<br>");
        }
        if (changeset.get("comment") != null) {
            stringBuilder.append("<strong>").append(I18n.tr("Changeset comment:", new Object[0])).append("</strong>").append(changeset.get("comment")).append("<br>");
        }
        return stringBuilder.toString();
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        Changeset changeset = (Changeset)object;
        if (bl) {
            this.setForeground(UIManager.getColor("List.selectionForeground"));
            this.setBackground(UIManager.getColor("List.selectionBackground"));
        } else {
            this.setForeground(UIManager.getColor("List.foreground"));
            this.setBackground(UIManager.getColor("List.background"));
        }
        if (changeset != null) {
            this.setIcon(this.icon);
            StringBuffer stringBuffer = new StringBuffer();
            if (changeset.get("comment") != null) {
                stringBuffer.append(changeset.getId()).append(" - ").append(changeset.get("comment"));
            } else if (changeset.get("name") != null) {
                stringBuffer.append(changeset.getId()).append(" - ").append(changeset.get("name"));
            } else {
                stringBuffer.append(I18n.tr("Changeset {0}", changeset.getId()));
            }
            this.setText(stringBuffer.toString());
            this.setToolTipText(this.buildToolTipText(changeset));
        } else {
            this.setText(I18n.tr("No open changeset", new Object[0]));
        }
        return this;
    }
}

