/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.tags;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.gui.conflict.tags.MultiValueDecisionType;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiValueResolutionDecision {
    private MultiValueDecisionType type;
    private TagCollection tags;
    private String value;

    public MultiValueResolutionDecision() {
        this.type = MultiValueDecisionType.UNDECIDED;
        this.tags = new TagCollection();
        this.autoDecide();
    }

    public MultiValueResolutionDecision(TagCollection tagCollection) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(tagCollection, "tags");
        if (tagCollection.isEmpty()) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter ''{0}'' must not be empty.", "tags"));
        }
        if (tagCollection.getKeys().size() != 1) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter ''{0}'' with tags for exactly one key expected. Got {1}.", "tags", tagCollection.getKeys().size()));
        }
        this.tags = tagCollection;
        this.autoDecide();
    }

    protected void autoDecide() {
        this.type = MultiValueDecisionType.UNDECIDED;
        if (this.tags.size() == 1 && this.tags.getValues().contains("")) {
            this.type = MultiValueDecisionType.KEEP_NONE;
        } else if (this.tags.size() == 1) {
            this.type = MultiValueDecisionType.KEEP_ONE;
            this.value = this.tags.getValues().iterator().next();
        }
    }

    public void keepNone() {
        this.type = MultiValueDecisionType.KEEP_NONE;
    }

    public void keepAll() {
        this.type = MultiValueDecisionType.KEEP_ALL;
    }

    public void keepOne(String string) throws IllegalArgumentException, IllegalStateException {
        CheckParameterUtil.ensureParameterNotNull(string, "value");
        if (!this.tags.getValues().contains(string)) {
            throw new IllegalStateException(I18n.tr("Tag collection does not include the selected value ''{0}''.", string));
        }
        this.value = string;
        this.type = MultiValueDecisionType.KEEP_ONE;
    }

    public void setNew(String string) {
        if (string == null) {
            string = "";
        }
        this.value = string;
        this.type = MultiValueDecisionType.KEEP_ONE;
    }

    public void undecide() {
        this.type = MultiValueDecisionType.UNDECIDED;
    }

    public String getChosenValue() throws IllegalStateException {
        switch (this.type) {
            case UNDECIDED: {
                throw new IllegalStateException(I18n.tr("Not decided yet.", new Object[0]));
            }
            case KEEP_ONE: {
                return this.value;
            }
            case KEEP_NONE: {
                return null;
            }
            case KEEP_ALL: {
                return this.tags.getJoinedValues(this.getKey());
            }
        }
        return null;
    }

    public List<String> getValues() {
        ArrayList<String> arrayList = new ArrayList<String>(this.tags.getValues());
        arrayList.remove("");
        arrayList.remove(null);
        Collections.sort(arrayList);
        return arrayList;
    }

    public String getKey() {
        return this.tags.getKeys().iterator().next();
    }

    public boolean canKeepNone() {
        return this.tags.getValues().contains("");
    }

    public boolean canKeepAll() {
        return this.getValues().size() > 1;
    }

    public boolean isDecided() {
        return !this.type.equals((Object)MultiValueDecisionType.UNDECIDED);
    }

    public MultiValueDecisionType getDecisionType() {
        return this.type;
    }

    public void applyTo(OsmPrimitive osmPrimitive) throws IllegalStateException {
        if (osmPrimitive == null) {
            return;
        }
        if (!this.isDecided()) {
            throw new IllegalStateException(I18n.tr("Not decided yet.", new Object[0]));
        }
        String string = this.tags.getKeys().iterator().next();
        String string2 = this.getChosenValue();
        if (this.type.equals((Object)MultiValueDecisionType.KEEP_NONE)) {
            osmPrimitive.remove(string);
        } else {
            osmPrimitive.put(string, string2);
        }
    }

    public void applyTo(Collection<? extends OsmPrimitive> collection) throws IllegalStateException {
        if (collection == null) {
            return;
        }
        for (OsmPrimitive osmPrimitive : collection) {
            if (osmPrimitive == null) continue;
            this.applyTo(osmPrimitive);
        }
    }

    public Command buildChangeCommand(OsmPrimitive osmPrimitive) throws IllegalArgumentException, IllegalStateException {
        CheckParameterUtil.ensureParameterNotNull(osmPrimitive, "primitive");
        if (!this.isDecided()) {
            throw new IllegalStateException(I18n.tr("Not decided yet.", new Object[0]));
        }
        String string = this.tags.getKeys().iterator().next();
        String string2 = this.getChosenValue();
        ChangePropertyCommand changePropertyCommand = new ChangePropertyCommand(osmPrimitive, string, string2);
        return changePropertyCommand;
    }

    public Command buildChangeCommand(Collection<? extends OsmPrimitive> collection) {
        CheckParameterUtil.ensureParameterNotNull(collection, "primitives");
        if (!this.isDecided()) {
            throw new IllegalStateException(I18n.tr("Not decided yet.", new Object[0]));
        }
        String string = this.tags.getKeys().iterator().next();
        String string2 = this.getChosenValue();
        ChangePropertyCommand changePropertyCommand = new ChangePropertyCommand(collection, string, string2);
        return changePropertyCommand;
    }

    public Tag getResolution() {
        switch (this.type) {
            case KEEP_ALL: {
                return new Tag(this.getKey(), this.tags.getJoinedValues(this.getKey()));
            }
            case KEEP_ONE: {
                return new Tag(this.getKey(), this.value);
            }
            case KEEP_NONE: {
                return new Tag(this.getKey(), "");
            }
            case UNDECIDED: {
                return null;
            }
        }
        return null;
    }
}

