/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.plaf.basic.BasicArrowButton;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class SideButton
extends JButton {
    private static final int iconHeight = 20;

    public SideButton(Action action) {
        super(action);
        this.fixIcon(action);
        this.doStyle();
    }

    public SideButton(Action action, boolean bl) {
        super(action);
        if (!bl) {
            this.setText(null);
            this.fixIcon(action);
            this.doStyle();
        }
    }

    public SideButton(Action action, String string) {
        super(action);
        this.setIcon(SideButton.makeIcon(string));
        this.doStyle();
    }

    void fixIcon(Action action) {
        Icon icon;
        if (action != null) {
            action.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getPropertyName() == "SmallIcon") {
                        SideButton.this.fixIcon(null);
                    }
                }
            });
        }
        if ((icon = this.getIcon()) != null && icon instanceof ImageIcon && icon.getIconHeight() != 20) {
            this.setIcon(SideButton.getScaledImage(((ImageIcon)icon).getImage()));
        }
    }

    private static ImageIcon getScaledImage(Image image) {
        int n = image.getWidth(null) * 20 / image.getHeight(null);
        return new ImageIcon(image.getScaledInstance(n, 20, 4));
    }

    public static ImageIcon makeIcon(String string) {
        Image image = ImageProvider.get("dialogs", string).getImage();
        return SideButton.getScaledImage(image);
    }

    @Deprecated
    public SideButton(String string, String string2, String string3, ActionListener actionListener) {
        super(SideButton.makeIcon(string));
        this.doStyle();
        this.setActionCommand(string);
        this.addActionListener(actionListener);
        this.setToolTipText(string3);
    }

    @Deprecated
    public SideButton(String string, String string2, String string3, String string4, Shortcut shortcut, ActionListener actionListener) {
        super(I18n.tr(string, new Object[0]), SideButton.makeIcon(string2));
        if (shortcut != null) {
            shortcut.setMnemonic(this);
            if (string4 != null) {
                string4 = Main.platform.makeTooltip(string4, shortcut);
            }
        }
        this.setup(string, string3, string4, actionListener);
    }

    @Deprecated
    public SideButton(String string, String string2, String string3, String string4, ActionListener actionListener) {
        super(I18n.tr(string, new Object[0]), SideButton.makeIcon(string2));
        this.setup(string, string3, string4, actionListener);
    }

    private void setup(String string, String string2, String string3, ActionListener actionListener) {
        this.doStyle();
        this.setActionCommand(string);
        this.addActionListener(actionListener);
        this.setToolTipText(string3);
        this.putClientProperty("help", "Dialog/" + string2 + "/" + string);
    }

    private void doStyle() {
        this.setLayout(new BorderLayout());
        this.setIconTextGap(2);
        this.setMargin(new Insets(-1, 0, -1, 0));
    }

    public void createArrow(ActionListener actionListener) {
        this.setMargin(new Insets(0, 0, 0, 0));
        BasicArrowButton basicArrowButton = new BasicArrowButton(5, null, null, Color.BLACK, null);
        basicArrowButton.setBorder(BorderFactory.createEmptyBorder());
        this.add((Component)basicArrowButton, "East");
        basicArrowButton.addActionListener(actionListener);
    }
}

