/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.BelgianLambert1972;
import org.openstreetmap.josm.data.projection.BelgianLambert2008;
import org.openstreetmap.josm.data.projection.CustomProjection;
import org.openstreetmap.josm.data.projection.Ellipsoid;
import org.openstreetmap.josm.data.projection.Epsg3008;
import org.openstreetmap.josm.data.projection.Epsg4326;
import org.openstreetmap.josm.data.projection.GaussKrueger;
import org.openstreetmap.josm.data.projection.Lambert;
import org.openstreetmap.josm.data.projection.Lambert93;
import org.openstreetmap.josm.data.projection.LambertCC9Zones;
import org.openstreetmap.josm.data.projection.LambertEST;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.Puwg;
import org.openstreetmap.josm.data.projection.SwissGrid;
import org.openstreetmap.josm.data.projection.TransverseMercatorLV;
import org.openstreetmap.josm.data.projection.UTM;
import org.openstreetmap.josm.data.projection.UTM_France_DOM;
import org.openstreetmap.josm.data.projection.datum.Datum;
import org.openstreetmap.josm.data.projection.datum.WGS84Datum;
import org.openstreetmap.josm.data.projection.proj.LambertConformalConic;
import org.openstreetmap.josm.data.projection.proj.Mercator;
import org.openstreetmap.josm.data.projection.proj.Proj;
import org.openstreetmap.josm.data.projection.proj.SwissObliqueMercator;
import org.openstreetmap.josm.data.projection.proj.TransverseMercator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Projections {
    private static ArrayList<Projection> allProjections = new ArrayList<Projection>(Arrays.asList(new Epsg4326(), new org.openstreetmap.josm.data.projection.Mercator(), new UTM(), new BelgianLambert1972(), new BelgianLambert2008(), new SwissGrid(), new GaussKrueger(), new LambertEST(), new Lambert(), new Lambert93(), new LambertCC9Zones(), new UTM_France_DOM(), new TransverseMercatorLV(), new Puwg(), new Epsg3008()));
    private static Map<String, Ellipsoid> ellipsoids;
    private static Map<String, Class<? extends Proj>> projs;
    private static Map<String, Datum> datums;

    public static ArrayList<Projection> getProjections() {
        return allProjections;
    }

    public static void addProjection(Projection projection) {
        allProjections.add(projection);
    }

    public static EastNorth project(LatLon latLon) {
        if (latLon == null) {
            return null;
        }
        return Main.getProjection().latlon2eastNorth(latLon);
    }

    public static LatLon inverseProject(EastNorth eastNorth) {
        if (eastNorth == null) {
            return null;
        }
        return Main.getProjection().eastNorth2latlon(eastNorth);
    }

    public static Ellipsoid getEllipsoid(String string) {
        return ellipsoids.get(string);
    }

    public static Proj getProjection(String string) {
        Class<? extends Proj> clazz = projs.get(string);
        if (clazz == null) {
            return null;
        }
        Proj proj = null;
        try {
            proj = clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        return proj;
    }

    public static Datum getDatum(String string) {
        return datums.get(string);
    }

    static {
        if (Main.pref.getBoolean("customprojection")) {
            Projections.addProjection(new CustomProjection());
        }
        ellipsoids = new HashMap<String, Ellipsoid>();
        projs = new HashMap<String, Class<? extends Proj>>();
        datums = new HashMap<String, Datum>();
        ellipsoids.put("intl", Ellipsoid.hayford);
        ellipsoids.put("GRS80", Ellipsoid.GRS80);
        ellipsoids.put("WGS84", Ellipsoid.WGS84);
        ellipsoids.put("bessel", Ellipsoid.Bessel1841);
        projs.put("merc", Mercator.class);
        projs.put("lcc", LambertConformalConic.class);
        projs.put("somerc", SwissObliqueMercator.class);
        projs.put("tmerc", TransverseMercator.class);
        datums.put("WGS84", WGS84Datum.INSTANCE);
    }
}

