/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.io.MirroredInputStream;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class User {
    private static AtomicLong uidCounter = new AtomicLong();
    private static HashMap<Long, User> userMap = new HashMap();
    private static HashSet<Long> relicensingUsers = null;
    private static HashSet<Long> nonRelicensingUsers = null;
    private static final User anonymous = User.createLocalUser(I18n.tr("<anonymous>", new Object[0]));
    private final HashSet<String> names = new HashSet();
    private final long uid;
    private int relicensingStatus = -1;
    public static final int STATUS_UNKNOWN = -1;
    public static final int STATUS_UNDECIDED = 0;
    public static final int STATUS_AGREED = 1;
    public static final int STATUS_NOT_AGREED = 2;
    public static final int STATUS_AUTO_AGREED = 3;
    public static final int STATUS_ANONYMOUS = 4;

    private static long getNextLocalUid() {
        return uidCounter.decrementAndGet();
    }

    public static User createLocalUser(String string) {
        for (long i = -1L; i >= uidCounter.get(); --i) {
            User user = User.getById(i);
            if (user == null || !user.hasName(string)) continue;
            return user;
        }
        User user = new User(User.getNextLocalUid(), string);
        userMap.put(user.getId(), user);
        return user;
    }

    public static User createOsmUser(long l, String string) {
        User user = userMap.get(l);
        if (user == null) {
            user = new User(l, string);
            userMap.put(user.getId(), user);
        }
        if (string != null) {
            user.addName(string);
        }
        return user;
    }

    public static void clearUserMap() {
        userMap.clear();
    }

    public static User getById(long l) {
        return userMap.get(l);
    }

    public static List<User> getByName(String string) {
        if (string == null) {
            string = "";
        }
        ArrayList<User> arrayList = new ArrayList<User>();
        for (User user : userMap.values()) {
            if (!user.hasName(string)) continue;
            arrayList.add(user);
        }
        return arrayList;
    }

    public static User getAnonymous() {
        return anonymous;
    }

    public static void initRelicensingInformation() {
        if (relicensingUsers == null) {
            User.loadRelicensingInformation(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadRelicensingInformation(boolean bl) {
        Long l;
        String string;
        BufferedReader bufferedReader;
        InputStreamReader inputStreamReader;
        MirroredInputStream mirroredInputStream;
        relicensingUsers = new HashSet();
        nonRelicensingUsers = new HashSet();
        try {
            mirroredInputStream = new MirroredInputStream(Main.pref.get("url.licensechange", "http://planet.openstreetmap.org/users_agreed/users_agreed.txt"), bl ? 1L : 7200L);
            try {
                inputStreamReader = new InputStreamReader(mirroredInputStream);
                bufferedReader = new BufferedReader(inputStreamReader);
                while ((string = bufferedReader.readLine()) != null) {
                    if (string.startsWith("#")) continue;
                    try {
                        l = new Long(Long.parseLong(string.trim()));
                        relicensingUsers.add(l);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
            finally {
                mirroredInputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            mirroredInputStream = new MirroredInputStream(Main.pref.get("url.licensechange_reject", "http://planet.openstreetmap.org/users_agreed/users_disagreed.txt"), bl ? 1L : 7200L);
            try {
                inputStreamReader = new InputStreamReader(mirroredInputStream);
                bufferedReader = new BufferedReader(inputStreamReader);
                while ((string = bufferedReader.readLine()) != null) {
                    if (string.startsWith("#")) continue;
                    try {
                        l = new Long(Long.parseLong(string.trim()));
                        nonRelicensingUsers.add(l);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
            finally {
                mirroredInputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int getRelicensingStatus() {
        if (this.relicensingStatus != -1) {
            return this.relicensingStatus;
        }
        if (this.uid >= 286582L) {
            this.relicensingStatus = 3;
            return 3;
        }
        if (relicensingUsers == null) {
            return -1;
        }
        Long l = new Long(this.uid);
        if (relicensingUsers.contains(l)) {
            this.relicensingStatus = 1;
            return 1;
        }
        if (nonRelicensingUsers == null) {
            return -1;
        }
        if (nonRelicensingUsers.contains(l)) {
            this.relicensingStatus = 2;
            return 2;
        }
        return 0;
    }

    public void setRelicensingStatus(int n) {
        this.relicensingStatus = n;
    }

    public String getName() {
        return Utils.join("/", this.names);
    }

    public ArrayList<String> getNames() {
        return new ArrayList<String>(this.names);
    }

    public void addName(String string) {
        this.names.add(string);
    }

    public boolean hasName(String string) {
        return this.names.contains(string);
    }

    public long getId() {
        return this.uid;
    }

    private User(long l, String string) {
        this.uid = l;
        if (string != null) {
            this.addName(string);
        }
    }

    public boolean isOsmUser() {
        return this.uid > 0L;
    }

    public boolean isLocalUser() {
        return this.uid < 0L;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.getName().hashCode();
        n = 31 * n + (int)(this.uid ^ this.uid >>> 32);
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof User)) {
            return false;
        }
        User user = (User)object;
        return this.uid == user.uid;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("id:" + this.uid);
        if (this.names.size() == 1) {
            stringBuffer.append(" name:" + this.getName());
        } else if (this.names.size() > 1) {
            stringBuffer.append(String.format(" %d names:%s", this.names.size(), this.getName()));
        }
        return stringBuffer.toString();
    }
}

