/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import javax.swing.JCheckBoxMenuItem;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.Preferences;

public class PreferenceToggleAction
extends JosmAction
implements Preferences.PreferenceChangedListener {
    private final JCheckBoxMenuItem checkbox;
    private final String prefKey;
    private final boolean prefDefault;

    public PreferenceToggleAction(String string, String string2, String string3, boolean bl) {
        super(string, null, string2, null, false);
        this.putValue("toolbar", "toggle-" + string3);
        this.prefKey = string3;
        this.prefDefault = bl;
        this.checkbox = new JCheckBoxMenuItem(this);
        this.checkbox.setSelected(Main.pref.getBoolean(string3, bl));
        Main.pref.addPreferenceChangeListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Main.pref.put(this.prefKey, this.checkbox.isSelected());
    }

    public JCheckBoxMenuItem getCheckbox() {
        return this.checkbox;
    }

    public void preferenceChanged(Preferences.PreferenceChangeEvent preferenceChangeEvent) {
        if (this.prefKey.equals(preferenceChangeEvent.getKey())) {
            this.checkbox.setSelected(Main.pref.getBoolean(this.prefKey, this.prefDefault));
        }
    }
}

