/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinNodeWayAction
extends JosmAction {
    public JoinNodeWayAction() {
        super(I18n.tr("Join Node to Way", new Object[0]), "joinnodeway", I18n.tr("Include a node into the nearest way segments", new Object[0]), Shortcut.registerShortcut("tools:joinnodeway", I18n.tr("Tool: {0}", I18n.tr("Join Node to Way", new Object[0])), 74, 5003), true);
        this.putValue("help", HelpUtil.ht("/Action/JoinNodeWay"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        List list;
        if (!this.isEnabled()) {
            return;
        }
        Collection<Node> collection = JoinNodeWayAction.getCurrentDataSet().getSelectedNodes();
        if (collection.size() != 1) {
            return;
        }
        Node node = collection.iterator().next();
        LinkedList<Command> linkedList = new LinkedList<Command>();
        boolean bl = JoinNodeWayAction.getCurrentDataSet().getSelectedWays().size() > 0;
        List<WaySegment> list2 = Main.map.mapView.getNearestWaySegments(Main.map.mapView.getPoint(node), OsmPrimitive.isSelectablePredicate);
        HashMap<Way, ArrayList<Integer>> hashMap = new HashMap<Way, ArrayList<Integer>>();
        for (WaySegment object : list2) {
            if (bl && !object.way.isSelected()) continue;
            if (hashMap.containsKey(object.way)) {
                list = (List)hashMap.get(object.way);
            } else {
                list = new ArrayList();
                hashMap.put(object.way, (ArrayList<Integer>)list);
            }
            if (object.way.getNode(object.lowerIndex) == node || object.way.getNode(object.lowerIndex + 1) == node) continue;
            list.add(object.lowerIndex);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            list = (List)entry.getValue();
            if (list.size() == 0) continue;
            Way way = (Way)entry.getKey();
            List<Node> list3 = way.getNodes();
            JoinNodeWayAction.pruneSuccsAndReverse(list);
            Object object = list.iterator();
            while (object.hasNext()) {
                int n = (Integer)object.next();
                list3.add(n + 1, node);
            }
            object = new Way(way);
            ((Way)object).setNodes(list3);
            linkedList.add(new ChangeCommand(way, (OsmPrimitive)object));
        }
        if (linkedList.size() == 0) {
            return;
        }
        Main.main.undoRedo.add(new SequenceCommand(I18n.tr("Join Node and Line", new Object[0]), linkedList));
        Main.map.repaint();
    }

    private static void pruneSuccsAndReverse(List<Integer> list) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (int n : list) {
            if (hashSet.contains(n - 1) || hashSet.contains(n + 1)) continue;
            hashSet.add(n);
        }
        list.clear();
        list.addAll(hashSet);
        Collections.sort(list);
        Collections.reverse(list);
    }

    @Override
    protected void updateEnabledState() {
        if (JoinNodeWayAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(JoinNodeWayAction.getCurrentDataSet().getSelected());
        }
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> collection) {
        this.setEnabled(collection != null && !collection.isEmpty());
    }
}

