/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.openstreetmap.josm.io.AllFormatsImporter;
import org.openstreetmap.josm.io.FileExporter;
import org.openstreetmap.josm.io.FileImporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionFileFilter
extends FileFilter {
    public static final ArrayList<FileImporter> importers;
    public static final ArrayList<FileExporter> exporters;
    private final String extensions;
    private final String description;
    private final String defaultExtension;

    protected static void sort(List<ExtensionFileFilter> list) {
        Collections.sort(list, new Comparator<ExtensionFileFilter>(){
            private AllFormatsImporter all = new AllFormatsImporter();

            @Override
            public int compare(ExtensionFileFilter extensionFileFilter, ExtensionFileFilter extensionFileFilter2) {
                if (extensionFileFilter.getDescription().equals(this.all.filter.getDescription())) {
                    return 1;
                }
                if (extensionFileFilter2.getDescription().equals(this.all.filter.getDescription())) {
                    return -1;
                }
                return extensionFileFilter.getDescription().compareTo(extensionFileFilter2.getDescription());
            }
        });
    }

    public static void updateAllFormatsImporter() {
        for (int i = 0; i < importers.size(); ++i) {
            if (!(importers.get(i) instanceof AllFormatsImporter)) continue;
            importers.set(i, new AllFormatsImporter());
        }
    }

    public static List<ExtensionFileFilter> getImportExtensionFileFilters() {
        ExtensionFileFilter.updateAllFormatsImporter();
        LinkedList<ExtensionFileFilter> linkedList = new LinkedList<ExtensionFileFilter>();
        for (FileImporter fileImporter : importers) {
            linkedList.add(fileImporter.filter);
        }
        ExtensionFileFilter.sort(linkedList);
        return linkedList;
    }

    public static List<ExtensionFileFilter> getExportExtensionFileFilters() {
        LinkedList<ExtensionFileFilter> linkedList = new LinkedList<ExtensionFileFilter>();
        for (FileExporter fileExporter : exporters) {
            if (linkedList.contains(fileExporter.filter)) continue;
            linkedList.add(fileExporter.filter);
        }
        ExtensionFileFilter.sort(linkedList);
        return linkedList;
    }

    public static ExtensionFileFilter getDefaultImportExtensionFileFilter(String string) {
        if (string == null) {
            return new AllFormatsImporter().filter;
        }
        for (FileImporter fileImporter : importers) {
            if (!string.equals(fileImporter.filter.getDefaultExtension())) continue;
            return fileImporter.filter;
        }
        return new AllFormatsImporter().filter;
    }

    public static ExtensionFileFilter getDefaultExportExtensionFileFilter(String string) {
        if (string == null) {
            return new AllFormatsImporter().filter;
        }
        for (FileExporter fileExporter : exporters) {
            if (!string.equals(fileExporter.filter.getDefaultExtension())) continue;
            return fileExporter.filter;
        }
        return new AllFormatsImporter().filter;
    }

    public static void applyChoosableImportFileFilters(JFileChooser jFileChooser, String string) {
        for (ExtensionFileFilter extensionFileFilter : ExtensionFileFilter.getImportExtensionFileFilters()) {
            jFileChooser.addChoosableFileFilter(extensionFileFilter);
        }
        jFileChooser.setFileFilter(ExtensionFileFilter.getDefaultImportExtensionFileFilter(string));
    }

    public static void applyChoosableExportFileFilters(JFileChooser jFileChooser, String string) {
        for (ExtensionFileFilter extensionFileFilter : ExtensionFileFilter.getExportExtensionFileFilters()) {
            jFileChooser.addChoosableFileFilter(extensionFileFilter);
        }
        jFileChooser.setFileFilter(ExtensionFileFilter.getDefaultExportExtensionFileFilter(string));
    }

    public ExtensionFileFilter(String string, String string2, String string3) {
        this.extensions = string;
        this.defaultExtension = string2;
        this.description = string3;
    }

    public boolean acceptName(String string) {
        String string2 = string.toLowerCase();
        for (String string3 : this.extensions.split(",")) {
            if (!string2.endsWith("." + string3)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        return this.acceptName(file.getName());
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String getExtensions() {
        return this.extensions;
    }

    public String getDefaultExtension() {
        return this.defaultExtension;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.defaultExtension == null ? 0 : this.defaultExtension.hashCode());
        n = 31 * n + (this.description == null ? 0 : this.description.hashCode());
        n = 31 * n + (this.extensions == null ? 0 : this.extensions.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ExtensionFileFilter extensionFileFilter = (ExtensionFileFilter)object;
        if (this.defaultExtension == null ? extensionFileFilter.defaultExtension != null : !this.defaultExtension.equals(extensionFileFilter.defaultExtension)) {
            return false;
        }
        if (this.description == null ? extensionFileFilter.description != null : !this.description.equals(extensionFileFilter.description)) {
            return false;
        }
        return !(this.extensions == null ? extensionFileFilter.extensions != null : !this.extensions.equals(extensionFileFilter.extensions));
    }

    static {
        String[] stringArray;
        importers = new ArrayList();
        String[] stringArray2 = stringArray = new String[]{"org.openstreetmap.josm.io.OsmImporter", "org.openstreetmap.josm.io.OsmGzipImporter", "org.openstreetmap.josm.io.OsmChangeImporter", "org.openstreetmap.josm.io.GpxImporter", "org.openstreetmap.josm.io.NMEAImporter", "org.openstreetmap.josm.io.OsmBzip2Importer", "org.openstreetmap.josm.io.JpgImporter", "org.openstreetmap.josm.io.AllFormatsImporter"};
        int n = stringArray2.length;
        for (int i = 0; i < n; ++i) {
            String string = stringArray2[i];
            try {
                Class<?> exception = Class.forName(string);
                importers.add((FileImporter)exception.newInstance());
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        exporters = new ArrayList();
        for (String string : stringArray2 = new String[]{"org.openstreetmap.josm.io.GpxExporter", "org.openstreetmap.josm.io.OsmExporter", "org.openstreetmap.josm.io.OsmGzipExporter", "org.openstreetmap.josm.io.OsmBzip2Exporter", "org.openstreetmap.josm.io.GeoJSONExporter"}) {
            try {
                Class<?> clazz = Class.forName(string);
                exporters.add((FileExporter)clazz.newInstance());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

