/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.I18n;

public class WindowGeometry {
    private Point topLeft;
    private Dimension extent;

    public static WindowGeometry centerOnScreen(Dimension dimension) {
        return WindowGeometry.centerOnScreen(dimension, "gui.geometry");
    }

    public static WindowGeometry centerOnScreen(Dimension dimension, String string) {
        Rectangle rectangle = string != null ? WindowGeometry.getScreenInfo(string) : WindowGeometry.getFullScreenInfo();
        Point point = new Point(rectangle.x + Math.max(0, (rectangle.width - dimension.width) / 2), rectangle.y + Math.max(0, (rectangle.height - dimension.height) / 2));
        return new WindowGeometry(point, dimension);
    }

    public static WindowGeometry centerInWindow(Component component, Dimension dimension) {
        Window window = null;
        while (component != null && !(component instanceof Window)) {
            component = component.getParent();
        }
        if (component == null) {
            return new WindowGeometry(new Point(0, 0), dimension);
        }
        window = (Window)component;
        Point point = new Point(Math.max(0, (window.getSize().width - dimension.width) / 2), Math.max(0, (window.getSize().height - dimension.height) / 2));
        point.x += window.getLocation().x;
        point.y += window.getLocation().y;
        return new WindowGeometry(point, dimension);
    }

    public WindowGeometry(Point point, Dimension dimension) {
        this.topLeft = point;
        this.extent = dimension;
    }

    public WindowGeometry(Rectangle rectangle) {
        this.topLeft = rectangle.getLocation();
        this.extent = rectangle.getSize();
    }

    public WindowGeometry(Window window) {
        this(window.getLocationOnScreen(), window.getSize());
    }

    protected int parseField(String string, String string2, String string3) throws WindowGeometryException {
        String string4 = "";
        try {
            Pattern pattern = Pattern.compile(string3 + "=(-?\\d+)", 2);
            Matcher matcher = pattern.matcher(string2);
            if (!matcher.find()) {
                throw new WindowGeometryException(I18n.tr("Preference with key ''{0}'' does not include ''{1}''. Cannot restore window geometry from preferences.", string, string3));
            }
            string4 = matcher.group(1);
            return Integer.parseInt(string4);
        }
        catch (WindowGeometryException windowGeometryException) {
            throw windowGeometryException;
        }
        catch (NumberFormatException numberFormatException) {
            throw new WindowGeometryException(I18n.tr("Preference with key ''{0}'' does not provide an int value for ''{1}''. Got {2}. Cannot restore window geometry from preferences.", string, string3, string4));
        }
        catch (Exception exception) {
            throw new WindowGeometryException(I18n.tr("Failed to parse field ''{1}'' in preference with key ''{0}''. Exception was: {2}. Cannot restore window geometry from preferences.", string, string3, exception.toString()), exception);
        }
    }

    protected void initFromPreferences(String string) throws WindowGeometryException {
        String string2 = Main.pref.get(string);
        if (string2 == null || string2.equals("")) {
            throw new WindowGeometryException(I18n.tr("Preference with key ''{0}'' does not exist. Cannot restore window geometry from preferences.", string));
        }
        this.topLeft = new Point();
        this.extent = new Dimension();
        this.topLeft.x = this.parseField(string, string2, "x");
        this.topLeft.y = this.parseField(string, string2, "y");
        this.extent.width = this.parseField(string, string2, "width");
        this.extent.height = this.parseField(string, string2, "height");
    }

    protected void initFromWindowGeometry(WindowGeometry windowGeometry) {
        this.topLeft = windowGeometry.topLeft;
        this.extent = windowGeometry.extent;
    }

    public static WindowGeometry mainWindow(String string, String string2, boolean bl) {
        Object object;
        Rectangle rectangle = WindowGeometry.getScreenInfo("gui.geometry");
        if (string2 != null) {
            object = Pattern.compile("(\\d+)x(\\d+)(([+-])(\\d+)([+-])(\\d+))?").matcher(string2);
            if (((Matcher)object).matches()) {
                int n = Integer.valueOf(((Matcher)object).group(1));
                int n2 = Integer.valueOf(((Matcher)object).group(2));
                int n3 = rectangle.x;
                int n4 = rectangle.y;
                if (((Matcher)object).group(3) != null) {
                    n3 = Integer.valueOf(((Matcher)object).group(5));
                    n4 = Integer.valueOf(((Matcher)object).group(7));
                    if (((Matcher)object).group(4).equals("-")) {
                        n3 = rectangle.x + rectangle.width - n3 - n;
                    }
                    if (((Matcher)object).group(6).equals("-")) {
                        n4 = rectangle.y + rectangle.height - n4 - n2;
                    }
                }
                return new WindowGeometry(new Point(n3, n4), new Dimension(n, n2));
            }
            System.out.println(I18n.tr("Ignoring malformed geometry: {0}", string2));
        }
        object = bl ? new WindowGeometry(rectangle) : new WindowGeometry(rectangle.getLocation(), new Dimension(1000, 740));
        return new WindowGeometry(string, (WindowGeometry)object);
    }

    public WindowGeometry(String string) throws WindowGeometryException {
        this.initFromPreferences(string);
    }

    public WindowGeometry(String string, WindowGeometry windowGeometry) {
        try {
            this.initFromPreferences(string);
        }
        catch (WindowGeometryException windowGeometryException) {
            this.initFromWindowGeometry(windowGeometry);
        }
    }

    public void remember(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("x=").append(this.topLeft.x).append(",").append("y=").append(this.topLeft.y).append(",").append("width=").append(this.extent.width).append(",").append("height=").append(this.extent.height);
        Main.pref.put(string, stringBuffer.toString());
    }

    public Point getTopLeft() {
        return this.topLeft;
    }

    public Dimension getSize() {
        return this.extent;
    }

    private Rectangle getRectangle() {
        return new Rectangle(this.topLeft, this.extent);
    }

    public void applySafe(Window window) {
        Point point = new Point(this.topLeft);
        Rectangle rectangle = new Rectangle();
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        for (int i = 0; i < graphicsDeviceArray.length; ++i) {
            GraphicsDevice graphicsDevice = graphicsDeviceArray[i];
            GraphicsConfiguration[] graphicsConfigurationArray = graphicsDevice.getConfigurations();
            for (int j = 0; j < graphicsConfigurationArray.length; ++j) {
                rectangle = rectangle.union(graphicsConfigurationArray[j].getBounds());
            }
        }
        if (point.x < rectangle.x) {
            point.x = rectangle.x;
        } else if (point.x > rectangle.x + rectangle.width - this.extent.width) {
            point.x = rectangle.x + rectangle.width - this.extent.width;
        }
        if (point.y < rectangle.y) {
            point.y = rectangle.y;
        } else if (point.y > rectangle.y + rectangle.height - this.extent.height) {
            point.y = rectangle.y + rectangle.height - this.extent.height;
        }
        window.setLocation(point);
        window.setSize(this.extent);
    }

    public static Rectangle getScreenInfo(String string) {
        Rectangle rectangle = new WindowGeometry(string, new WindowGeometry(new Point(0, 0), new Dimension(10, 10))).getRectangle();
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        int n = 0;
        Rectangle rectangle2 = null;
        for (int i = 0; i < graphicsDeviceArray.length; ++i) {
            GraphicsDevice graphicsDevice = graphicsDeviceArray[i];
            GraphicsConfiguration[] graphicsConfigurationArray = graphicsDevice.getConfigurations();
            for (int j = 0; j < graphicsConfigurationArray.length; ++j) {
                Rectangle rectangle3 = graphicsConfigurationArray[j].getBounds();
                Rectangle rectangle4 = rectangle3.intersection(rectangle);
                int n2 = rectangle4.width * rectangle4.height;
                if (rectangle2 != null && n >= n2) continue;
                n = n2;
                rectangle2 = rectangle3;
            }
        }
        return rectangle2;
    }

    public static Rectangle getFullScreenInfo() {
        return new Rectangle(new Point(0, 0), Toolkit.getDefaultToolkit().getScreenSize());
    }

    public String toString() {
        return "WindowGeometry{topLeft=" + this.topLeft + ",extent=" + this.extent + "}";
    }

    public static class WindowGeometryException
    extends Exception {
        public WindowGeometryException(String string, Throwable throwable) {
            super(string, throwable);
        }

        public WindowGeometryException(String string) {
            super(string);
        }
    }
}

