/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.relation.IMemberModelListener;
import org.openstreetmap.josm.gui.dialogs.relation.MemberRoleCellEditor;
import org.openstreetmap.josm.gui.dialogs.relation.MemberTableColumnModel;
import org.openstreetmap.josm.gui.dialogs.relation.MemberTableModel;
import org.openstreetmap.josm.gui.dialogs.relation.WayConnectionType;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;

public class MemberTable
extends JTable
implements IMemberModelListener {
    protected OsmDataLayer layer;
    protected JPopupMenu popupMenu;
    private ZoomToAction zoomToAction;
    private ZoomToGapAction zoomToGap;

    public MemberTable(OsmDataLayer osmDataLayer, MemberTableModel memberTableModel) {
        super(memberTableModel, new MemberTableColumnModel(osmDataLayer.data), memberTableModel.getSelectionModel());
        this.layer = osmDataLayer;
        memberTableModel.addMemberModelListener(this);
        this.init();
    }

    protected void init() {
        MemberRoleCellEditor memberRoleCellEditor = (MemberRoleCellEditor)this.getColumnModel().getColumn(0).getCellEditor();
        this.setRowHeight(memberRoleCellEditor.getEditor().getPreferredSize().height);
        this.setAutoResizeMode(4);
        this.setSelectionMode(2);
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0, false), "selectNextColumnCell");
        this.getActionMap().put("selectNextColumnCell", new SelectNextColumnCellAction());
        this.getActionMap().put("selectPreviousColumnCell", new SelectPreviousColumnCellAction());
        this.addMouseListener(new PopupListener());
        this.addMouseListener(new DblClickHandler());
    }

    public Dimension getPreferredSize() {
        Container container;
        for (container = this.getParent(); container != null && !(container instanceof JViewport); container = container.getParent()) {
        }
        if (container != null) {
            Dimension dimension = super.getPreferredSize();
            dimension.width = container.getSize().width;
            return dimension;
        }
        return super.getPreferredSize();
    }

    public void makeMemberVisible(int n) {
        this.scrollRectToVisible(this.getCellRect(n, 0, true));
    }

    protected JPopupMenu getPopUpMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            this.zoomToAction = new ZoomToAction();
            MapView.addLayerChangeListener(this.zoomToAction);
            this.getSelectionModel().addListSelectionListener(this.zoomToAction);
            this.popupMenu.add(this.zoomToAction);
            this.zoomToGap = new ZoomToGapAction();
            MapView.addLayerChangeListener(this.zoomToGap);
            this.getSelectionModel().addListSelectionListener(this.zoomToGap);
            this.popupMenu.add(this.zoomToGap);
        }
        return this.popupMenu;
    }

    public void unlinkAsListener() {
        MapView.removeLayerChangeListener(this.zoomToAction);
        MapView.removeLayerChangeListener(this.zoomToGap);
    }

    protected MemberTableModel getMemberTableModel() {
        return (MemberTableModel)this.getModel();
    }

    private class DblClickHandler
    extends MouseAdapter {
        private DblClickHandler() {
        }

        protected void setSelection(MouseEvent mouseEvent) {
            int n = MemberTable.this.rowAtPoint(mouseEvent.getPoint());
            if (n < 0) {
                return;
            }
            OsmPrimitive osmPrimitive = MemberTable.this.getMemberTableModel().getReferredPrimitive(n);
            MemberTable.this.getMemberTableModel().getLayer().data.setSelected(osmPrimitive.getPrimitiveId());
        }

        protected void addSelection(MouseEvent mouseEvent) {
            int n = MemberTable.this.rowAtPoint(mouseEvent.getPoint());
            if (n < 0) {
                return;
            }
            OsmPrimitive osmPrimitive = MemberTable.this.getMemberTableModel().getReferredPrimitive(n);
            MemberTable.this.getMemberTableModel().getSelectionModel().addSelectionInterval(n, n);
            MemberTable.this.getMemberTableModel().getLayer().data.addSelected(osmPrimitive.getPrimitiveId());
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() > 1) {
                if (mouseEvent.isControlDown()) {
                    this.addSelection(mouseEvent);
                } else {
                    this.setSelection(mouseEvent);
                }
            }
        }
    }

    private class ZoomToGapAction
    extends AbstractAction
    implements MapView.LayerChangeListener,
    ListSelectionListener {
        private final Collection<WayConnectionType.Direction> connectionTypesOfInterest = Arrays.asList(WayConnectionType.Direction.FORWARD, WayConnectionType.Direction.BACKWARD);

        public ZoomToGapAction() {
            this.putValue("Name", I18n.tr("Zoom to Gap", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Zoom to the gap in the way sequence", new Object[0]));
            this.updateEnabledState();
        }

        private WayConnectionType getConnectionType() {
            return MemberTable.this.getMemberTableModel().getWayConnection(MemberTable.this.getSelectedRows()[0]);
        }

        private boolean hasGap() {
            WayConnectionType wayConnectionType = this.getConnectionType();
            return this.connectionTypesOfInterest.contains((Object)wayConnectionType.direction) && (!wayConnectionType.linkNext || !wayConnectionType.linkPrev);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            WayConnectionType wayConnectionType = this.getConnectionType();
            Way way = (Way)MemberTable.this.getMemberTableModel().getReferredPrimitive(MemberTable.this.getSelectedRows()[0]);
            if (!wayConnectionType.linkPrev) {
                MemberTable.this.layer.data.setSelected(WayConnectionType.Direction.FORWARD.equals((Object)wayConnectionType.direction) ? way.firstNode() : way.lastNode());
                AutoScaleAction.autoScale("selection");
            } else if (!wayConnectionType.linkNext) {
                MemberTable.this.layer.data.setSelected(WayConnectionType.Direction.FORWARD.equals((Object)wayConnectionType.direction) ? way.lastNode() : way.firstNode());
                AutoScaleAction.autoScale("selection");
            }
        }

        private void updateEnabledState() {
            this.setEnabled(Main.main != null && Main.main.getEditLayer() == MemberTable.this.layer && MemberTable.this.getSelectedRowCount() == 1 && this.hasGap());
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }

        public void activeLayerChange(Layer layer, Layer layer2) {
            this.updateEnabledState();
        }

        public void layerAdded(Layer layer) {
            this.updateEnabledState();
        }

        public void layerRemoved(Layer layer) {
            this.updateEnabledState();
        }
    }

    private class ZoomToAction
    extends AbstractAction
    implements MapView.LayerChangeListener,
    ListSelectionListener {
        public ZoomToAction() {
            this.putValue("Name", I18n.tr("Zoom to", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Zoom to the object the first selected member refers to", new Object[0]));
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.isEnabled()) {
                return;
            }
            int[] nArray = MemberTable.this.getSelectedRows();
            if (nArray == null || nArray.length == 0) {
                return;
            }
            int n = nArray[0];
            OsmPrimitive osmPrimitive = MemberTable.this.getMemberTableModel().getReferredPrimitive(n);
            MemberTable.this.layer.data.setSelected(osmPrimitive);
            AutoScaleAction.autoScale("selection");
        }

        protected void updateEnabledState() {
            if (Main.main == null || Main.main.getEditLayer() != MemberTable.this.layer) {
                this.setEnabled(false);
                this.putValue("ShortDescription", I18n.tr("Zooming disabled because layer of this relation is not active", new Object[0]));
                return;
            }
            if (MemberTable.this.getSelectedRowCount() == 0) {
                this.setEnabled(false);
                this.putValue("ShortDescription", I18n.tr("Zooming disabled because there is no selected member", new Object[0]));
                return;
            }
            this.setEnabled(true);
            this.putValue("ShortDescription", I18n.tr("Zoom to the object the first selected member refers to", new Object[0]));
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }

        public void activeLayerChange(Layer layer, Layer layer2) {
            this.updateEnabledState();
        }

        public void layerAdded(Layer layer) {
            this.updateEnabledState();
        }

        public void layerRemoved(Layer layer) {
            this.updateEnabledState();
        }
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.showPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.showPopup(mouseEvent);
        }

        private void showPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                MemberTable.this.getPopUpMenu().show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    private class SelectPreviousColumnCellAction
    extends AbstractAction {
        private SelectPreviousColumnCellAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = MemberTable.this.getSelectedColumn();
            int n2 = MemberTable.this.getSelectedRow();
            if (MemberTable.this.getCellEditor() != null) {
                MemberTable.this.getCellEditor().stopCellEditing();
            }
            if ((n > 0 || n2 > 0) && n2 > 0) {
                n = 0;
                --n2;
            }
            MemberTable.this.changeSelection(n2, n, false, false);
        }
    }

    class SelectNextColumnCellAction
    extends AbstractAction {
        SelectNextColumnCellAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.run();
        }

        public void run() {
            int n = MemberTable.this.getSelectedColumn();
            int n2 = MemberTable.this.getSelectedRow();
            if (MemberTable.this.getCellEditor() != null) {
                MemberTable.this.getCellEditor().stopCellEditing();
            }
            if (n == 0 && n2 < MemberTable.this.getRowCount() - 1) {
                ++n2;
            } else if (n2 < MemberTable.this.getRowCount() - 1) {
                n = 0;
                ++n2;
            }
            MemberTable.this.changeSelection(n2, n, false, false);
        }
    }
}

