/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.CoordinateFormat;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.IRelation;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.history.HistoryNameFormatter;
import org.openstreetmap.josm.data.osm.history.HistoryNode;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.data.osm.history.HistoryRelation;
import org.openstreetmap.josm.data.osm.history.HistoryWay;
import org.openstreetmap.josm.gui.NameFormatterHook;
import org.openstreetmap.josm.gui.tagging.TaggingPreset;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.TaggingPresetNameTemplateList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultNameFormatter
implements NameFormatter,
HistoryNameFormatter {
    private static DefaultNameFormatter instance;
    private static final LinkedList<NameFormatterHook> formatHooks;
    public static final String[] DEFAULT_NAMING_TAGS_FOR_RELATIONS;
    private static List<String> namingTagsForRelations;
    private final Comparator<Node> nodeComparator = new Comparator<Node>(){

        @Override
        public int compare(Node node, Node node2) {
            return DefaultNameFormatter.this.format(node).compareTo(DefaultNameFormatter.this.format(node2));
        }
    };
    private final Comparator<Way> wayComparator = new Comparator<Way>(){

        @Override
        public int compare(Way way, Way way2) {
            return DefaultNameFormatter.this.format(way).compareTo(DefaultNameFormatter.this.format(way2));
        }
    };
    private final Comparator<Relation> relationComparator = new Comparator<Relation>(){

        @Override
        public int compare(Relation relation, Relation relation2) {
            CharSequence charSequence;
            TaggingPreset taggingPreset = TaggingPresetNameTemplateList.getInstance().findPresetTemplate(relation);
            TaggingPreset taggingPreset2 = TaggingPresetNameTemplateList.getInstance().findPresetTemplate(relation2);
            if (taggingPreset != null || taggingPreset2 != null) {
                charSequence = new StringBuilder();
                DefaultNameFormatter.this.formatRelationNameAndType(relation, (StringBuilder)charSequence, taggingPreset);
                StringBuilder stringBuilder = new StringBuilder();
                DefaultNameFormatter.this.formatRelationNameAndType(relation2, stringBuilder, taggingPreset2);
                int n = ((StringBuilder)charSequence).toString().compareTo(stringBuilder.toString());
                if (n != 0) {
                    return n;
                }
            } else {
                String string;
                charSequence = DefaultNameFormatter.this.getRelationTypeName(relation);
                int n = ((String)charSequence).compareTo(string = DefaultNameFormatter.this.getRelationTypeName(relation2));
                if (n != 0) {
                    return n;
                }
                String string2 = DefaultNameFormatter.this.getRelationName(relation);
                String string3 = DefaultNameFormatter.this.getRelationName(relation2);
                if (string2 == null && string3 == null) {
                    return relation.getUniqueId() > relation2.getUniqueId() ? 1 : -1;
                }
                if (string2 == null) {
                    return -1;
                }
                if (string3 == null) {
                    return 1;
                }
                if (!string2.isEmpty() && !string3.isEmpty() && Character.isDigit(string2.charAt(0)) && Character.isDigit(string3.charAt(0))) {
                    String string4 = DefaultNameFormatter.this.getLeadingNumber(string2);
                    String string5 = DefaultNameFormatter.this.getLeadingNumber(string3);
                    n = Long.valueOf(string4).compareTo(Long.valueOf(string5));
                    if (n != 0) {
                        return n;
                    }
                    n = string4.compareTo(string5);
                    if (n != 0) {
                        return n;
                    }
                    n = string2.substring(string4.length()).compareTo(string3.substring(string5.length()));
                    if (n != 0) {
                        return n;
                    }
                } else {
                    n = string2.compareToIgnoreCase(string3);
                    if (n != 0) {
                        return n;
                    }
                }
            }
            if (relation.getMembersCount() != relation2.getMembersCount()) {
                return relation.getMembersCount() > relation2.getMembersCount() ? 1 : -1;
            }
            int n = Boolean.valueOf(relation.hasIncompleteMembers()).compareTo(relation2.hasIncompleteMembers());
            if (n != 0) {
                return n;
            }
            return relation.getUniqueId() > relation2.getUniqueId() ? 1 : -1;
        }
    };

    public static DefaultNameFormatter getInstance() {
        if (instance == null) {
            instance = new DefaultNameFormatter();
        }
        return instance;
    }

    public static void registerFormatHook(NameFormatterHook nameFormatterHook) {
        if (nameFormatterHook == null) {
            return;
        }
        if (!formatHooks.contains(nameFormatterHook)) {
            formatHooks.add(0, nameFormatterHook);
        }
    }

    public static void unregisterFormatHook(NameFormatterHook nameFormatterHook) {
        if (nameFormatterHook == null) {
            return;
        }
        if (formatHooks.contains(nameFormatterHook)) {
            formatHooks.remove(nameFormatterHook);
        }
    }

    public static List<String> getNamingtagsForRelations() {
        if (namingTagsForRelations == null) {
            namingTagsForRelations = new ArrayList<String>(Main.pref.getCollection("relation.nameOrder", Arrays.asList(DEFAULT_NAMING_TAGS_FOR_RELATIONS)));
        }
        return namingTagsForRelations;
    }

    protected void decorateNameWithId(StringBuilder stringBuilder, IPrimitive iPrimitive) {
        if (Main.pref.getBoolean("osm-primitives.showid")) {
            if (Main.pref.getBoolean("osm-primitives.showid.new-primitives")) {
                stringBuilder.append(I18n.tr(" [id: {0}]", iPrimitive.getUniqueId()));
            } else {
                stringBuilder.append(I18n.tr(" [id: {0}]", iPrimitive.getId()));
            }
        }
    }

    @Override
    public String format(Node node) {
        String string;
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        if (node.isIncomplete()) {
            stringBuilder.append(I18n.tr("incomplete", new Object[0]));
        } else {
            object = TaggingPresetNameTemplateList.getInstance().findPresetTemplate(node);
            if (object == null) {
                Object object2 = Main.pref.getBoolean("osm-primitives.localize-name", true) ? node.getLocalName() : node.getName();
                if (object2 == null) {
                    String string2;
                    String object3 = node.get("addr:housename");
                    if (object3 != null) {
                        object2 = I18n.tr("House {0}", object3);
                    }
                    if (object2 == null && (string2 = node.get("addr:housenumber")) != null) {
                        string = node.get("addr:street");
                        object2 = string != null ? I18n.tr("House number {0} at {1}", string2, string) : I18n.tr("House number {0}", string2);
                    }
                }
                if (object2 == null) {
                    object2 = node.isNew() ? I18n.tr("node", new Object[0]) : "" + node.getId();
                }
                stringBuilder.append((String)object2);
            } else {
                ((TaggingPreset)object).nameTemplate.appendText(stringBuilder, node);
            }
            stringBuilder.append(" \u200e(").append(node.getCoor().latToString(CoordinateFormat.getDefaultFormat())).append(", ").append(node.getCoor().lonToString(CoordinateFormat.getDefaultFormat())).append(")");
        }
        this.decorateNameWithId(stringBuilder, node);
        object = stringBuilder.toString();
        for (NameFormatterHook nameFormatterHook : formatHooks) {
            string = nameFormatterHook.checkFormat(node, (String)object);
            if (string == null) continue;
            return string;
        }
        return object;
    }

    @Override
    public Comparator<Node> getNodeComparator() {
        return this.nodeComparator;
    }

    @Override
    public String format(Way way) {
        String string;
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        if (way.isIncomplete()) {
            stringBuilder.append(I18n.tr("incomplete", new Object[0]));
        } else {
            object = TaggingPresetNameTemplateList.getInstance().findPresetTemplate(way);
            if (object == null) {
                String string2 = Main.pref.getBoolean("osm-primitives.localize-name", true) ? way.getLocalName() : way.getName();
                if (string2 == null) {
                    string2 = way.get("ref");
                }
                if (string2 == null) {
                    String string3 = way.get("highway") != null ? I18n.tr("highway", new Object[0]) : (way.get("railway") != null ? I18n.tr("railway", new Object[0]) : (way.get("waterway") != null ? I18n.tr("waterway", new Object[0]) : (string2 = way.get("landuse") != null ? I18n.tr("landuse", new Object[0]) : null)));
                }
                if (string2 == null) {
                    String string4;
                    String object2 = way.get("addr:housename");
                    if (object2 != null) {
                        string2 = I18n.tr("House {0}", object2);
                    }
                    if (string2 == null && (string4 = way.get("addr:housenumber")) != null) {
                        string = way.get("addr:street");
                        string2 = string != null ? I18n.tr("House number {0} at {1}", string4, string) : I18n.tr("House number {0}", string4);
                    }
                }
                if (string2 == null && way.get("building") != null) {
                    string2 = I18n.tr("building", new Object[0]);
                }
                if (string2 == null || string2.length() == 0) {
                    string2 = String.valueOf(way.getId());
                }
                stringBuilder.append(string2);
            } else {
                ((TaggingPreset)object).nameTemplate.appendText(stringBuilder, way);
            }
            int n = way.getNodesCount();
            if (n > 1 && way.isClosed()) {
                --n;
            }
            String string5 = I18n.trn("{0} node", "{0} nodes", n, n);
            stringBuilder.append(" (").append(string5).append(")");
        }
        this.decorateNameWithId(stringBuilder, way);
        object = stringBuilder.toString();
        for (NameFormatterHook nameFormatterHook : formatHooks) {
            string = nameFormatterHook.checkFormat(way, (String)object);
            if (string == null) continue;
            return string;
        }
        return object;
    }

    @Override
    public Comparator<Way> getWayComparator() {
        return this.wayComparator;
    }

    @Override
    public String format(Relation relation) {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        if (relation.isIncomplete()) {
            stringBuilder.append(I18n.tr("incomplete", new Object[0]));
        } else {
            object = TaggingPresetNameTemplateList.getInstance().findPresetTemplate(relation);
            this.formatRelationNameAndType(relation, stringBuilder, (TaggingPreset)object);
            int n = relation.getMembersCount();
            stringBuilder.append(I18n.trn("{0} member", "{0} members", n, n));
            if (relation.hasIncompleteMembers()) {
                stringBuilder.append(", ").append(I18n.tr("incomplete", new Object[0]));
            }
            stringBuilder.append(")");
        }
        this.decorateNameWithId(stringBuilder, relation);
        object = stringBuilder.toString();
        for (NameFormatterHook nameFormatterHook : formatHooks) {
            String string = nameFormatterHook.checkFormat(relation, (String)object);
            if (string == null) continue;
            return string;
        }
        return object;
    }

    private void formatRelationNameAndType(Relation relation, StringBuilder stringBuilder, TaggingPreset taggingPreset) {
        if (taggingPreset == null) {
            stringBuilder.append(this.getRelationTypeName(relation));
            String string = this.getRelationName(relation);
            string = string == null ? Long.toString(relation.getId()) : "\"" + string + "\"";
            stringBuilder.append(" (").append(string).append(", ");
        } else {
            taggingPreset.nameTemplate.appendText(stringBuilder, relation);
            stringBuilder.append("(");
        }
    }

    @Override
    public Comparator<Relation> getRelationComparator() {
        return this.relationComparator;
    }

    private String getLeadingNumber(String string) {
        int n;
        for (n = 0; n < string.length() && Character.isDigit(string.charAt(n)); ++n) {
        }
        return string.substring(0, n);
    }

    private String getRelationTypeName(IRelation iRelation) {
        String string;
        String string2 = I18n.trc("Relation type", iRelation.get("type"));
        if (string2 == null) {
            String string3 = string2 = iRelation.get("public_transport") != null ? I18n.tr("public transport", new Object[0]) : null;
        }
        if (string2 == null) {
            string = iRelation.get("building");
            if (OsmUtils.isTrue(string)) {
                string2 = I18n.tr("building", new Object[0]);
            } else if (string != null) {
                string2 = I18n.tr(string, new Object[0]);
            }
        }
        if (string2 == null) {
            string2 = I18n.trc("Place type", iRelation.get("place"));
        }
        if (string2 == null) {
            string2 = I18n.tr("relation", new Object[0]);
        }
        if ((string = iRelation.get("admin_level")) != null) {
            string2 = string2 + "[" + string + "]";
        }
        for (NameFormatterHook nameFormatterHook : formatHooks) {
            String string4 = nameFormatterHook.checkRelationTypeName(iRelation, string2);
            if (string4 == null) continue;
            return string4;
        }
        return string2;
    }

    private String getNameTagValue(IRelation iRelation, String string) {
        if (string.equals("name")) {
            if (Main.pref.getBoolean("osm-primitives.localize-name", true)) {
                return iRelation.getLocalName();
            }
            return iRelation.getName();
        }
        if (string.equals(":LocationCode")) {
            for (String string2 : iRelation.keySet()) {
                if (!string2.endsWith(string)) continue;
                return iRelation.get(string2);
            }
            return null;
        }
        if (string.startsWith("?") && OsmUtils.isTrue(iRelation.get(string.substring(1)))) {
            return I18n.tr(string.substring(1), new Object[0]);
        }
        if (string.startsWith("?") && OsmUtils.isFalse(iRelation.get(string.substring(1)))) {
            return null;
        }
        return I18n.trc_lazy(string, I18n.escape(iRelation.get(string)));
    }

    private String getRelationName(IRelation iRelation) {
        String string = null;
        for (String string2 : DefaultNameFormatter.getNamingtagsForRelations()) {
            string = this.getNameTagValue(iRelation, string2);
            if (string == null) continue;
            return string;
        }
        return null;
    }

    @Override
    public String format(Changeset changeset) {
        return I18n.tr("Changeset {0}", changeset.getId());
    }

    public String buildDefaultToolTip(IPrimitive iPrimitive) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        stringBuilder.append("<strong>id</strong>=").append(iPrimitive.getId()).append("<br>");
        ArrayList<String> arrayList = new ArrayList<String>(iPrimitive.keySet());
        Collections.sort(arrayList);
        for (int i = 0; i < arrayList.size(); ++i) {
            if (i > 0) {
                stringBuilder.append("<br>");
            }
            String string = arrayList.get(i);
            stringBuilder.append("<strong>").append(string).append("</strong>").append("=");
            String string2 = iPrimitive.get(string);
            while (string2.length() != 0) {
                stringBuilder.append(string2.substring(0, Math.min(50, string2.length())));
                if (string2.length() > 50) {
                    stringBuilder.append("<br>");
                    string2 = string2.substring(50);
                    continue;
                }
                string2 = "";
            }
        }
        stringBuilder.append("</html>");
        return stringBuilder.toString();
    }

    protected void decorateNameWithId(StringBuilder stringBuilder, HistoryOsmPrimitive historyOsmPrimitive) {
        if (Main.pref.getBoolean("osm-primitives.showid")) {
            stringBuilder.append(I18n.tr(" [id: {0}]", historyOsmPrimitive.getId()));
        }
    }

    @Override
    public String format(HistoryNode historyNode) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = Main.pref.getBoolean("osm-primitives.localize-name", true) ? historyNode.getLocalName() : historyNode.getName();
        if (string == null) {
            stringBuilder.append(historyNode.getId());
        } else {
            stringBuilder.append(string);
        }
        stringBuilder.append(" (").append(historyNode.getCoords().latToString(CoordinateFormat.getDefaultFormat())).append(", ").append(historyNode.getCoords().lonToString(CoordinateFormat.getDefaultFormat())).append(")");
        this.decorateNameWithId(stringBuilder, historyNode);
        return stringBuilder.toString();
    }

    @Override
    public String format(HistoryWay historyWay) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = Main.pref.getBoolean("osm-primitives.localize-name", true) ? historyWay.getLocalName() : historyWay.getName();
        if (string != null) {
            stringBuilder.append(string);
        }
        if (stringBuilder.length() == 0 && historyWay.get("ref") != null) {
            stringBuilder.append(historyWay.get("ref"));
        }
        if (stringBuilder.length() == 0) {
            stringBuilder.append(historyWay.get("highway") != null ? I18n.tr("highway", new Object[0]) : (historyWay.get("railway") != null ? I18n.tr("railway", new Object[0]) : (historyWay.get("waterway") != null ? I18n.tr("waterway", new Object[0]) : (historyWay.get("landuse") != null ? I18n.tr("landuse", new Object[0]) : ""))));
        }
        int n = historyWay.isClosed() ? historyWay.getNumNodes() - 1 : historyWay.getNumNodes();
        String string2 = I18n.trn("{0} node", "{0} nodes", n, n);
        if (stringBuilder.length() == 0) {
            stringBuilder.append(historyWay.getId());
        }
        stringBuilder.append(stringBuilder.length() > 0 ? " (" + string2 + ")" : string2);
        this.decorateNameWithId(stringBuilder, historyWay);
        return stringBuilder.toString();
    }

    @Override
    public String format(HistoryRelation historyRelation) {
        StringBuilder stringBuilder = new StringBuilder();
        if (historyRelation.get("type") != null) {
            stringBuilder.append(historyRelation.get("type"));
        } else {
            stringBuilder.append(I18n.tr("relation", new Object[0]));
        }
        stringBuilder.append(" (");
        String string = null;
        HashSet<String> hashSet = new HashSet<String>(DefaultNameFormatter.getNamingtagsForRelations());
        for (String string2 : historyRelation.getTags().keySet()) {
            if (hashSet.contains(string2.trim()) && (string = Main.pref.getBoolean("osm-primitives.localize-name", true) ? historyRelation.getLocalName() : historyRelation.getName()) == null) {
                string = historyRelation.get(string2);
            }
            if (string == null) continue;
            break;
        }
        if (string == null) {
            stringBuilder.append(Long.toString(historyRelation.getId())).append(", ");
        } else {
            stringBuilder.append("\"").append(string).append("\", ");
        }
        int n = historyRelation.getNumMembers();
        stringBuilder.append(I18n.trn("{0} member", "{0} members", n, n)).append(")");
        this.decorateNameWithId(stringBuilder, historyRelation);
        return stringBuilder.toString();
    }

    public String buildDefaultToolTip(HistoryOsmPrimitive historyOsmPrimitive) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        stringBuilder.append("<strong>id</strong>=").append(historyOsmPrimitive.getId()).append("<br>");
        ArrayList<String> arrayList = new ArrayList<String>(historyOsmPrimitive.getTags().keySet());
        Collections.sort(arrayList);
        for (int i = 0; i < arrayList.size(); ++i) {
            if (i > 0) {
                stringBuilder.append("<br>");
            }
            String string = arrayList.get(i);
            stringBuilder.append("<strong>").append(string).append("</strong>").append("=");
            String string2 = historyOsmPrimitive.get(string);
            while (string2.length() != 0) {
                stringBuilder.append(string2.substring(0, Math.min(50, string2.length())));
                if (string2.length() > 50) {
                    stringBuilder.append("<br>");
                    string2 = string2.substring(50);
                    continue;
                }
                string2 = "";
            }
        }
        stringBuilder.append("</html>");
        return stringBuilder.toString();
    }

    static {
        formatHooks = new LinkedList();
        DEFAULT_NAMING_TAGS_FOR_RELATIONS = new String[]{"name", "ref", "restriction", "landuse", "natural", "public_transport", ":LocationCode", "note", "?building"};
        namingTagsForRelations = null;
    }
}

