/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection.proj;

import org.openstreetmap.josm.data.projection.Ellipsoid;
import org.openstreetmap.josm.data.projection.proj.Proj;
import org.openstreetmap.josm.tools.I18n;

public class LambertConformalConic
implements Proj {
    protected Ellipsoid ellps;
    protected double e;
    private Parameters params;
    protected double n;
    protected double F;
    protected double r0;
    protected static final double epsilon = 1.0E-12;

    public void updateParameters2SP(Ellipsoid ellipsoid, double d, double d2, double d3) {
        this.params = new Parameters2SP(d, d2, d3);
        this.ellps = ellipsoid;
        this.e = ellipsoid.e;
        double d4 = this.m(Math.toRadians(d2));
        double d5 = this.m(Math.toRadians(d3));
        double d6 = this.t(Math.toRadians(d2));
        double d7 = this.t(Math.toRadians(d3));
        double d8 = this.t(Math.toRadians(d));
        this.n = (Math.log(d4) - Math.log(d5)) / (Math.log(d6) - Math.log(d7));
        this.F = d4 / (this.n * Math.pow(d6, this.n));
        this.r0 = this.F * Math.pow(d8, this.n);
    }

    public void updateParameters1SP(Ellipsoid ellipsoid, double d) {
        this.params = new Parameters1SP(d);
        this.ellps = ellipsoid;
        this.e = ellipsoid.e;
        double d2 = Math.toRadians(d);
        double d3 = this.m(d2);
        double d4 = this.t(d2);
        this.n = Math.sin(d2);
        this.F = d3 / (this.n * Math.pow(d4, this.n));
        this.r0 = this.F * Math.pow(d4, this.n);
    }

    public void updateParametersDirect(Ellipsoid ellipsoid, double d, double d2, double d3) {
        this.params = null;
        this.ellps = ellipsoid;
        this.e = ellipsoid.e;
        this.n = d;
        this.F = d2;
        this.r0 = d3;
    }

    protected double t(double d) {
        return Math.tan(0.7853981633974483 - d / 2.0) / Math.pow((1.0 - this.e * Math.sin(d)) / (1.0 + this.e * Math.sin(d)), this.e / 2.0);
    }

    protected double m(double d) {
        return Math.cos(d) / Math.sqrt(1.0 - this.e * this.e * Math.pow(Math.sin(d), 2.0));
    }

    public String getName() {
        return I18n.tr("Lambert Conformal Conic", new Object[0]);
    }

    public String getProj4Id() {
        return "lcc";
    }

    public double[] project(double d, double d2) {
        double d3 = Math.sin(d);
        double d4 = 0.5 * Math.log((1.0 + d3) / (1.0 - d3)) - this.e / 2.0 * Math.log((1.0 + this.e * d3) / (1.0 - this.e * d3));
        double d5 = this.F * Math.exp(-this.n * d4);
        double d6 = this.n * d2;
        double d7 = d5 * Math.sin(d6);
        double d8 = this.r0 - d5 * Math.cos(d6);
        return new double[]{d7, d8};
    }

    public double[] invproject(double d, double d2) {
        double d3 = Math.sqrt(Math.pow(d, 2.0) + Math.pow(d2 - this.r0, 2.0));
        double d4 = Math.atan(d / (this.r0 - d2));
        double d5 = d4 / this.n;
        double d6 = -1.0 / this.n * Math.log(Math.abs(d3 / this.F));
        double d7 = this.ellps.latitude(d6, this.e, 1.0E-12);
        return new double[]{d7, d5};
    }

    public final Parameters getParameters() {
        return this.params;
    }

    public static class Parameters2SP
    extends Parameters {
        public final double standardParallel1;
        public final double standardParallel2;

        public Parameters2SP(double d, double d2, double d3) {
            super(d);
            this.standardParallel1 = d2;
            this.standardParallel2 = d3;
        }
    }

    public static class Parameters1SP
    extends Parameters {
        public Parameters1SP(double d) {
            super(d);
        }
    }

    public static abstract class Parameters {
        public final double latitudeOrigin;

        public Parameters(double d) {
            this.latitudeOrigin = d;
        }
    }
}

