/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection;

import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.AbstractProjection;
import org.openstreetmap.josm.data.projection.Ellipsoid;
import org.openstreetmap.josm.data.projection.datum.GRS80Datum;
import org.openstreetmap.josm.data.projection.proj.LambertConformalConic;
import org.openstreetmap.josm.tools.I18n;

public class BelgianLambert2008
extends AbstractProjection {
    public BelgianLambert2008() {
        this.ellps = Ellipsoid.GRS80;
        this.datum = GRS80Datum.INSTANCE;
        this.x_0 = 649328.0;
        this.y_0 = 665262.0;
        this.lon_0 = BelgianLambert2008.convertDegreeMinuteSecond(4.0, 21.0, 33.177);
        double d = BelgianLambert2008.convertDegreeMinuteSecond(50.0, 47.0, 52.134);
        double d2 = BelgianLambert2008.convertDegreeMinuteSecond(49.0, 50.0, 0.0);
        double d3 = BelgianLambert2008.convertDegreeMinuteSecond(51.0, 10.0, 0.0);
        this.proj = new LambertConformalConic();
        ((LambertConformalConic)this.proj).updateParameters2SP(this.ellps, d, d2, d3);
    }

    public String getCacheDirectoryName() {
        return "belgianLambert2008";
    }

    public Bounds getWorldBoundsLatLon() {
        return new Bounds(new LatLon(49.51, 2.54), new LatLon(51.5, 6.4));
    }

    public Integer getEpsgCode() {
        return 3812;
    }

    public String toString() {
        return I18n.tr("Belgian Lambert 2008", new Object[0]);
    }
}

